unit AspNetEcoC1EcoSpace;

interface

uses
  System.Threading,
  Borland.Eco.Services,
  Borland.Eco.UmlCodeAttributes,
  Borland.Eco.Persistence,
  Borland.Eco.Handles,
  Package_1Unit;

type
  [EcoSpace]
  [EcoSpacePackage(TypeOf(Package_1Unit.Package_1))]
  TAspNetEcoC1EcoSpace = class(Borland.Eco.Handles.DefaultEcoSpace)
  private
    PersistenceMapperSharer1: Borland.Eco.Persistence.PersistenceMapperSharer;
    procedure InitializeComponent;
    class var fTypeSystemProvider: ITypeSystemService;
    class var fTypeSystemProviderLock: Tobject;
  strict protected
    function GetTypeSystemProvider: ITypeSystemService; override;
  public
    constructor Create;
    class constructor Create;
    class function GetTypeSystemService: ITypeSystemService; static;
    procedure UpdateDatabase;
    function get_PersistenceService: IPersistenceService;
    property PersistenceService: IPersistenceService read get_PersistenceService;
    function get_DirtyListService: IDirtyListService;
    property DirtyListService: IDirtyListService read get_DirtyListService;
    function get_UndoService: IUndoService;
    property UndoService: IUndoService read get_UndoService;
    function get_TypeSystemService: ITypeSystemService;
    property TypeSystemService: ITypeSystemService read get_TypeSystemService;
    function get_OclService: IOclService;
    property OclService: IOclService read get_OclService;
    function get_ObjectFactoryService: IObjectFactoryService;
    property ObjectFactoryService: IObjectFactoryService read get_ObjectFactoryService;
    function get_VariableFactoryService: IVariableFactoryService;
    property VariableFactoryService: IVariableFactoryService read get_VariableFactoryService;
  end;

  [assembly: RuntimeRequired(TypeOf(TAspNetEcoC1EcoSpace))]

implementation
{$AUTOBOX ON}
uses
  EcoPersistenceMapperProvider;

constructor TAspNetEcoC1EcoSpace.Create;
begin
  inherited Create;
  InitializeComponent;
  // TODO: Add any constructor code here
end;

class constructor TAspNetEcoC1EcoSpace.Create;
begin
  fTypeSystemProviderLock := TObject.Create;
end;

procedure TAspNetEcoC1EcoSpace.InitializeComponent;
begin
  Self.PersistenceMapperSharer1 := Borland.Eco.Persistence.PersistenceMapperSharer.Create;
  //
  // PersistenceMapperSharer1
  //
  Self.PersistenceMapperSharer1.MapperProviderType := TypeOf(TEcoPersistenceMapperProvider);
  //
  // TWebApplication11EcoSpace
  //
  Self.PersistenceMapper := Self.PersistenceMapperSharer1;
end;

class function TAspNetEcoC1EcoSpace.GetTypeSystemService: ITypeSystemService;
begin
  if not Assigned(fTypeSystemProvider) then
  begin
    try
      Monitor.Enter(fTypeSystemProviderLock);
      if not Assigned(fTypeSystemProvider) then
        fTypeSystemProvider := MakeTypeService(typeOf(TAspNetEcoC1EcoSpace));
    finally
      Monitor.Exit(fTypeSystemProviderLock);
    end;
  end;
  Result := fTypeSystemProvider;
end;

function TAspNetEcoC1EcoSpace.GetTypeSystemProvider: ITypeSystemService;
begin
  Result := TAspNetEcoC1EcoSpace.GetTypeSystemService;
end;

procedure TAspNetEcoC1EcoSpace.UpdateDatabase;
begin
  if Assigned(PersistenceService) and Assigned(DirtyListService) then
    PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects);
end;

function TAspNetEcoC1EcoSpace.get_PersistenceService: IPersistenceService;
begin
  Result := GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
end;

function TAspNetEcoC1EcoSpace.get_DirtyListService: IDirtyListService;
begin
  Result := GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
end;

function TAspNetEcoC1EcoSpace.get_UndoService: IUndoService;
begin
  Result := GetEcoService(typeof(IUndoService)) as IUndoService;
end;

function TAspNetEcoC1EcoSpace.get_TypeSystemService: ITypeSystemService;
begin
  Result := GetEcoService(typeof(ITypeSystemService)) as ITypeSystemService;
end;

function TAspNetEcoC1EcoSpace.get_OclService: IOclService;
begin
  Result := GetEcoService(typeof(IOclService)) as IOclService;
end;

function TAspNetEcoC1EcoSpace.get_ObjectFactoryService: IObjectFactoryService;
begin
  Result := GetEcoService(typeof(IObjectFactoryService)) as IObjectFactoryService;
end;

function TAspNetEcoC1EcoSpace.get_VariableFactoryService: IVariableFactoryService;
begin
  Result := GetEcoService(typeof(IVariableFactoryService)) as IVariableFactoryService;
end;

end.
