unit EcoSpaceProvider;

interface

uses
  Borland.Eco.Handles,
  Borland.Eco.Web,
  AspNetEcoC1EcoSpace;

const
  // ToDo: Configure the strategy for the provider by changing the constant
  MODE: EcoSpaceStrategyHandler.SessionStateMode = EcoSpaceStrategyHandler.SessionStateMode.IfDirty;
   
type
  TEcoSpaceProvider = class
  public
		class function GetEcoSpace: TAspNetEcoC1EcoSpace; static;
    class procedure ReturnEcoSpace(aEcoSpace: EcoSpace); static;
		class function GetSessionFreeEcoSpace: TAspNetEcoC1EcoSpace; static;
    class procedure ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace); static;
    class procedure ClearSessionState; static;
  end;

implementation

// Utility methods

function GetHandler: EcoSpaceStrategyHandler;
begin
  Result := EcoSpaceStrategyHandler.Create(MODE, typeof(TAspNetEcoC1EcoSpace));
end;

{ TEcoSpaceProvider }

class procedure TEcoSpaceProvider.ClearSessionState;
begin
  GetHandler.ClearSessionState;
end;

class function TEcoSpaceProvider.GetEcoSpace(): TAspNetEcoC1EcoSpace;
begin
  Result := TAspNetEcoC1EcoSpace(GetHandler.GetEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnEcoSpace(aEcoSpace);
end;

class function TEcoSpaceProvider.GetSessionFreeEcoSpace(): TAspNetEcoC1EcoSpace;
begin
  Result := TAspNetEcoC1EcoSpace(GetHandler.GetSessionFreeEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnSessionFreeEcoSpace(aEcoSpace);
end;

end.
