unit Package_1Unit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes, Borland.Eco.Subscription;

type
  Pedido = class;
  Item = class;
  Produto = class;
  [UmlElement('Package', Id='5AF21B0D-5E3E-4F88-A50D-43A2E90C631E')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Pedido))]
  [UmlMetaAttribute('ownedElement', TypeOf(Produto))]
  [UmlMetaAttribute('ownedElement', TypeOf(Item))]
  Package_1 = class
  public
  type 

    [UmlElement('Association', Id='90b1139e-eba3-49a2-8b7c-ec407aab1e38')]
    ItemItemsPedidoPedido = class
    end;

    [UmlElement('Association', Id='48d5f8e2-8d7e-4937-95ec-edca8b89dd80')]
    ProdutoProdutoItemItems = class
    end;end;

  [assembly: RuntimeRequired(TypeOf(Package_1))]
  IPedidoList = interface;
  
  [UmlCollection(TypeOf(Pedido))]
  IPedidoList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Pedido;
    procedure set_Item(index: Integer; Value: Pedido);
    property Item[index: Integer]: Pedido read get_Item write set_Item; default;
    function Add(value: Pedido): Integer;
    function Contains(value: Pedido): Boolean;
    function IndexOf(value: Pedido): Integer;
    procedure Insert(index: Integer; value: Pedido);
    procedure Remove(value: Pedido);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  IItemList = interface;
  
  [UmlElement(Id='26f8fc19-8526-46ad-b815-b8d71c6bc2f3')]
  Pedido = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 3);
    const
      Entrega = Eco_FirstMember;
    const
      Data = (Eco_LoopbackIndices.Entrega + 1);
    const
      Items = (Eco_LoopbackIndices.Data + 1);
    end;

    PedidoListAdapter = class(ObjectListAdapter, IPedidoList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Pedido;
      procedure set_Item(index: Integer; Value: Pedido);
      property Item[index: Integer]: Pedido read get_Item write set_Item; default;
      function Add(value: Pedido): Integer;
      function Contains(value: Pedido): Boolean;
      function IndexOf(value: Pedido): Integer;
      procedure Insert(index: Integer; value: Pedido);
      procedure Remove(value: Pedido);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Items: IItemList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Items, Id='954f1561-1' +
    '2b0-4043-a144-4754e8bb8a66')]
    [UmlMetaAttribute('association', TypeOf(Package_1.ItemItemsPedidoPedido), Index=1)]
    [UmlMetaAttribute('multiplicity', '1..*')]
    property Items: IItemList read get_Items;
    function get_Data: System.DateTime;
    procedure set_Data(Value: System.DateTime);
    [UmlElement(Id='afa4d206-6e83-4117-ac6f-d169b5c4235a', Index=Eco_LoopbackIndices.Data)]
    property Data: System.DateTime read get_Data write set_Data;
    function get_Entrega: string;
    procedure set_Entrega(Value: string);
    [UmlElement(Id='ae883c1b-3697-4c74-b3f2-20017a98e381', Index=Eco_LoopbackIndices.Entrega)]
    property Entrega: string read get_Entrega write set_Entrega;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  IProdutoList = interface;
  
  [UmlCollection(TypeOf(Produto))]
  IProdutoList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Produto;
    procedure set_Item(index: Integer; Value: Produto);
    property Item[index: Integer]: Produto read get_Item write set_Item; default;
    function Add(value: Produto): Integer;
    function Contains(value: Produto): Boolean;
    function IndexOf(value: Produto): Integer;
    procedure Insert(index: Integer; value: Produto);
    procedure Remove(value: Produto);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='bdb7b649-d658-402b-abe1-efb679832241')]
  Produto = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 3);
    const
      Descricao = Eco_FirstMember;
    const
      Valor = (Eco_LoopbackIndices.Descricao + 1);
    const
      Items = (Eco_LoopbackIndices.Valor + 1);
    end;

    ProdutoListAdapter = class(ObjectListAdapter, IProdutoList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Produto;
      procedure set_Item(index: Integer; Value: Produto);
      property Item[index: Integer]: Produto read get_Item write set_Item; default;
      function Add(value: Produto): Integer;
      function Contains(value: Produto): Boolean;
      function IndexOf(value: Produto): Integer;
      procedure Insert(index: Integer; value: Produto);
      procedure Remove(value: Produto);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Items: IItemList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Items, Id='219f6feb-5' +
    '077-4d4a-b5be-82841f82e409')]
    [UmlMetaAttribute('association', TypeOf(Package_1.ProdutoProdutoItemItems), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property Items: IItemList read get_Items;
    function get_Descricao: string;
    procedure set_Descricao(Value: string);
    [UmlElement(Id='52ece2b0-dfc2-4245-8ded-2197c6541c2e', Index=Eco_LoopbackIndices.Descricao)]
    property Descricao: string read get_Descricao write set_Descricao;
    function get_Valor: System.Double;
    procedure set_Valor(Value: System.Double);
    [UmlElement(Id='a107b6a9-5df9-4f74-8401-4e4b72292479', Index=Eco_LoopbackIndices.Valor)]
    property Valor: System.Double read get_Valor write set_Valor;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  
  [UmlCollection(TypeOf(Item))]
  IItemList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Item;
    procedure set_Item(index: Integer; Value: Item);
    property Item[index: Integer]: Item read get_Item write set_Item; default;
    function Add(value: Item): Integer;
    function Contains(value: Item): Boolean;
    function IndexOf(value: Item): Integer;
    procedure Insert(index: Integer; value: Item);
    procedure Remove(value: Item);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='25445826-64a1-4deb-b1b4-731f6af13097')]
  Item = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 4);
    const
      Quantidade = Eco_FirstMember;
    const
      Total = (Eco_LoopbackIndices.Quantidade + 1);
    const
      Pedido = (Eco_LoopbackIndices.Total + 1);
    const
      Produto = (Eco_LoopbackIndices.Pedido + 1);
    end;

    ItemListAdapter = class(ObjectListAdapter, IItemList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Item;
      procedure set_Item(index: Integer; Value: Item);
      property Item[index: Integer]: Item read get_Item write set_Item; default;
      function Add(value: Item): Integer;
      function Contains(value: Item): Boolean;
      function IndexOf(value: Item): Integer;
      procedure Insert(index: Integer; value: Item);
      procedure Remove(value: Item);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Pedido: Pedido;
    procedure set_Pedido(Value: Pedido);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Pedido, Id=('7c5ca729' +
    '-' + '8188-46e8-9a76-a9ba27696283'))]
    [UmlMetaAttribute('association', TypeOf(Package_1.ItemItemsPedidoPedido), Index=0)]
    [UmlMetaAttribute('multiplicity', '1')]
    property Pedido: Pedido read get_Pedido write set_Pedido;
    function get_Produto: Produto;
    procedure set_Produto(Value: Produto);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Produto, Id=('d1e43f4' +
    '6' + '-32bb-495d-a286-4f10142b89c7'))]
    [UmlMetaAttribute('association', TypeOf(Package_1.ProdutoProdutoItemItems), Index=1)]
    [UmlMetaAttribute('multiplicity', '1')]
    property Produto: Produto read get_Produto write set_Produto;
    function get_Quantidade: Integer;
    procedure set_Quantidade(Value: Integer);
    [UmlElement(Id='cd0a382a-ca1c-402a-86d8-f580c96f6e66', Index=Eco_LoopbackIndices.Quantidade)]
    property Quantidade: Integer read get_Quantidade write set_Quantidade;
    function get_Total: System.Double;
    [UmlElement(Id='e7d97a71-d3db-4f95-b7db-be794b8c097d', Index=Eco_LoopbackIndices.Total)]
    [UmlTaggedValue('persistence', 'transient')]
    [UmlTaggedValue('derived', 'True')]
    [UmlTaggedValue('Eco.DerivationOCL', 'self.Quantidade*self.Produto.Valor')]
    property Total: System.Double read get_Total;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

function Pedido.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Pedido.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Pedido.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Pedido.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Pedido.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Pedido.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Pedido.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Pedido.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Pedido.get_Entrega: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Entrega)));
end;

procedure Pedido.set_Entrega(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Entrega, (System.Object(Value)));
end;

function Pedido.get_Data: System.DateTime;
begin
  Result := (System.DateTime(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Data)));
end;

procedure Pedido.set_Data(Value: System.DateTime);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Data, (System.Object(Value)));
end;

function Pedido.get_Items: IItemList;
begin
  Result := Package_1Unit.Item.ItemListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Items))));
end;

constructor Pedido.PedidoListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Pedido.PedidoListAdapter.get_Item(index: Integer): Pedido;
begin
  Result := (Package_1Unit.Pedido(inherited Adaptee[index]));
end;

procedure Pedido.PedidoListAdapter.set_Item(index: Integer; Value: Pedido);
begin
  inherited Adaptee[index] := value;
end;

function Pedido.PedidoListAdapter.Add(value: Pedido): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Pedido.PedidoListAdapter.Contains(value: Pedido): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Pedido.PedidoListAdapter.IndexOf(value: Pedido): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Pedido.PedidoListAdapter.Insert(index: Integer; value: Pedido);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Pedido.PedidoListAdapter.Remove(value: Pedido);
begin
  Self.Adaptee.Remove(value);
end;

function Item.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Item.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Item.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Item.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Item.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Item.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Item.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Item.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

constructor Item.ItemListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Item.ItemListAdapter.get_Item(index: Integer): Item;
begin
  Result := (Package_1Unit.Item(inherited Adaptee[index]));
end;

procedure Item.ItemListAdapter.set_Item(index: Integer; Value: Item);
begin
  inherited Adaptee[index] := value;
end;

function Item.ItemListAdapter.Add(value: Item): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Item.ItemListAdapter.Contains(value: Item): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Item.ItemListAdapter.IndexOf(value: Item): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Item.ItemListAdapter.Insert(index: Integer; value: Item);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Item.ItemListAdapter.Remove(value: Item);
begin
  Self.Adaptee.Remove(value);
end;

function Item.get_Total: System.Double;
begin
  Result := (Double(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Total)));
end;

function Item.get_Quantidade: Integer;
begin
  Result := (Integer(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Quantidade)));
end;

procedure Item.set_Quantidade(Value: Integer);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Quantidade, (System.Object(Value)));
end;

function Item.get_Produto: Produto;
begin
  Result := (Package_1Unit.Produto(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Produto)));
end;

procedure Item.set_Produto(Value: Produto);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Produto, (System.Object(Value)));
end;

function Item.get_Pedido: Pedido;
begin
  Result := (Package_1Unit.Pedido(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Pedido)));
end;

procedure Item.set_Pedido(Value: Pedido);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Pedido, (System.Object(Value)));
end;

function Produto.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Produto.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Produto.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Produto.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Produto.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Produto.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Produto.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Produto.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Produto.get_Valor: System.Double;
begin
  Result := (Double(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Valor)));
end;

procedure Produto.set_Valor(Value: System.Double);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Valor, (System.Object(Value)));
end;

function Produto.get_Descricao: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Descricao)));
end;

procedure Produto.set_Descricao(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Descricao, (System.Object(Value)));
end;

function Produto.get_Items: IItemList;
begin
  Result := Package_1Unit.Item.ItemListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Items))));
end;

constructor Produto.ProdutoListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Produto.ProdutoListAdapter.get_Item(index: Integer): Produto;
begin
  Result := (Package_1Unit.Produto(inherited Adaptee[index]));
end;

procedure Produto.ProdutoListAdapter.set_Item(index: Integer; Value: Produto);
begin
  inherited Adaptee[index] := value;
end;

function Produto.ProdutoListAdapter.Add(value: Produto): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Produto.ProdutoListAdapter.Contains(value: Produto): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Produto.ProdutoListAdapter.IndexOf(value: Produto): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Produto.ProdutoListAdapter.Insert(index: Integer; value: Produto);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Produto.ProdutoListAdapter.Remove(value: Produto);
begin
  Self.Adaptee.Remove(value);
end;

{ Package_1 }


{ Package_1 }


{ Package_1 }


{ Package_1 }


end.
