unit URotinas;

interface

uses SysUtils;

type
   Function ShowModalForm(FormClass: TFormClass; var form): TModalResult;
   procedure ShowForm(FormClass: TFormClass; var Form; SetFormAsMDIChild: Boolean = true);
   function removeSimbolos(texto: shortString): shortString;
   function ChecaCPF(CPF: ShortString): Boolean;
   function ChecaCNPJ(CNPJ: ShortString):Boolean;
   function ChecaCPF_CNPJ(CPF_CNPJ: ShortString): Boolean;
   function FileVersion(path: string): ShortString;
   function EMailValido(EMail: String): Boolean;

implementation

function ChecaCNPJ(CNPJ: ShortString): Boolean;
Var
  d1,d4,d2,Conta,fator,sobra,digito1,digito2 : Integer;
  valor, Check : shortString;
begin
    result:= false;
    valor:= CNPJ;
    valor:= removeSimbolos(valor);
    if Length(valor) <> 14 then
       Exit;

    d1 := 0;  {valor padrao}
    d4 := 0;  {valor padrao}
    d2 := 1;  {valor padrao}
    for Conta := 1 to Length( Valor )-2 do
    begin
       if d2 < 5 then
          fator := 6 - d2
       else fator := 14 - d2;
       d1 := d1 + StrToInt(Copy(Valor,Conta,1))*fator;
       if d2 < 6 then
          fator := 7 - d2
       else fator := 15 - d2;
       d4 := d4 + StrToInt(Copy(Valor,Conta,1))*fator;
       d2 := d2+1;
    end;
    sobra := (d1 mod 11);
    if sobra < 2 then
       digito1 := 0
    else digito1 := 11 - sobra;
    d4 := d4 + 2 * digito1;
    sobra := (d4 mod 11);
    if sobra < 2 then
       digito2 := 0
    else digito2 := 11 - sobra;
    Check := IntToStr(Digito1) + IntToStr(Digito2);
    if Check <> copy(Valor,succ(length(Valor)-2),2) then
       Result := False
    else Result := True;
end;

function removeSimbolos(texto: shortString): shortString;
var i: byte;
begin
   i:= 0;
   repeat
     inc(i);
     if not(texto[i] in ['0'..'9']) then
     begin
        delete(texto,i,1);
        dec(i);
     end;
   until i = length(texto);
   result:= texto;
end;

function ChecaCPF(CPF: ShortString): Boolean;
var
   S: shortString;
   Soma, iDig, iPos, Fator, i: Integer;

begin
   Result := False;
   S := cpf;
   s:= removeSimbolos(s);
   { verifica o CPF possui 11 digitos }
   if Length(S) <> 11 then
      Exit;

   { calcula os 2 ltimos dgitos }
   for iPos := 9 to 10 do
   begin
      Soma := 0;
      Fator := 2;

      for i := iPos downto 1 do
      begin
        Soma := Soma + StrToInt(S[i]) * Fator;
        Inc(Fator);
      end;

      iDig := 11 - Soma mod 11;
      if iDig > 9 then iDig := 0;

      { verifica os digitos com o forncedido }
      if iDig <> StrToInt( S[iPos + 1]) then
        Exit;
   end;

   Result := True;
end;

procedure ShowForm(FormClass: TFormClass; var Form; SetFormAsMDIChild: Boolean);
begin
    if TForm(Form) = nil then
    begin
       Application.CreateForm(FormClass, Form);
       if SetFormAsMDIChild then
          TForm(form).FormStyle := fsMDIChild;
    end;
    TForm(Form).Show;
end;

Function ShowModalForm(FormClass: TFormClass; var form): TModalResult;
begin
  try
    Screen.cursor := crHourGlass;
    Application.CreateForm(FormClass, form);
    TForm(form).FormStyle := fsNormal;
    TForm(form).Visible := false;
  finally
    screen.cursor := crDefault;
  end;

  try
    result := TForm(Form).ShowModal;
  finally
    TForm(Form).Release;
    TForm(Form):= nil;
  end;
end;

function FileVersion(path: string): ShortString;
var
  size, size2: DWord;
  pt, pt2: Pointer;
begin
  result:= '';//indicar que o arquivo especificado no tem verso
  size:= GetFileVersionInfoSize(PChar(path),size2);
  if size > 0 then
  begin
     GetMem(pt, size);
     try
       GetFileVersionInfo(PChar(path),0,size,pt);
       VerQueryValue(pt,'\',pt2,size2);
       with TVSFixedFileInfo(pt2^) do
       begin
           result:=
             IntToStr(HiWord(dwFileVersionMS)) + '.' +
             IntToStr(LoWord(dwFileVersionMS)) + '.' +
             IntToStr(HiWord(dwFileVersionLS)) + '.' +
             IntToStr(LoWord(dwFileVersionLS))
       end;
     finally
       FreeMem(pt);
     end;
  end;
end;

{Condies para um E-Mail ser ser vlido

1 - ser formado somente por caracteres do intervalo: 'a'..'z', '0'..'9', '_', '.', '@'
2 - ter somente um caractere de @
3 - ter um texto antes da @
4 - o caractere anterior a @ no pode ser um ponto (.)
5 - ter um texto depois da @
6 - o caractere seguinte a @ no pode ser um ponto
7 - ter pelos menos um ponto depois do texto aps a @ (o ponto no pode ser o caractere seguinte a @)
8 - no pode terminar com ponto (.)

Exemplos vlidos
  ms_campos@yahoo.com.br
  mcampos@etfto.gov.br
  manoelcampos@gmail.com }
function EMailValido(EMail: String): Boolean;
var
  i, cont, tamanho: integer;
  aux: String;
begin
  if email = '' then
  begin
    result:= true;
    exit;
  end;

  email:= AnsiLowerCase(EMail);
  tamanho:= length(EMail);
  //1 - verifica se o email contm somente caracteres vlidos
  for i:= 1 to tamanho do
  begin
     if not (email[i] in ['a'..'z','0'..'9','_','.','@']) then
     begin
       result:= false;
       exit;
     end;
  end;

  //2 - verifica quantas @ tem no email
  cont:= 0;
  for i:= 1 to tamanho do
  begin
     if email[i] = '@' then
       cont:= cont + 1;
  end;
  if cont <> 1 then
  begin
    result:= false;
    exit;
  end;

  {3 - verifica se existe um texto antes da @ (pois se chegou at aqui  porque existe somente uma @)
   se o caractere na posio 1 do email for a @, ento no h um texto antes deste caractere, log
   o email  invlido}
  if email[1] = '@' then
  begin
     result:= false;
     exit;
  end;

  {4 - verifica se o caractere antes da arroba  um ponto, se for, o email  invlido}
  i:= pos('@',email);
  if email[i-1] = '.' then
  begin
    result:= false;
    exit;
  end;

  {5 - verifica se existe um texto depois da @}
  //a varivel I j est armazenando a posio da @ (isto foi feito no cdigo acima)
  aux:= copy(email,i+1,tamanho);
  if aux = '' then
  begin
     result:= false;
     exit;
  end;

  {6 - verifica se o caractere seguinte a @  um ponto, se for o email  invlido }
  if email[i+1] = '.' then
  begin
    result:= false;
    exit;
  end;

  //7 - ter pelos menos um ponto depois do texto aps a @ (o ponto no pode ser o caractere seguinte a @)
  //copia o texto aps a @
  aux:= copy(email,i+1,tamanho);
  //se no existir no texto aps a @, o email  invlido 
  if pos('.',aux) = 0 then
  begin
    result:= false;
    exit;
  end;

  //verifica se o email termina com . (se terminar  invlido)
  if email[tamanho] =  '.' then
  begin
    result:= false;
    exit;
  end;

  //se chegar at aqui  porque tudo foi verificado e o email  vlido
  result:= true;
end;

function ChecaCPF_CNPJ(CPF_CNPJ: ShortString): Boolean;
begin
  result:= false;
  CPF_CNPJ := removeSimbolos(CPF_CNPJ);
  if length(CPF_CNPJ) = 11 then
     result:= ChecaCPF(CPF_CNPJ)
  else if length(CPF_CNPJ) = 14 then
     result:= ChecaCNPJ(CPF_CNPJ);
end;

end.
