unit Package_1Unit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes, MyCoreModelUnit;

type
  Cliente = class;
  [UmlElement('Package', Id='D5D69D8A-0F9A-4AE9-958F-8CE006CF03B6')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Cliente))]
  Package_1 = class
  end;

  [assembly: RuntimeRequired(TypeOf(Package_1))]
  IClienteList = interface;
  
  [UmlCollection(TypeOf(Cliente))]
  IClienteList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Cliente;
    procedure set_Item(index: Integer; Value: Cliente);
    property Item[index: Integer]: Cliente read get_Item write set_Item; default;
    function Add(value: Cliente): Integer;
    function Contains(value: Cliente): Boolean;
    function IndexOf(value: Cliente): Integer;
    procedure Insert(index: Integer; value: Cliente);
    procedure Remove(value: Cliente);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='c7879377-e26f-4ac5-af62-4601be7558ea')]
  Cliente = class(Entidade)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = Entidade.Eco_LoopbackIndices.Eco_MemberCount;
    const
      Eco_MemberCount = (Eco_FirstMember + 1);
    const
      CPF = Eco_FirstMember;
    end;

    ClienteListAdapter = class(ObjectListAdapter, IClienteList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Cliente;
      procedure set_Item(index: Integer; Value: Cliente);
      property Item[index: Integer]: Cliente read get_Item write set_Item; default;
      function Add(value: Cliente): Integer;
      function Contains(value: Cliente): Boolean;
      function IndexOf(value: Cliente): Integer;
      procedure Insert(index: Integer; value: Cliente);
      procedure Remove(value: Cliente);
    end;
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_CPF: string;
    procedure set_CPF(Value: string);
    [UmlElement(Id='e43e1aca-7057-4479-b6ef-8791a53617a2', Index=Eco_LoopbackIndices.CPF)]
    property CPF: string read get_CPF write set_CPF;
  end;

implementation

/// <summary>For Framework Internal use only</summary>
constructor Cliente.Create(content: IContent);
begin
  inherited Create(content);
end;

{$ENDREGION 'ECO generated code'}

constructor Cliente.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Cliente.get_CPF: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CPF)));
end;

procedure Cliente.set_CPF(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CPF, (System.Object(Value)));
end;

constructor Cliente.ClienteListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Cliente.ClienteListAdapter.get_Item(index: Integer): Cliente;
begin
  Result := (Package_1Unit.Cliente(inherited Adaptee[index]));
end;

procedure Cliente.ClienteListAdapter.set_Item(index: Integer; Value: Cliente);
begin
  inherited Adaptee[index] := value;
end;

function Cliente.ClienteListAdapter.Add(value: Cliente): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Cliente.ClienteListAdapter.Contains(value: Cliente): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Cliente.ClienteListAdapter.IndexOf(value: Cliente): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Cliente.ClienteListAdapter.Insert(index: Integer; value: Cliente);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Cliente.ClienteListAdapter.Remove(value: Cliente);
begin
  Self.Adaptee.Remove(value);
end;

end.
