unit Alunos;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.Handles, ExemploEco3AspNetEcoSpace;

type
  TWebForm2 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
  strict protected  
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    DataGrid1: System.Web.UI.WebControls.DataGrid;
    Label1: System.Web.UI.WebControls.Label;
    Label2: System.Web.UI.WebControls.Label;
    TextBox1: System.Web.UI.WebControls.TextBox;
    Label3: System.Web.UI.WebControls.Label;
    TextBox2: System.Web.UI.WebControls.TextBox;
    Label4: System.Web.UI.WebControls.Label;
    TextBox3: System.Web.UI.WebControls.TextBox;
    Label5: System.Web.UI.WebControls.Label;
    Button1: System.Web.UI.WebControls.Button;
    Label6: System.Web.UI.WebControls.Label;
    tbxNome: System.Web.UI.WebControls.TextBox;
    Label7: System.Web.UI.WebControls.Label;
    tbxEmail: System.Web.UI.WebControls.TextBox;
    ehAluno: Borland.Eco.Handles.ExpressionHandle;
  {$ENDREGION}
  strict private
// ToDo replace Borland.Eco.Handles.EcoSpace with actual type of ecospace in project
// for fEcoSpace, get_EcoSpace and EcoSpace
    fEcoSpace: Borland.Eco.Handles.EcoSpace;
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
    procedure Page_Unload(sender: System.Object; e: System.EventArgs);
  strict protected
    procedure OnInit(e: EventArgs); override;
    function get_EcoSpace: Borland.Eco.Handles.EcoSpace;
    procedure DoneWithEcoSpace;
    property EcoSpace: Borland.Eco.Handles.EcoSpace read get_EcoSpace;
    {$REGION 'Utility Methods'}
    procedure UpdateDatabase;
    function IdForObject(Obj: IObject): string;
    function ObjectForId(Id: string): IObjectInstance;
    {$ENDREGION}
    {$REGION 'DataGrid Events'}
    procedure DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    {$endregion}
  public
    procedure DataBind; override;
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider, Package_1Unit;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm2.InitializeComponent;
begin
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.ehAluno := Borland.Eco.Handles.ExpressionHandle.Create;
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // rhRoot
  // 
  Self.rhRoot.EcoSpaceType := TypeOf(ExemploEco3AspNetEcoSpace.TExemploEco3AspNetEcoSpace);
  Self.rhRoot.StaticValueTypeName := 'Turma';
  // 
  // ehAluno
  // 
  Self.ehAluno.Expression := 'self.Alunos';
  Self.ehAluno.RootHandle := Self.rhRoot;
  Include(Self.Unload, Self.Page_Unload);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm2.Page_Load(sender: System.Object; e: System.EventArgs);
var
  Id: string;
begin
  EcoSpace.Active := True;
  Id := Request.Params['RootId'];
  if Assigned(Id) and (Id <> '') then
    rhRoot.SetElement(ObjectForId(Id));
  if not IsPostBack then
    DataBind;
  // TODO: Put user code to initialize the page here
end;

procedure TWebForm2.Page_Unload(sender: System.Object; e: System.EventArgs);
begin
  DoneWithEcoSpace();
end;

procedure TWebForm2.DataBind;
begin
  ElementHandle.EnsureAllBindingLists;
  inherited DataBind;
end;

procedure TWebForm2.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  a: Aluno;
begin
  a      := Aluno.Create(EcoSpace);
  a.Nome := tbxNome.Text;
  a.Email:= tbxEmail.Text;
  (rhRoot.Element.AsObject as Turma).Alunos.Add(a);
  UpdateDatabase;
  DataBind;  
end;

{$REGION 'Utility Methods'}
procedure TWebForm2.UpdateDatabase;
var
  PersistenceService: IPersistenceService;
  DirtyListService: IDirtyListService;
begin
  PersistenceService := EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
  DirtyListService := EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
  PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
end;

function TWebForm2.IdForObject(Obj: IObject): string;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.IdForObject(Obj);
end;

function TWebForm2.ObjectForId(Id: string): IObjectInstance;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.ObjectForId(Id);
end;

{$ENDREGION}

{$REGION 'DataGrid Events'}

// The following code is useful if the form contains a System.Web.UI.Datagrid;
// It assumes that the elementhandle acting as a datasource has
// AddExternalId = true, and that datagrid.DataKeyField = "ExternalId"

procedure TWebForm2.DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  ToDelete: IObjectInstance;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  ToDelete := ObjectForId(Id);
  if Assigned(ToDelete) then
    ToDelete.Delete;
  UpdateDatabase;
  DataBind;
end;

procedure TWebForm2.DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := e.Item.ItemIndex;
  DataBind;
end;

procedure TWebForm2.DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  Row: TObject;
  Eh: ElementHandle;
  ColIndex: Integer;
  Col: BoundColumn;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  SourceGrid.DataBind(); // To set DataSource
  Eh := SourceGrid.DataSource as ElementHandle;
  Row := eh.RenderElement(ObjectForId(Id));
  for colIndex := 0 to SourceGrid.Columns.Count-1 do
  begin
    Col := BoundColumn(SourceGrid.Columns[colIndex]);
    if Assigned(Col) and (not Col.ReadOnly) then
      eh.SetRenderedElementProperty(row, Col.DataField, (e.Item.Cells[colIndex].Controls[0] as TextBox).Text, true);
  end;
  UpdateDatabase;
  SourceGrid.EditItemIndex := -1;
  DataBind;
end;

procedure TWebForm2.DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := -1;
  DataBind;
end;
{$ENDREGION}

procedure TWebForm2.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

function TWebForm2.get_EcoSpace: Borland.Eco.Handles.EcoSpace;
begin
  if not Assigned(fEcoSpace) then
  begin
    fEcoSpace := TEcoSpaceProvider.GetEcoSpace;
    rhRoot.EcoSpace := fEcoSpace;
    // Set additional root handles here and in DoneWithEcoSpace
  end;
  Result := fEcoSpace;
end;

procedure TWebForm2.DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;
  rhRoot.EcoSpace := nil;
  rhRoot.SetElement(nil);
  // Clear all other references to ecoSpace or its contents here.
  // Otherwise it is not safe to return it to a pool.
  TEcoSpaceProvider.ReturnEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

end.

