unit EcoSpaceProvider;

interface

uses
  Borland.Eco.Handles,
  Borland.Eco.Web,
  ExemploEco3AspNetEcoSpace;

const
  // ToDo: Configure the strategy for the provider by changing the constant
  MODE: EcoSpaceStrategyHandler.SessionStateMode =
                    EcoSpaceStrategyHandler.SessionStateMode.IfDirty;

type
  TEcoSpaceProvider = class
  public
		class function GetEcoSpace: TExemploEco3AspNetEcoSpace; static;
    class procedure ReturnEcoSpace(aEcoSpace: EcoSpace); static;
		class function GetSessionFreeEcoSpace: TExemploEco3AspNetEcoSpace; static;
    class procedure ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace); static;
    class procedure ClearSessionState; static;
  end;

implementation

// Utility methods

function GetHandler: EcoSpaceStrategyHandler;
begin
  Result := EcoSpaceStrategyHandler.Create(MODE, typeof(TExemploEco3AspNetEcoSpace));
end;

{ TEcoSpaceProvider }

class procedure TEcoSpaceProvider.ClearSessionState;
begin
  GetHandler.ClearSessionState;
end;

class function TEcoSpaceProvider.GetEcoSpace(): TExemploEco3AspNetEcoSpace;
begin
  Result := TExemploEco3AspNetEcoSpace(GetHandler.GetEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnEcoSpace(aEcoSpace);
end;

class function TEcoSpaceProvider.GetSessionFreeEcoSpace(): TExemploEco3AspNetEcoSpace;
begin
  Result := TExemploEco3AspNetEcoSpace(GetHandler.GetSessionFreeEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnSessionFreeEcoSpace(aEcoSpace);
end;

end.
