unit ExemploEco3AspNetEcoSpace;

interface

uses
  System.Threading,
  Borland.Eco.Services,
  Borland.Eco.UmlCodeAttributes,
  Borland.Eco.Persistence,
  Borland.Eco.Handles,
  Package_1Unit;

type
  [EcoSpace]
  [EcoSpacePackage(TypeOf(Package_1Unit.Package_1))]
  TExemploEco3AspNetEcoSpace = class(Borland.Eco.Handles.DefaultEcoSpace)
  private
    PersistenceMapperSharer1: Borland.Eco.Persistence.PersistenceMapperSharer;
    procedure InitializeComponent;
    class var fTypeSystemProvider: ITypeSystemService;
    class var fTypeSystemProviderLock: Tobject;
  strict protected
    function GetTypeSystemProvider: ITypeSystemService; override;
  public
    constructor Create;
    class constructor Create;
    class function GetTypeSystemService: ITypeSystemService; static;
    procedure UpdateDatabase;
    function get_PersistenceService: IPersistenceService;
    property PersistenceService: IPersistenceService read get_PersistenceService;
    function get_DirtyListService: IDirtyListService;
    property DirtyListService: IDirtyListService read get_DirtyListService;
    function get_UndoService: IUndoService;
    property UndoService: IUndoService read get_UndoService;
    function get_TypeSystemService: ITypeSystemService;
    property TypeSystemService: ITypeSystemService read get_TypeSystemService;
    function get_OclService: IOclService;
    property OclService: IOclService read get_OclService;
    function get_ObjectFactoryService: IObjectFactoryService;
    property ObjectFactoryService: IObjectFactoryService read get_ObjectFactoryService;
    function get_VariableFactoryService: IVariableFactoryService;
    property VariableFactoryService: IVariableFactoryService read get_VariableFactoryService;
  end;

  [assembly: RuntimeRequired(TypeOf(TExemploEco3AspNetEcoSpace))]

implementation
{$AUTOBOX ON}
uses
  EcoPersistenceMapperProvider;

constructor TExemploEco3AspNetEcoSpace.Create;
begin
  inherited Create;
  InitializeComponent;
  // TODO: Add any constructor code here
end;

class constructor TExemploEco3AspNetEcoSpace.Create;
begin
  fTypeSystemProviderLock := TObject.Create;
end;

procedure TExemploEco3AspNetEcoSpace.InitializeComponent;
begin
  Self.PersistenceMapperSharer1 := Borland.Eco.Persistence.PersistenceMapperSharer.Create;
  //
  // PersistenceMapperSharer1
  //
  Self.PersistenceMapperSharer1.MapperProviderType := TypeOf(TEcoPersistenceMapperProvider);
  //
  // TWebApplication11EcoSpace
  //
  Self.PersistenceMapper := Self.PersistenceMapperSharer1;
end;

class function TExemploEco3AspNetEcoSpace.GetTypeSystemService: ITypeSystemService;
begin
  if not Assigned(fTypeSystemProvider) then
  begin
    try
      Monitor.Enter(fTypeSystemProviderLock);
      if not Assigned(fTypeSystemProvider) then
        fTypeSystemProvider := MakeTypeService(typeOf(TExemploEco3AspNetEcoSpace));
    finally
      Monitor.Exit(fTypeSystemProviderLock);
    end;
  end;
  Result := fTypeSystemProvider;
end;

function TExemploEco3AspNetEcoSpace.GetTypeSystemProvider: ITypeSystemService;
begin
  Result := TExemploEco3AspNetEcoSpace.GetTypeSystemService;
end;

procedure TExemploEco3AspNetEcoSpace.UpdateDatabase;
begin
  if Assigned(PersistenceService) and Assigned(DirtyListService) then
    PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects);
end;

function TExemploEco3AspNetEcoSpace.get_PersistenceService: IPersistenceService;
begin
  Result := GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
end;

function TExemploEco3AspNetEcoSpace.get_DirtyListService: IDirtyListService;
begin
  Result := GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
end;

function TExemploEco3AspNetEcoSpace.get_UndoService: IUndoService;
begin
  Result := GetEcoService(typeof(IUndoService)) as IUndoService;
end;

function TExemploEco3AspNetEcoSpace.get_TypeSystemService: ITypeSystemService;
begin
  Result := GetEcoService(typeof(ITypeSystemService)) as ITypeSystemService;
end;

function TExemploEco3AspNetEcoSpace.get_OclService: IOclService;
begin
  Result := GetEcoService(typeof(IOclService)) as IOclService;
end;

function TExemploEco3AspNetEcoSpace.get_ObjectFactoryService: IObjectFactoryService;
begin
  Result := GetEcoService(typeof(IObjectFactoryService)) as IObjectFactoryService;
end;

function TExemploEco3AspNetEcoSpace.get_VariableFactoryService: IVariableFactoryService;
begin
  Result := GetEcoService(typeof(IVariableFactoryService)) as IVariableFactoryService;
end;

end.
