unit Package_1Unit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Entidade = class;
  Aluno = class;
  Turma = class;
  Instrutor = class;
  Treinamento = class;
  [UmlElement('Package', Id='74D43E4C-85A9-403B-B541-48F09BFEF339')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Entidade))]
  [UmlMetaAttribute('ownedElement', TypeOf(Aluno))]
  [UmlMetaAttribute('ownedElement', TypeOf(Turma))]
  [UmlMetaAttribute('ownedElement', TypeOf(Instrutor))]
  [UmlMetaAttribute('ownedElement', TypeOf(Treinamento))]
  Package_1 = class
  public
  type
    [UmlElement('Association', Id='52de288d-72be-4527-9170-c0f781113edc')]
    TurmaTurmaAlunoAlunos = class
    end;
 

    [UmlElement('Association', Id='d6ef90fb-0041-438e-abe2-7d198a80585a')]
    InstrutorInstrutorTurmaTurmas = class
    end;

    [UmlElement('Association', Id='9c1455ef-3f37-4526-a314-cceb4dc143c9')]
    TurmaTurmasTreinamentoTreinamento = class
    end; end;

  [assembly: RuntimeRequired(TypeOf(Package_1))]
  IEntidadeList = interface;
  
  [UmlCollection(TypeOf(Entidade))]
  IEntidadeList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Entidade;
    procedure set_Item(index: Integer; Value: Entidade);
    property Item[index: Integer]: Entidade read get_Item write set_Item; default;
    function Add(value: Entidade): Integer;
    function Contains(value: Entidade): Boolean;
    function IndexOf(value: Entidade): Integer;
    procedure Insert(index: Integer; value: Entidade);
    procedure Remove(value: Entidade);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='68e58468-ec44-4d9b-8fe2-9fd70fe82dd1')]
  Entidade = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 2);
    const
      Nome = Eco_FirstMember;
    const
      Email = (Eco_LoopbackIndices.Nome + 1);
    end;

    EntidadeListAdapter = class(ObjectListAdapter, IEntidadeList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Entidade;
      procedure set_Item(index: Integer; Value: Entidade);
      property Item[index: Integer]: Entidade read get_Item write set_Item; default;
      function Add(value: Entidade): Integer;
      function Contains(value: Entidade): Boolean;
      function IndexOf(value: Entidade): Integer;
      procedure Insert(index: Integer; value: Entidade);
      procedure Remove(value: Entidade);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Email: string;
    procedure set_Email(Value: string);
    [UmlElement(Id='76dbe8b3-da4d-4391-8416-146eb8b0c9a6', Index=Eco_LoopbackIndices.Email)]
    property Email: string read get_Email write set_Email;
    function get_Nome: string;
    procedure set_Nome(Value: string);
    [UmlElement(Id='5209dc98-4c6b-41c7-b418-c22e0ce5a347', Index=Eco_LoopbackIndices.Nome)]
    property Nome: string read get_Nome write set_Nome;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  IAlunoList = interface;
  
  [UmlCollection(TypeOf(Aluno))]
  IAlunoList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Aluno;
    procedure set_Item(index: Integer; Value: Aluno);
    property Item[index: Integer]: Aluno read get_Item write set_Item; default;
    function Add(value: Aluno): Integer;
    function Contains(value: Aluno): Boolean;
    function IndexOf(value: Aluno): Integer;
    procedure Insert(index: Integer; value: Aluno);
    procedure Remove(value: Aluno);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='bad9c8cb-1ae2-4284-a8f1-1b1021393635')]
  Aluno = class(Entidade)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = Entidade.Eco_LoopbackIndices.Eco_MemberCount;
    const
      Eco_MemberCount = (Eco_FirstMember + 2);
    const
      Empresa = Eco_FirstMember;
    const
      Turma = (Eco_LoopbackIndices.Empresa + 1);
    end;

    AlunoListAdapter = class(ObjectListAdapter, IAlunoList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Aluno;
      procedure set_Item(index: Integer; Value: Aluno);
      property Item[index: Integer]: Aluno read get_Item write set_Item; default;
      function Add(value: Aluno): Integer;
      function Contains(value: Aluno): Boolean;
      function IndexOf(value: Aluno): Integer;
      procedure Insert(index: Integer; value: Aluno);
      procedure Remove(value: Aluno);
    end;
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_Turma: Turma;
    procedure set_Turma(Value: Turma);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Turma, Id=(('78c9da08' +
    '-' + 'd') + '904-42e5-946b-5ef650553e19'))]
    [UmlMetaAttribute('association', TypeOf(Package_1.TurmaTurmaAlunoAlunos), Index=0)]
    [UmlMetaAttribute('multiplicity', '1')]
    property Turma: Turma read get_Turma write set_Turma;
    function get_Empresa: string;
    procedure set_Empresa(Value: string);
    [UmlElement(Id='aaab63be-21cc-43ec-8fcc-5e3035b0c6f5', Index=Eco_LoopbackIndices.Empresa)]
    property Empresa: string read get_Empresa write set_Empresa;
  end;
  ITurmaList = interface;
  
  [UmlCollection(TypeOf(Turma))]
  ITurmaList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Turma;
    procedure set_Item(index: Integer; Value: Turma);
    property Item[index: Integer]: Turma read get_Item write set_Item; default;
    function Add(value: Turma): Integer;
    function Contains(value: Turma): Boolean;
    function IndexOf(value: Turma): Integer;
    procedure Insert(index: Integer; value: Turma);
    procedure Remove(value: Turma);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='1be95018-b745-4676-adfc-5c3da450681b')]
  Turma = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 6);
    const
      Data = Eco_FirstMember;
    const
      Descricao = (Eco_LoopbackIndices.Data + 1);
    const
      Horario = (Eco_LoopbackIndices.Descricao + 1);
    const
      Alunos = (Eco_LoopbackIndices.Horario + 1);
    const
      Treinamento = (Eco_LoopbackIndices.Alunos + 1);
    const
      Instrutor = (Eco_LoopbackIndices.Treinamento + 1);
    end;

    TurmaListAdapter = class(ObjectListAdapter, ITurmaList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Turma;
      procedure set_Item(index: Integer; Value: Turma);
      property Item[index: Integer]: Turma read get_Item write set_Item; default;
      function Add(value: Turma): Integer;
      function Contains(value: Turma): Boolean;
      function IndexOf(value: Turma): Integer;
      procedure Insert(index: Integer; value: Turma);
      procedure Remove(value: Turma);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Alunos: IAlunoList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Alunos, Id=('49fba07b' +
    '-' + '78cb-4573-8bc5-ac4ff7116eb2'))]
    [UmlMetaAttribute('association', TypeOf(Package_1.TurmaTurmaAlunoAlunos), Index=1)]
    [UmlMetaAttribute('multiplicity', '1..*')]
    property Alunos: IAlunoList read get_Alunos;
    function get_Instrutor: Instrutor;
    procedure set_Instrutor(Value: Instrutor);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Instrutor, Id=(('86c5' +
    '8' + '3') + 'db-a313-43d9-8d51-44581924f535'))]
    [UmlMetaAttribute('association', TypeOf(Package_1.InstrutorInstrutorTurmaTurmas), Index=0)]
    [UmlMetaAttribute('multiplicity', '1')]
    property Instrutor: Instrutor read get_Instrutor write set_Instrutor;
    function get_Treinamento: Treinamento;
    procedure set_Treinamento(Value: Treinamento);
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Treinamento, Id='7e2e' +
    '4a41-3c61-4d97-b6fa-3e4cd917a2ea')]
    [UmlMetaAttribute('association', TypeOf(Package_1.TurmaTurmasTreinamentoTreinamento), Index=1)]
    [UmlMetaAttribute('multiplicity', '1')]
    property Treinamento: Treinamento read get_Treinamento write set_Treinamento;
    function get_Data: System.DateTime;
    procedure set_Data(Value: System.DateTime);
    [UmlElement(Id='637f599c-a52b-4816-bbc2-01b69b06fa3d', Index=Eco_LoopbackIndices.Data)]
    property Data: System.DateTime read get_Data write set_Data;
    function get_Horario: System.DateTime;
    procedure set_Horario(Value: System.DateTime);
    [UmlElement(Id='8a5df3a0-668e-4d87-8592-a15758516ba9', Index=Eco_LoopbackIndices.Horario)]
    property Horario: System.DateTime read get_Horario write set_Horario;
    function get_Descricao: string;
    procedure set_Descricao(Value: string);
    [UmlElement(Id='7a00b4b4-4b23-435d-8a77-434c35507737', Index=Eco_LoopbackIndices.Descricao)]
    property Descricao: string read get_Descricao write set_Descricao;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  IInstrutorList = interface;
  
  [UmlCollection(TypeOf(Instrutor))]
  IInstrutorList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Instrutor;
    procedure set_Item(index: Integer; Value: Instrutor);
    property Item[index: Integer]: Instrutor read get_Item write set_Item; default;
    function Add(value: Instrutor): Integer;
    function Contains(value: Instrutor): Boolean;
    function IndexOf(value: Instrutor): Integer;
    procedure Insert(index: Integer; value: Instrutor);
    procedure Remove(value: Instrutor);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='d13267cd-9f37-4620-b3c7-6c09116c2bff')]
  Instrutor = class(Entidade)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = Entidade.Eco_LoopbackIndices.Eco_MemberCount;
    const
      Eco_MemberCount = (Eco_FirstMember + 2);
    const
      BorlandID = Eco_FirstMember;
    const
      Turmas = (Eco_LoopbackIndices.BorlandID + 1);
    end;

    InstrutorListAdapter = class(ObjectListAdapter, IInstrutorList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Instrutor;
      procedure set_Item(index: Integer; Value: Instrutor);
      property Item[index: Integer]: Instrutor read get_Item write set_Item; default;
      function Add(value: Instrutor): Integer;
      function Contains(value: Instrutor): Boolean;
      function IndexOf(value: Instrutor): Integer;
      procedure Insert(index: Integer; value: Instrutor);
      procedure Remove(value: Instrutor);
    end;
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
    function get_Turmas: ITurmaList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Turmas, Id='500a4047-' +
    'bfc8-4f13-a99c-e1f88cf6d341')]
    [UmlMetaAttribute('association', TypeOf(Package_1.InstrutorInstrutorTurmaTurmas), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property Turmas: ITurmaList read get_Turmas;
    function get_BorlandID: Integer;
    procedure set_BorlandID(Value: Integer);
    [UmlElement(Id='dc50987a-1b23-4902-8ee8-38e7827714f0', Index=Eco_LoopbackIndices.BorlandID)]
    property BorlandID: Integer read get_BorlandID write set_BorlandID;
  end;
  ITreinamentoList = interface;
  
  [UmlCollection(TypeOf(Treinamento))]
  ITreinamentoList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Treinamento;
    procedure set_Item(index: Integer; Value: Treinamento);
    property Item[index: Integer]: Treinamento read get_Item write set_Item; default;
    function Add(value: Treinamento): Integer;
    function Contains(value: Treinamento): Boolean;
    function IndexOf(value: Treinamento): Integer;
    procedure Insert(index: Integer; value: Treinamento);
    procedure Remove(value: Treinamento);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='91ef7f68-3436-4126-a889-55ef71ee2077')]
  Treinamento = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 3);
    const
      Descricao = Eco_FirstMember;
    const
      CargaHoraria = (Eco_LoopbackIndices.Descricao + 1);
    const
      Turmas = (Eco_LoopbackIndices.CargaHoraria + 1);
    end;

    TreinamentoListAdapter = class(ObjectListAdapter, ITreinamentoList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Treinamento;
      procedure set_Item(index: Integer; Value: Treinamento);
      property Item[index: Integer]: Treinamento read get_Item write set_Item; default;
      function Add(value: Treinamento): Integer;
      function Contains(value: Treinamento): Boolean;
      function IndexOf(value: Treinamento): Integer;
      procedure Insert(index: Integer; value: Treinamento);
      procedure Remove(value: Treinamento);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Turmas: ITurmaList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Turmas, Id='fbb94cae-' +
    'a139-480c-9bae-fc7b55a29c83')]
    [UmlMetaAttribute('association', TypeOf(Package_1.TurmaTurmasTreinamentoTreinamento), Index=0)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property Turmas: ITurmaList read get_Turmas;
    function get_Descricao: string;
    procedure set_Descricao(Value: string);
    [UmlElement(Id='bcd6b531-6c97-4892-9bbb-f8ec4b0fff49', Index=Eco_LoopbackIndices.Descricao)]
    property Descricao: string read get_Descricao write set_Descricao;
    function get_CargaHoraria: Integer;
    procedure set_CargaHoraria(Value: Integer);
    [UmlElement(Id='f7a5c11d-58eb-4534-8a0b-482ce9b019fe', Index=Eco_LoopbackIndices.CargaHoraria)]
    property CargaHoraria: Integer read get_CargaHoraria write set_CargaHoraria;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

function Entidade.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Entidade.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Entidade.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Entidade.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Entidade.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Entidade.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Entidade.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Entidade.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Entidade.get_Nome: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Nome)));
end;

procedure Entidade.set_Nome(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Nome, (System.Object(Value)));
end;

function Entidade.get_Email: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Email)));
end;

procedure Entidade.set_Email(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Email, (System.Object(Value)));
end;

constructor Entidade.EntidadeListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Entidade.EntidadeListAdapter.get_Item(index: Integer): Entidade;
begin
  Result := (Package_1Unit.Entidade(inherited Adaptee[index]));
end;

procedure Entidade.EntidadeListAdapter.set_Item(index: Integer; Value: Entidade);
begin
  inherited Adaptee[index] := value;
end;

function Entidade.EntidadeListAdapter.Add(value: Entidade): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Entidade.EntidadeListAdapter.Contains(value: Entidade): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Entidade.EntidadeListAdapter.IndexOf(value: Entidade): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Entidade.EntidadeListAdapter.Insert(index: Integer; value: Entidade);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Entidade.EntidadeListAdapter.Remove(value: Entidade);
begin
  Self.Adaptee.Remove(value);
end;

/// <summary>For Framework Internal use only</summary>
constructor Aluno.Create(content: IContent);
begin
  inherited Create(content);
end;

{$ENDREGION 'ECO generated code'}

constructor Aluno.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Aluno.get_Turma: Turma;
begin
  Result := (Package_1Unit.Turma(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Turma)));
end;

procedure Aluno.set_Turma(Value: Turma);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Turma, (System.Object(Value)));
end;

function Aluno.get_Empresa: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Empresa)));
end;

procedure Aluno.set_Empresa(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Empresa, (System.Object(Value)));
end;

constructor Aluno.AlunoListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Aluno.AlunoListAdapter.get_Item(index: Integer): Aluno;
begin
  Result := (Package_1Unit.Aluno(inherited Adaptee[index]));
end;

procedure Aluno.AlunoListAdapter.set_Item(index: Integer; Value: Aluno);
begin
  inherited Adaptee[index] := value;
end;

function Aluno.AlunoListAdapter.Add(value: Aluno): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Aluno.AlunoListAdapter.Contains(value: Aluno): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Aluno.AlunoListAdapter.IndexOf(value: Aluno): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Aluno.AlunoListAdapter.Insert(index: Integer; value: Aluno);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Aluno.AlunoListAdapter.Remove(value: Aluno);
begin
  Self.Adaptee.Remove(value);
end;

function Turma.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Turma.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Turma.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Turma.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Turma.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Turma.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Turma.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Turma.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Turma.get_Descricao: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Descricao)));
end;

procedure Turma.set_Descricao(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Descricao, (System.Object(Value)));
end;

function Turma.get_Horario: System.DateTime;
begin
  Result := (System.DateTime(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Horario)));
end;

procedure Turma.set_Horario(Value: System.DateTime);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Horario, (System.Object(Value)));
end;

function Turma.get_Data: System.DateTime;
begin
  Result := (System.DateTime(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Data)));
end;

procedure Turma.set_Data(Value: System.DateTime);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Data, (System.Object(Value)));
end;

function Turma.get_Treinamento: Treinamento;
begin
  Result := (Package_1Unit.Treinamento(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Treinamento)));
end;

procedure Turma.set_Treinamento(Value: Treinamento);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Treinamento, (System.Object(Value)));
end;

function Turma.get_Instrutor: Instrutor;
begin
  Result := (Package_1Unit.Instrutor(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Instrutor)));
end;

procedure Turma.set_Instrutor(Value: Instrutor);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Instrutor, (System.Object(Value)));
end;

function Turma.get_Alunos: IAlunoList;
begin
  Result := Package_1Unit.Aluno.AlunoListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Alunos))));
end;

constructor Turma.TurmaListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Turma.TurmaListAdapter.get_Item(index: Integer): Turma;
begin
  Result := (Package_1Unit.Turma(inherited Adaptee[index]));
end;

procedure Turma.TurmaListAdapter.set_Item(index: Integer; Value: Turma);
begin
  inherited Adaptee[index] := value;
end;

function Turma.TurmaListAdapter.Add(value: Turma): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Turma.TurmaListAdapter.Contains(value: Turma): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Turma.TurmaListAdapter.IndexOf(value: Turma): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Turma.TurmaListAdapter.Insert(index: Integer; value: Turma);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Turma.TurmaListAdapter.Remove(value: Turma);
begin
  Self.Adaptee.Remove(value);
end;

/// <summary>For Framework Internal use only</summary>
constructor Instrutor.Create(content: IContent);
begin
  inherited Create(content);
end;

{$ENDREGION 'ECO generated code'}

constructor Instrutor.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Instrutor.get_Turmas: ITurmaList;
begin
  Result := Package_1Unit.Turma.TurmaListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Turmas))));
end;

function Instrutor.get_BorlandID: Integer;
begin
  Result := (Integer(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.BorlandID)));
end;

procedure Instrutor.set_BorlandID(Value: Integer);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.BorlandID, (System.Object(Value)));
end;

constructor Instrutor.InstrutorListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Instrutor.InstrutorListAdapter.get_Item(index: Integer): Instrutor;
begin
  Result := (Package_1Unit.Instrutor(inherited Adaptee[index]));
end;

procedure Instrutor.InstrutorListAdapter.set_Item(index: Integer; Value: Instrutor);
begin
  inherited Adaptee[index] := value;
end;

function Instrutor.InstrutorListAdapter.Add(value: Instrutor): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Instrutor.InstrutorListAdapter.Contains(value: Instrutor): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Instrutor.InstrutorListAdapter.IndexOf(value: Instrutor): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Instrutor.InstrutorListAdapter.Insert(index: Integer; value: Instrutor);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Instrutor.InstrutorListAdapter.Remove(value: Instrutor);
begin
  Self.Adaptee.Remove(value);
end;

function Treinamento.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Treinamento.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Treinamento.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Treinamento.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Treinamento.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Treinamento.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Treinamento.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Treinamento.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Treinamento.get_CargaHoraria: Integer;
begin
  Result := (Integer(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.CargaHoraria)));
end;

procedure Treinamento.set_CargaHoraria(Value: Integer);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.CargaHoraria, (System.Object(Value)));
end;

function Treinamento.get_Descricao: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Descricao)));
end;

procedure Treinamento.set_Descricao(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Descricao, (System.Object(Value)));
end;

function Treinamento.get_Turmas: ITurmaList;
begin
  Result := Package_1Unit.Turma.TurmaListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Turmas))));
end;

constructor Treinamento.TreinamentoListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Treinamento.TreinamentoListAdapter.get_Item(index: Integer): Treinamento;
begin
  Result := (Package_1Unit.Treinamento(inherited Adaptee[index]));
end;

procedure Treinamento.TreinamentoListAdapter.set_Item(index: Integer; Value: Treinamento);
begin
  inherited Adaptee[index] := value;
end;

function Treinamento.TreinamentoListAdapter.Add(value: Treinamento): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Treinamento.TreinamentoListAdapter.Contains(value: Treinamento): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Treinamento.TreinamentoListAdapter.IndexOf(value: Treinamento): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Treinamento.TreinamentoListAdapter.Insert(index: Integer; value: Treinamento);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Treinamento.TreinamentoListAdapter.Remove(value: Treinamento);
begin
  Self.Adaptee.Remove(value);
end;

{ Package_1 }


{ Package_1 }


{ Package_1 }


end.
