unit WebForm1;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.Handles, ExemploEco3AspNetEcoSpace, Package_1Unit;

type
  TWebForm1 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure DataGrid1_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid1_ItemDataBound(sender: System.Object; e: System.Web.UI.WebControls.DataGridItemEventArgs);
  strict protected  
    rhRoot: Borland.Eco.Handles.ReferenceHandle;
    DataGrid1: System.Web.UI.WebControls.DataGrid;
    ehTurma: Borland.Eco.Handles.ExpressionHandle;
    Button1: System.Web.UI.WebControls.Button;
  {$ENDREGION}
  strict private
    fEcoSpace: TExemploEco3AspNetEcoSpace;
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
    procedure Page_Unload(sender: System.Object; e: System.EventArgs);
  strict protected
    procedure OnInit(e: EventArgs); override;
    function get_EcoSpace: TExemploEco3AspNetEcoSpace;
    procedure DoneWithEcoSpace;
    property EcoSpace: TExemploEco3AspNetEcoSpace read get_EcoSpace;
    {$REGION 'Utility Methods'}
    procedure UpdateDatabase;
    function IdForObject(Obj: IObject): string;
    function ObjectForId(Id: string): IObjectInstance;
    {$ENDREGION}
    {$REGION 'DataGrid Events'}
    procedure DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    procedure DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
    {$endregion}
  public
    procedure DataBind; override;
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm1.InitializeComponent;
type
  TArrayOfBorland_Eco_Handles_AbstractColumn = array of Borland.Eco.Handles.AbstractColumn;
var
  Column16: Borland.Eco.Handles.Column;
  Column15: Borland.Eco.Handles.Column;
  Column14: Borland.Eco.Handles.Column;
  Column13: Borland.Eco.Handles.Column;
  Column12: Borland.Eco.Handles.Column;
  Column11: Borland.Eco.Handles.Column;
begin
  Column11 := Borland.Eco.Handles.Column.Create;
  Column12 := Borland.Eco.Handles.Column.Create;
  Column13 := Borland.Eco.Handles.Column.Create;
  Column14 := Borland.Eco.Handles.Column.Create;
  Column15 := Borland.Eco.Handles.Column.Create;
  Column16 := Borland.Eco.Handles.Column.Create;
  Self.rhRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.ehTurma := Borland.Eco.Handles.ExpressionHandle.Create;
  Include(Self.DataGrid1.DeleteCommand, Self.DataGrid1_DeleteCommand);
  Include(Self.DataGrid1.ItemDataBound, Self.DataGrid1_ItemDataBound);
  Include(Self.Button1.Click, Self.Button1_Click);
  // 
  // rhRoot
  // 
  Self.rhRoot.EcoSpaceType := TypeOf(ExemploEco3AspNetEcoSpace.TExemploEco3AspNetEcoSpace);
  // 
  // ehTurma
  // 
  Self.ehTurma.AddDefaultProperties := False;
  Self.ehTurma.AddExternalId := True;
  Column11.Expression := 'self.Alunos';
  Column11.Name := 'Alunos';
  Column12.Expression := 'self.Instrutor.Nome';
  Column12.Name := 'Instrutor';
  Column13.Expression := 'self.Treinamento.Descricao';
  Column13.Name := 'Treinamento';
  Column14.Expression := 'self.Data';
  Column14.Name := 'Data';
  Column15.Expression := 'self.Horario';
  Column15.Name := 'Horario';
  Column16.Expression := 'self.Descricao';
  Column16.Name := 'Descricao';
  Self.ehTurma.Columns.AddRange(TArrayOfBorland_Eco_Handles_AbstractColumn.Create(Column11, 
          Column12, Column13, Column14, Column15, Column16));
  Self.ehTurma.Expression := 'Turma.allInstances';
  Self.ehTurma.RootHandle := Self.rhRoot;
  Include(Self.Unload, Self.Page_Unload);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm1.Page_Load(sender: System.Object; e: System.EventArgs);
var
  Id: string;
begin
  EcoSpace.Active := True;
  Id := Request.Params['RootId'];
  if Assigned(Id) and (Id <> '') then
    rhRoot.SetElement(ObjectForId(Id));
  if not IsPostBack then
    DataBind;
end;

procedure TWebForm1.Page_Unload(sender: System.Object; e: System.EventArgs);
begin
  DoneWithEcoSpace();
end;

procedure TWebForm1.DataBind;
begin
  ElementHandle.EnsureAllBindingLists;
  inherited DataBind;
end;

procedure TWebForm1.DataGrid1_ItemDataBound(sender: System.Object; e: System.Web.UI.WebControls.DataGridItemEventArgs);
begin
  if (e.Item.ItemType = ListItemType.Item) xor
     (e.Item.ItemType = ListItemType.AlternatingItem) then

end;

procedure TWebForm1.DataGrid1_DeleteCommand(source: System.Object; e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  ObjectForId(DataGrid1.DataKeys[e.Item.ItemIndex].ToString).Delete;
  UpdateDatabase;
  DataBind;
end;

procedure TWebForm1.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  t: Turma;
begin
  t           := Turma.Create(EcoSpace);
  t.Data      := DateTime.Now;
  t.Horario   := DateTime.Now;
  t.Descricao := 'ASP.NET ECO III Rocks !!!';
  UpdateDatabase;
  DataBind;
end;

{$REGION 'Utility Methods'}
procedure TWebForm1.UpdateDatabase;
var
  PersistenceService: IPersistenceService;
  DirtyListService: IDirtyListService;
begin
  PersistenceService := EcoSpace.GetEcoService(typeof(IPersistenceService)) as IPersistenceService;
  DirtyListService := EcoSpace.GetEcoService(typeof(IDirtyListService)) as IDirtyListService;
  PersistenceService.UpdateDatabaseWithList(DirtyListService.AllDirtyObjects());
end;

function TWebForm1.IdForObject(Obj: IObject): string;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.IdForObject(Obj);
end;

function TWebForm1.ObjectForId(Id: string): IObjectInstance;
var
  IdService: IExternalIdService;
begin
  IdService := EcoSpace.GetEcoService(typeof(IExternalIdService)) as IExternalIdService;
  Result := IdService.ObjectForId(Id);
end;

{$ENDREGION}

{$REGION 'DataGrid Events'}

// The following code is useful if the form contains a System.Web.UI.Datagrid;
// It assumes that the elementhandle acting as a datasource has
// AddExternalId = true, and that datagrid.DataKeyField = "ExternalId"

procedure TWebForm1.DataGrid_DeleteCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  ToDelete: IObjectInstance;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  ToDelete := ObjectForId(Id);
  if Assigned(ToDelete) then
    ToDelete.Delete;
  UpdateDatabase;
  DataBind;
end;

procedure TWebForm1.DataGrid_EditCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := e.Item.ItemIndex;
  DataBind;
end;

procedure TWebForm1.DataGrid_UpdateCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
var
  SourceGrid: DataGrid;
  Id: string;
  Row: TObject;
  Eh: ElementHandle;
  ColIndex: Integer;
  Col: BoundColumn;
begin
  SourceGrid := source as DataGrid;
  Id := SourceGrid.DataKeys[e.Item.ItemIndex].ToString;
  SourceGrid.DataBind(); // To set DataSource
  Eh := SourceGrid.DataSource as ElementHandle;
  Row := eh.RenderElement(ObjectForId(Id));
  for colIndex := 0 to SourceGrid.Columns.Count-1 do
  begin
    Col := BoundColumn(SourceGrid.Columns[colIndex]);
    if Assigned(Col) and (not Col.ReadOnly) then
      eh.SetRenderedElementProperty(row, Col.DataField, (e.Item.Cells[colIndex].Controls[0] as TextBox).Text, true);
  end;
  UpdateDatabase;
  SourceGrid.EditItemIndex := -1;
  DataBind;
end;

procedure TWebForm1.DataGrid_CancelCommand(source: TObject;e: System.Web.UI.WebControls.DataGridCommandEventArgs);
begin
  (source as DataGrid).EditItemIndex := -1;
  DataBind;
end;
{$ENDREGION}

procedure TWebForm1.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

function TWebForm1.get_EcoSpace: TExemploEco3AspNetEcoSpace;
begin
  if not Assigned(fEcoSpace) then
  begin
    fEcoSpace := TEcoSpaceProvider.GetEcoSpace;
    rhRoot.EcoSpace := fEcoSpace;
    // Set additional root handles here and in DoneWithEcoSpace
  end;
  Result := fEcoSpace;
end;

procedure TWebForm1.DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;
  rhRoot.EcoSpace := nil;
  rhRoot.SetElement(nil);
  // Clear all other references to ecoSpace or its contents here.
  // Otherwise it is not safe to return it to a pool.
  TEcoSpaceProvider.ReturnEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

end.

