unit Package_1Unit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Cliente = class;
  [UmlElement('Package', Id='6D347ADC-336B-48C0-BC79-57A19E43463D')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Cliente))]
  Package_1 = class
  end;

  [assembly: RuntimeRequired(TypeOf(Package_1))]
  IClienteList = interface;
  
  [UmlCollection(TypeOf(Cliente))]
  IClienteList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Cliente;
    procedure set_Item(index: Integer; Value: Cliente);
    property Item[index: Integer]: Cliente read get_Item write set_Item; default;
    function Add(value: Cliente): Integer;
    function Contains(value: Cliente): Boolean;
    function IndexOf(value: Cliente): Integer;
    procedure Insert(index: Integer; value: Cliente);
    procedure Remove(value: Cliente);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='2c532279-3362-4a68-ac0b-e09bde996e66')]
  Cliente = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 2);
    const
      Email = Eco_FirstMember;
    const
      Nome = (Eco_LoopbackIndices.Email + 1);
    end;

    ClienteListAdapter = class(ObjectListAdapter, IClienteList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Cliente;
      procedure set_Item(index: Integer; Value: Cliente);
      property Item[index: Integer]: Cliente read get_Item write set_Item; default;
      function Add(value: Cliente): Integer;
      function Contains(value: Cliente): Boolean;
      function IndexOf(value: Cliente): Integer;
      procedure Insert(index: Integer; value: Cliente);
      procedure Remove(value: Cliente);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Nome: string;
    procedure set_Nome(Value: string);
    [UmlElement(Id='ae484305-ef13-4bd2-bdbb-d92c036bdabe', Index=Eco_LoopbackIndices.Nome)]
    property Nome: string read get_Nome write set_Nome;
    function get_Email: string;
    procedure set_Email(Value: string);
    [UmlElement(Id='5a60f10c-d938-489a-b1cf-e460dad3889e', Index=Eco_LoopbackIndices.Email)]
    property Email: string read get_Email write set_Email;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

function Cliente.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Cliente.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Cliente.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Cliente.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Cliente.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Cliente.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Cliente.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Cliente.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Cliente.get_Email: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Email)));
end;

procedure Cliente.set_Email(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Email, (System.Object(Value)));
end;

function Cliente.get_Nome: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Nome)));
end;

procedure Cliente.set_Nome(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Nome, (System.Object(Value)));
end;

constructor Cliente.ClienteListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Cliente.ClienteListAdapter.get_Item(index: Integer): Cliente;
begin
  Result := (Package_1Unit.Cliente(inherited Adaptee[index]));
end;

procedure Cliente.ClienteListAdapter.set_Item(index: Integer; Value: Cliente);
begin
  inherited Adaptee[index] := value;
end;

function Cliente.ClienteListAdapter.Add(value: Cliente): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Cliente.ClienteListAdapter.Contains(value: Cliente): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Cliente.ClienteListAdapter.IndexOf(value: Cliente): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Cliente.ClienteListAdapter.Insert(index: Integer; value: Cliente);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Cliente.ClienteListAdapter.Remove(value: Cliente);
begin
  Self.Adaptee.Remove(value);
end;

end.
