unit WinForm1;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data,
  Borland.Eco.Handles, Borland.Eco.Windows.Forms, Borland.Eco.WinForm, 
  System.Resources, Project11EcoSpace, Borland.Eco.AutoContainers, 
  Borland.Eco.ObjectRepresentation, Borland.Eco.UmlRt, Package_1Unit;

type
  TWinForm1 = class(System.Windows.Forms.Form, IAutoContainer)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    RHRoot: Borland.Eco.Handles.ReferenceHandle;
    EcoGlobalActions: Borland.Eco.WinForm.EcoActionExtender;
    EcoAutoForms: Borland.Eco.WinForm.EcoAutoFormExtender;
    EcoListActions: Borland.Eco.WinForm.EcoListActionExtender;
    EcoDragDrop: Borland.Eco.WinForm.EcoDragDropExtender;
    PictureBox1: System.Windows.Forms.PictureBox;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    TextBox1: System.Windows.Forms.TextBox;
    TextBox2: System.Windows.Forms.TextBox;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure PictureBox1_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    FEcoSpace: Borland.Eco.Handles.EcoSpace;
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  public
    function get_EcoSpace: Borland.Eco.Handles.EcoSpace;

    ////////////////////////////////////////////////////////////
    procedure BuildControls(element: IElement;
      autoContainerArgs: AutoContainerArgs);
    procedure HookUpGUI(ecoSpace: EcoSpace; element: IElement);
    procedure Show(autoContainerArgs: AutoContainerArgs);
    procedure set_EcoSpace(value: EcoSpace);
    ////////////////////////////////////////////////////////////
   
    constructor Create(anEcoSpace: Borland.Eco.Handles.EcoSpace);
    property EcoSpace: Borland.Eco.Handles.EcoSpace read get_EcoSpace;
  end;

  AutoContainerFactory = class(System.Object, IAutoContainerFactory)
  public
    function get_AutoContainer: IAutoContainer;
    function Matches(modelElement: IModelElement): Boolean;
  end;

  [assembly: RuntimeRequired(TypeOf(TWinForm1))]

implementation

uses
  Borland.Eco.Services;
{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm1.InitializeComponent;
var
  resources: System.Resources.ResourceManager;
begin
  resources := System.Resources.ResourceManager.Create(TypeOf(TWinForm1));
  Self.RHRoot := Borland.Eco.Handles.ReferenceHandle.Create;
  Self.EcoGlobalActions := Borland.Eco.WinForm.EcoActionExtender.Create;
  Self.EcoAutoForms := Borland.Eco.WinForm.EcoAutoFormExtender.Create;
  Self.EcoListActions := Borland.Eco.WinForm.EcoListActionExtender.Create;
  Self.EcoDragDrop := Borland.Eco.WinForm.EcoDragDropExtender.Create;
  Self.PictureBox1 := System.Windows.Forms.PictureBox.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.TextBox1 := System.Windows.Forms.TextBox.Create;
  Self.TextBox2 := System.Windows.Forms.TextBox.Create;
  Self.SuspendLayout;
  // 
  // RHRoot
  // 
  Self.RHRoot.EcoSpaceType := TypeOf(Project11EcoSpace.TProject11EcoSpace);
  Self.RHRoot.StaticValueTypeName := 'Cliente';
  // 
  // EcoGlobalActions
  // 
  Self.EcoGlobalActions.RootHandle := Self.RHRoot;
  // 
  // PictureBox1
  // 
  Self.PictureBox1.Image := (System.Drawing.Image(resources.GetObject('Pictu' +
    'reBox1.Image')));
  Self.PictureBox1.Location := System.Drawing.Point.Create(16, 16);
  Self.PictureBox1.Name := 'PictureBox1';
  Self.PictureBox1.TabIndex := 0;
  Self.PictureBox1.TabStop := False;
  Include(Self.PictureBox1.Click, Self.PictureBox1_Click);
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(16, 88);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(40, 23);
  Self.Label1.TabIndex := 1;
  Self.Label1.Text := 'Nome:';
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(16, 136);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(40, 23);
  Self.Label2.TabIndex := 2;
  Self.Label2.Text := 'Email:';
  // 
  // TextBox1
  // 
  Self.TextBox1.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.RHRoot, 'Nome'));
  Self.TextBox1.Location := System.Drawing.Point.Create(64, 88);
  Self.TextBox1.Name := 'TextBox1';
  Self.TextBox1.Size := System.Drawing.Size.Create(216, 20);
  Self.TextBox1.TabIndex := 3;
  Self.TextBox1.Text := '';
  // 
  // TextBox2
  // 
  Self.TextBox2.DataBindings.Add(System.Windows.Forms.Binding.Create('Text', 
        Self.RHRoot, 'Email'));
  Self.TextBox2.Location := System.Drawing.Point.Create(64, 136);
  Self.TextBox2.Name := 'TextBox2';
  Self.TextBox2.Size := System.Drawing.Size.Create(216, 20);
  Self.TextBox2.TabIndex := 4;
  Self.TextBox2.Text := '';
  // 
  // TWinForm1
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.BackColor := System.Drawing.Color.White;
  Self.ClientSize := System.Drawing.Size.Create(312, 222);
  Self.Controls.Add(Self.TextBox2);
  Self.Controls.Add(Self.TextBox1);
  Self.Controls.Add(Self.Label2);
  Self.Controls.Add(Self.Label1);
  Self.Controls.Add(Self.PictureBox1);
  Self.Name := 'TWinForm1';
  Self.Text := 'TWinForm1';
  Self.ResumeLayout(False);
end;
{$ENDREGION}


procedure TWinForm1.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

procedure TWinForm1.BuildControls(element: IElement;
  autoContainerArgs: AutoContainerArgs);
begin

end;

constructor TWinForm1.Create(anEcoSpace: Borland.Eco.Handles.EcoSpace);
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
  FEcoSpace := anEcoSpace;
  // Note that you need to set the EcoSpace property for each ReferenceHandle you add to the form.
  RHRoot.EcoSpace := FEcoSpace;
end;

function TWinForm1.get_EcoSpace: Borland.Eco.Handles.EcoSpace;
begin
  Result := FEcoSpace;
end;

procedure TWinForm1.HookUpGUI(ecoSpace: EcoSpace; element: IElement);
begin
  FEcoSpace := ecoSpace;
  RHRoot.EcoSpace := self.EcoSpace;
  RHRoot.SetElement(element);
end;

procedure TWinForm1.PictureBox1_Click(sender: System.Object; e: System.EventArgs);
begin

end;

procedure TWinForm1.set_EcoSpace(value: EcoSpace);
begin
  if value <> FEcoSpace then
    FEcoSpace := value;
end;

procedure TWinForm1.Show(autoContainerArgs: AutoContainerArgs);
var
  FormContainer: IAutoContainer;
begin
  FormContainer := AutoContainerService.Instance.CreateContainer(
                      rhRoot.Element, autoContainerArgs);
  Form(FormContainer).Show;
end;

{ AutoContainerFactory }

function AutoContainerFactory.get_AutoContainer: IAutoContainer;
begin
  Result := TWinForm1.Create(nil);
end;

function AutoContainerFactory.Matches(modelElement: IModelElement): Boolean;
begin
  Result := modelElement.Name.Equals(Cliente.ClassName);
end;

initialization
  AutoContainerService.Instance.AddFactory
                 (AutoContainerFactory.Create);

end.
