unit ListAct;

interface

uses
  ActnList, Classes, StdCtrls, ExtActns, Controls;

type
  TMyCustomListAction = class (TListControlAction)
  protected
    function TargetList (Target: TObject): TCustomListBox;
    function GetControl(Target: TObject): TCustomListControl;
  public
    procedure UpdateTarget (Target: TObject); override;
  published
    property Caption;
    property Enabled;
    property HelpContext;
    property Hint;
    property ImageIndex;
    property ListControl;
    property ShortCut;
    property SecondaryShortCuts;
    property Visible;
    property OnHint;
  end;

  TMyListCutAction = class (TMyCustomListAction)
  public
    procedure ExecuteTarget(Target: TObject); override;
  end;

  TMyListCopyAction = class (TMyCustomListAction)
  public
    procedure ExecuteTarget(Target: TObject); override;
  end;

  TMyListPasteAction = class (TMyCustomListAction)
  public
    procedure UpdateTarget (Target: TObject); override;
    procedure ExecuteTarget (Target: TObject); override;
  end;

procedure Register;

implementation

uses
  Windows, Clipbrd;

function TMyCustomListAction.GetControl(Target: TObject): TCustomListControl;
begin
  Result := Target as TCustomListControl;
end;

function TMyCustomListAction.TargetList (Target: TObject): TCustomListBox;
begin
  Result := GetControl (Target) as TCustomListBox;
end;

procedure TMyCustomListAction.UpdateTarget(Target: TObject);
begin
  Enabled := (TargetList (Target).Items.Count > 0)
    and (TargetList (Target).ItemIndex >= 0);
end;

procedure TMyListCopyAction.ExecuteTarget(Target: TObject);
begin
  with TargetList (Target) do
    Clipboard.AsText := Items [ItemIndex];
end;

procedure TMyListCutAction.ExecuteTarget(Target: TObject);
begin
  with TargetList (Target) do
  begin
    Clipboard.AsText := Items [ItemIndex];
    Items.Delete (ItemIndex);
  end;
end;

procedure TMyListPasteAction.ExecuteTarget(Target: TObject);
begin
  TargetList (Target).Items.Add (Clipboard.AsText);
end;

procedure TMyListPasteAction.UpdateTarget(Target: TObject);
begin
  Enabled := Clipboard.HasFormat (CF_TEXT);
end;

procedure Register;
begin
  RegisterActions ('List',
    [TMyListCutAction, TMyListCopyAction, TMyListPasteAction], nil);
end;

end.
