unit Admin;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.Web,
  Borland.Eco.Handles;

type
  TWebForm2 = class(Borland.Eco.Web.AutoForm)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    fEcoSpace: Borland.Eco.Handles.EcoSpace;
  strict protected
    PlaceHolder1: System.Web.UI.WebControls.PlaceHolder;
    procedure OnInit(e: EventArgs); override;
    function get_EcoSpace: Borland.Eco.Handles.EcoSpace; override;
    procedure RetrieveEcoSpace; override;
    procedure DoneWithEcoSpace; override;
    function get_ParentControl: Control; override; 

    property EcoSpace: Borland.Eco.Handles.EcoSpace read get_EcoSpace;
  end;

implementation

uses
  Borland.Eco.Services, EcoSpaceProvider;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm2.InitializeComponent;
begin
end;
{$ENDREGION}

procedure TWebForm2.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

function TWebForm2.get_EcoSpace: Borland.Eco.Handles.EcoSpace;
begin
  Result := fEcoSpace;
end;

procedure TWebForm2.DoneWithEcoSpace;
begin
  if not Assigned(fEcoSpace) then
    Exit;

  TEcoSpaceProvider.ReturnEcoSpace(fEcoSpace);
  fEcoSpace := nil;
end;

procedure TWebForm2.RetrieveEcoSpace;
begin
  if not Assigned(fEcoSpace) then
  begin
    fEcoSpace := TEcoSpaceProvider.GetEcoSpace;
    // Set additional root handles here and in DoneWithEcoSpace
  end;
end;

function TWebForm2.get_ParentControl: Control;
begin
  result := PlaceHolder1;
end;

end.

