unit EcoSpaceProvider;

interface

uses
  Borland.Eco.Handles,
  Borland.Eco.Web,
  EcoIIIAuthenticationAspNetEcoSpace;

const
  // ToDo: Configure the strategy for the provider by changing the constant
  MODE: EcoSpaceStrategyHandler.SessionStateMode = EcoSpaceStrategyHandler.SessionStateMode.IfDirty;
   
type
  TEcoSpaceProvider = class
  public
		class function GetEcoSpace: TEcoIIIAuthenticationAspNetEcoSpace; static;
    class procedure ReturnEcoSpace(aEcoSpace: EcoSpace); static;
		class function GetSessionFreeEcoSpace: TEcoIIIAuthenticationAspNetEcoSpace; static;
    class procedure ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace); static;
    class procedure ClearSessionState; static;
  end;

implementation

// Utility methods

function GetHandler: EcoSpaceStrategyHandler;
begin
  Result := EcoSpaceStrategyHandler.Create(MODE, typeof(TEcoIIIAuthenticationAspNetEcoSpace));
end;

{ TEcoSpaceProvider }

class procedure TEcoSpaceProvider.ClearSessionState;
begin
  GetHandler.ClearSessionState;
end;

class function TEcoSpaceProvider.GetEcoSpace(): TEcoIIIAuthenticationAspNetEcoSpace;
begin
  Result := TEcoIIIAuthenticationAspNetEcoSpace(GetHandler.GetEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnEcoSpace(aEcoSpace);
end;

class function TEcoSpaceProvider.GetSessionFreeEcoSpace(): TEcoIIIAuthenticationAspNetEcoSpace;
begin
  Result := TEcoIIIAuthenticationAspNetEcoSpace(GetHandler.GetSessionFreeEcoSpace);
end;

class procedure TEcoSpaceProvider.ReturnSessionFreeEcoSpace(aEcoSpace: EcoSpace);
begin
  GetHandler.ReturnSessionFreeEcoSpace(aEcoSpace);
end;

end.
