unit Package_1Unit;

interface

uses
  System.ComponentModel,
  System.Collections,
  Borland.Eco.Services,
  Borland.Eco.ObjectRepresentation,
  Borland.Eco.ObjectImplementation,
  Borland.Eco.UmlRt,
  Borland.Eco.UmlCodeAttributes;

type
  Usuario = class;
  Perfil = class;
  [UmlElement('Package', Id='D57B3F12-86B8-45C9-8258-02C68347EAD7')]
  [EcoCodeGenVersion('2.0')]
  [UmlMetaAttribute('ownedElement', TypeOf(Usuario))]
  [UmlMetaAttribute('ownedElement', TypeOf(Perfil))]
  Package_1 = class
  public
  type
    [UmlElement('Association', Id='8f354697-9039-4397-b0e7-f6f4562a44b6')]
    PerfilPerfilsUsuarioUsuarios = class
    end;
  end;

  [assembly: RuntimeRequired(TypeOf(Package_1))]
  IUsuarioList = interface;
  
  [UmlCollection(TypeOf(Usuario))]
  IUsuarioList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Usuario;
    procedure set_Item(index: Integer; Value: Usuario);
    property Item[index: Integer]: Usuario read get_Item write set_Item; default;
    function Add(value: Usuario): Integer;
    function Contains(value: Usuario): Boolean;
    function IndexOf(value: Usuario): Integer;
    procedure Insert(index: Integer; value: Usuario);
    procedure Remove(value: Usuario);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  IPerfilList = interface;
  
  [UmlElement(Id='10d86cbc-2a25-4add-90da-bedb53b34ce4')]
  Usuario = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 4);
    const
      Senha = Eco_FirstMember;
    const
      Nome = (Eco_LoopbackIndices.Senha + 1);
    const
      Email = (Eco_LoopbackIndices.Nome + 1);
    const
      Perfils = (Eco_LoopbackIndices.Email + 1);
    end;

    UsuarioListAdapter = class(ObjectListAdapter, IUsuarioList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Usuario;
      procedure set_Item(index: Integer; Value: Usuario);
      property Item[index: Integer]: Usuario read get_Item write set_Item; default;
      function Add(value: Usuario): Integer;
      function Contains(value: Usuario): Boolean;
      function IndexOf(value: Usuario): Integer;
      procedure Insert(index: Integer; value: Usuario);
      procedure Remove(value: Usuario);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Nome: string;
    procedure set_Nome(Value: string);
    [UmlElement(Id='40926d13-fbe1-4076-841e-1e9b3a6939e6', Index=Eco_LoopbackIndices.Nome)]
    property Nome: string read get_Nome write set_Nome;
    function get_Email: string;
    procedure set_Email(Value: string);
    [UmlElement(Id='63055ad5-4aaa-4b40-8047-569551638278', Index=Eco_LoopbackIndices.Email)]
    property Email: string read get_Email write set_Email;
    function get_Senha: string;
    procedure set_Senha(Value: string);
    [UmlElement(Id='05db3e19-20b7-4cda-872b-3d97821c723b', Index=Eco_LoopbackIndices.Senha)]
    property Senha: string read get_Senha write set_Senha;
    function get_Perfils: IPerfilList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Perfils, Id='d0232224' +
    '-763c-4d03-98c2-fe86468bbb16')]
    [UmlMetaAttribute('association', TypeOf(Package_1.PerfilPerfilsUsuarioUsuarios), Index=0)]
    [UmlMetaAttribute('multiplicity', '1..*')]
    property Perfils: IPerfilList read get_Perfils;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;
  
  [UmlCollection(TypeOf(Perfil))]
  IPerfilList = interface(ICollection)
    {$REGION 'ECO generated code'}
    function get_Item(index: Integer): Perfil;
    procedure set_Item(index: Integer; Value: Perfil);
    property Item[index: Integer]: Perfil read get_Item write set_Item; default;
    function Add(value: Perfil): Integer;
    function Contains(value: Perfil): Boolean;
    function IndexOf(value: Perfil): Integer;
    procedure Insert(index: Integer; value: Perfil);
    procedure Remove(value: Perfil);
    procedure Clear;
    procedure RemoveAt(index: Integer);
    {$ENDREGION 'ECO generated code'}
  end;
  
  [UmlElement(Id='b505f602-ce13-45c7-ba6c-5b3185e5f38f')]
  Perfil = class(System.Object, ILoopBack)
    {$REGION 'ECO generated code'}
  public
  type
    Eco_LoopbackIndices = class
    public
    const
      Eco_FirstMember = 0;
    const
      Eco_MemberCount = (Eco_FirstMember + 3);
    const
      Descricao = Eco_FirstMember;
    const
      Nome = (Eco_LoopbackIndices.Descricao + 1);
    const
      Usuarios = (Eco_LoopbackIndices.Nome + 1);
    end;

    PerfilListAdapter = class(ObjectListAdapter, IPerfilList)
    public
      constructor Create(source: IList);
      function get_Item(index: Integer): Perfil;
      procedure set_Item(index: Integer; Value: Perfil);
      property Item[index: Integer]: Perfil read get_Item write set_Item; default;
      function Add(value: Perfil): Integer;
      function Contains(value: Perfil): Boolean;
      function IndexOf(value: Perfil): Integer;
      procedure Insert(index: Integer; value: Perfil);
      procedure Remove(value: Perfil);
    end;
    
  strict protected
    eco_Content: IContent;
  strict private
    function IObjectProvider.AsIObject = IObjectProvider_AsIObject;
    function IObjectProvider_AsIObject: IObject;
  public
    function AsIObject: IObjectInstance;
    procedure set_MemberByIndex(index: Integer; value: System.Object); virtual;
    function get_MemberByIndex(index: Integer): System.Object; virtual;
    function get_Nome: string;
    procedure set_Nome(Value: string);
    [UmlElement(Id='5884e76b-eef8-402a-b994-a1cf31d4a7db', Index=Eco_LoopbackIndices.Nome)]
    property Nome: string read get_Nome write set_Nome;
    function get_Descricao: string;
    procedure set_Descricao(Value: string);
    [UmlElement(Id='02b1f4dc-3ea8-4e72-968f-4eae6ef5f33a', Index=Eco_LoopbackIndices.Descricao)]
    property Descricao: string read get_Descricao write set_Descricao;
    function get_Usuarios: IUsuarioList;
    [UmlElement('AssociationEnd', Index=Eco_LoopbackIndices.Usuarios, Id=('39d376' +
    '4' + '2-1bcd-4a00-8f1e-06cc209cc49d'))]
    [UmlMetaAttribute('association', TypeOf(Package_1.PerfilPerfilsUsuarioUsuarios), Index=1)]
    [UmlMetaAttribute('multiplicity', '0..*')]
    property Usuarios: IUsuarioList read get_Usuarios;
  strict protected
    procedure Deinitialize(serviceProvider: IEcoServiceProvider);
    procedure Initialize(serviceProvider: IEcoServiceProvider);
    /// <summary>For Framework Internal use only</summary>
  public
    constructor Create(content: IContent); overload;
    {$ENDREGION 'ECO generated code'}
    constructor Create(serviceProvider: IEcoServiceProvider); overload;
  end;

implementation

function Usuario.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Usuario.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Usuario.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Usuario.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Usuario.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Usuario.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Usuario.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Usuario.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Usuario.get_Perfils: IPerfilList;
begin
  Result := Package_1Unit.Perfil.PerfilListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Perfils))));
end;

function Usuario.get_Senha: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Senha)));
end;

procedure Usuario.set_Senha(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Senha, (System.Object(Value)));
end;

function Usuario.get_Email: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Email)));
end;

procedure Usuario.set_Email(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Email, (System.Object(Value)));
end;

function Usuario.get_Nome: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Nome)));
end;

procedure Usuario.set_Nome(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Nome, (System.Object(Value)));
end;

constructor Usuario.UsuarioListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Usuario.UsuarioListAdapter.get_Item(index: Integer): Usuario;
begin
  Result := (Package_1Unit.Usuario(inherited Adaptee[index]));
end;

procedure Usuario.UsuarioListAdapter.set_Item(index: Integer; Value: Usuario);
begin
  inherited Adaptee[index] := value;
end;

function Usuario.UsuarioListAdapter.Add(value: Usuario): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Usuario.UsuarioListAdapter.Contains(value: Usuario): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Usuario.UsuarioListAdapter.IndexOf(value: Usuario): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Usuario.UsuarioListAdapter.Insert(index: Integer; value: Usuario);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Usuario.UsuarioListAdapter.Remove(value: Usuario);
begin
  Self.Adaptee.Remove(value);
end;

function Perfil.IObjectProvider_AsIObject: IObject;
begin
  Result := Self.eco_Content.AsIObject;
end;

function Perfil.AsIObject: IObjectInstance;
begin
  Result := Self.eco_Content.AsIObject;
end;

procedure Perfil.set_MemberByIndex(index: Integer; value: System.Object);
begin
  raise System.IndexOutOfRangeException.Create;
end;

function Perfil.get_MemberByIndex(index: Integer): System.Object;
begin
  raise System.IndexOutOfRangeException.Create;
end;

procedure Perfil.Deinitialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content <> nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    factory.CreateContentFailed(Self.eco_Content, Self);
    Self.eco_Content := nil;
  end;
end;

procedure Perfil.Initialize(serviceProvider: IEcoServiceProvider);
var
  factory: IInternalObjectContentFactory;
begin
  if (Self.eco_Content = nil) then
  begin
    factory := (IInternalObjectContentFactory(serviceProvider.GetEcoService(TypeOf(IInternalObjectContentFactory))));
    Self.eco_Content := factory.CreateContent(Self);
    Self.eco_Content.LoopbackValid;
  end;
end;

/// <summary>For Framework Internal use only</summary>
constructor Perfil.Create(content: IContent);
begin
  inherited Create;
  Self.eco_Content := content;
  content.AssertLoopbackUnassigned;
end;

{$ENDREGION 'ECO generated code'}

constructor Perfil.Create(serviceProvider: IEcoServiceProvider);
begin
  inherited Create;
  Self.Initialize(serviceProvider);
  try
    // User code here
  except
    on System.Exception do
    begin
      Self.Deinitialize(serviceProvider);
      raise;
    end;
  end;
end;

function Perfil.get_Usuarios: IUsuarioList;
begin
  Result := Package_1Unit.Usuario.UsuarioListAdapter.Create((IList(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Usuarios))));
end;

function Perfil.get_Descricao: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Descricao)));
end;

procedure Perfil.set_Descricao(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Descricao, (System.Object(Value)));
end;

function Perfil.get_Nome: string;
begin
  Result := (string(Self.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Nome)));
end;

procedure Perfil.set_Nome(Value: string);
begin
  Self.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Nome, (System.Object(Value)));
end;

constructor Perfil.PerfilListAdapter.Create(source: IList);
begin
  inherited Create(source);
end;

function Perfil.PerfilListAdapter.get_Item(index: Integer): Perfil;
begin
  Result := (Package_1Unit.Perfil(inherited Adaptee[index]));
end;

procedure Perfil.PerfilListAdapter.set_Item(index: Integer; Value: Perfil);
begin
  inherited Adaptee[index] := value;
end;

function Perfil.PerfilListAdapter.Add(value: Perfil): Integer;
begin
  Result := Self.Adaptee.Add(value);
end;

function Perfil.PerfilListAdapter.Contains(value: Perfil): Boolean;
begin
  Result := Self.Adaptee.Contains(value);
end;

function Perfil.PerfilListAdapter.IndexOf(value: Perfil): Integer;
begin
  Result := Self.Adaptee.IndexOf(value);
end;

procedure Perfil.PerfilListAdapter.Insert(index: Integer; value: Perfil);
begin
  Self.Adaptee.Insert(index, value);
end;

procedure Perfil.PerfilListAdapter.Remove(value: Perfil);
begin
  Self.Adaptee.Remove(value);
end;

{ Package_1 }


end.
