unit BDEDataManager;

interface

uses
  Classes, Db, DataManager, DbTables;

type

  TBDEConnection = class(TConnection)
    constructor Create(AOwner: TComponent); override;
  private
    Query: TQuery;
  public
    DataBase: TDataBase;
    function ExecuteQuery(const SQL: string): TDataSet; override;
    procedure ExecuteCommand(const SQL: string); override;

    procedure Connect; override;
    procedure Disconnect; override;
    function Connected: Boolean; override;
  end;

implementation

{ TBDEConnection }

procedure TBDEConnection.Connect;
begin
  inherited;
  DataBase.Open;
end;

function TBDEConnection.Connected: Boolean;
begin
  Result := DataBase.Connected;
end;

constructor TBDEConnection.Create(AOwner: TComponent);
begin
  inherited;
  Query := TQuery.Create(Self);
end;

procedure TBDEConnection.Disconnect;
begin
  inherited;
  DataBase.Close;
end;

procedure TBDEConnection.ExecuteCommand(const SQL: string);
begin
  inherited;
  DataBase.Execute(SQL, nil);
end;

function TBDEConnection.ExecuteQuery(const SQL: string): TDataSet;
begin
  if Query.DatabaseName = '' then
    Query.DatabaseName := DataBase.DatabaseName;

  Query.SQL.Text := '';
  Query.SQL.Text := SQL;
  Query.Open;
  Result := Query;
end;

end.
