unit DataManager;

interface

uses
  Classes, Db;

type
  TConnection = class(TComponent)
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  public
    function ExecuteQuery(const SQL: string): TDataSet; virtual; abstract;
    procedure ExecuteCommand(const SQL: string); virtual; abstract;

    procedure Connect; virtual; abstract;
    procedure Disconnect; virtual; abstract;
    function Connected: Boolean; virtual; abstract;
  end;

var
  Connection: TConnection;

implementation

uses SysUtils;

{ TConnection }

constructor TConnection.Create(AOwner: TComponent);
begin
  inherited;
  Connection := Self;
end;

destructor TConnection.Destroy;
begin
  Disconnect;
  inherited;
end;

end.
