unit DbExpressDataManager;

interface

uses
  Classes, Db, DataManager, SqlExpr;

type

  TDbExpressConnection = class(TConnection)
    constructor Create(AOwner: TComponent); override;    
  private
    SQLQuery: TSQLQuery;
  public
    SQLConnection: TSQLConnection;
    function ExecuteQuery(const SQL: string): TDataSet; override;
    procedure ExecuteCommand(const SQL: string); override;

    procedure Connect; override;
    procedure Disconnect; override;
    function Connected: Boolean; override;
  end;

implementation

{ TDbExpressConnection }

procedure TDbExpressConnection.Connect;
begin
  inherited;
  SQLConnection.Open;
end;

function TDbExpressConnection.Connected: Boolean;
begin
  Result := SQLConnection.Connected;
end;

constructor TDbExpressConnection.Create(AOwner: TComponent);
begin
  inherited;
  SQLQuery := TSQLQuery.Create(Self);
end;

procedure TDbExpressConnection.Disconnect;
begin
  inherited;
  SQLConnection.Close;
end;

procedure TDbExpressConnection.ExecuteCommand(const SQL: string);
begin
  inherited;
  SQLConnection.ExecuteDirect(SQL);
end;

function TDbExpressConnection.ExecuteQuery(const SQL: string): TDataSet;
begin
  if SQLQuery.SQLConnection = nil then
    SQLQuery.SQLConnection := SQLConnection;
  SQLQuery.SQL.Text := '';
  SQLQuery.SQL.Text := SQL;
  SQLQuery.Open;
  Result := SQLQuery;
end;

end.
