
unit WebForm2;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWebForm2 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure ddwProjetos_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure ddwView_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    ddlProjetos: System.Web.UI.WebControls.DropDownList;
    Label1: System.Web.UI.WebControls.Label;
    Label2: System.Web.UI.WebControls.Label;
    ddlView: System.Web.UI.WebControls.DropDownList;
    Label3: System.Web.UI.WebControls.Label;
    Label4: System.Web.UI.WebControls.Label;
    Label5: System.Web.UI.WebControls.Label;
    tbxSinopse: System.Web.UI.WebControls.TextBox;
    rblTipo: System.Web.UI.WebControls.RadioButtonList;
    Button1: System.Web.UI.WebControls.Button;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation
    {$Autobox on}
    uses Borland.StarTeam;
    
{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm2.InitializeComponent;
begin
  Include(Self.ddlProjetos.SelectedIndexChanged, Self.ddwProjetos_SelectedIndexChanged);
  Include(Self.ddlView.SelectedIndexChanged, Self.ddwView_SelectedIndexChanged);
  Include(Self.Button1.Click, Self.Button1_Click);
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}

procedure TWebForm2.Page_Load(sender: System.Object; e: System.EventArgs);
var
  oProject: Project;
begin
  if not isPostBack then
  begin
    for oProject in Borland.StarTeam.Server(Session['STSERVER']).Projects do
      ddlProjetos.Items.Add(ListItem.Create(oProject.Name, oProject.Name));
    ddlProjetos.DataBind;
  end;
end;

procedure TWebForm2.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TWebForm2.Button1_Click(sender: System.Object; e: System.EventArgs);
var
  CR: ChangeRequest;
  FD: Folder;
begin
  FD := Borland.StarTeam.Server(Session['STSERVER']).Projects.Item
         [ddlProjetos.SelectedValue].Views.Item[ddlView.SelectedValue].RootFolder;
  CR := ChangeRequest.Create(FD);
  CR.Synopsis := tbxSinopse.Text;
  CR.RequestType := rblTipo.SelectedIndex;
  CR.Responsibility :=
  Borland.StarTeam.Server(Session['STSERVER']).Users.IndexOf
    (Borland.StarTeam.Server(Session['STSERVER']).Users.Item['Adilson Jr']);
  CR.Update;
end;


procedure TWebForm2.ddwView_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
begin


end;

procedure TWebForm2.ddwProjetos_SelectedIndexChanged(sender: System.Object; e: System.EventArgs);
var
  oView: View;
begin
  for oView in Borland.StarTeam.Server(Session['STSERVER']).Projects.Item
         [ddlProjetos.SelectedValue].Views do
    ddlView.Items.Add(ListItem.Create(oView.Name, oView.Name));
  ddlView.DataBind;
end;

end.

