unit UEntrada;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UCadastro, DB, ExtCtrls, DBCtrls, StdCtrls, Buttons, Mask,
  Grids, DBGrids;

type
  TFrmEntrada = class(TFrmCadastro)
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    EdtData: TDBEdit;
    EdtEmpresa: TDBEdit;
    Label8: TLabel;
    btnLocalizarEmpresa: TSpeedButton;
    DBGrid1: TDBGrid;
    dsItem_Entrada: TDataSource;
    Label3: TLabel;
    Bevel1: TBevel;
    Label4: TLabel;
    EdtCodBarras: TDBEdit;
    Label5: TLabel;
    EdtProduto: TDBEdit;
    Label6: TLabel;
    DBEdit5: TDBEdit;
    Label7: TLabel;
    DBEdit6: TDBEdit;
    btnLocalizarProduto: TSpeedButton;
    procedure btnNovoClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnLocalizarEmpresaClick(Sender: TObject);
    procedure btnLocalizarProdutoClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmEntrada: TFrmEntrada;

implementation

uses UDMClient, UDMLocalizar, ULocalizarCDS;

{$R *.dfm}

procedure TFrmEntrada.btnNovoClick(Sender: TObject);
begin
  inherited;
  DBEdit1.SetFocus;
end;

procedure TFrmEntrada.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  FrmEntrada:= nil;
end;

procedure TFrmEntrada.btnLocalizarEmpresaClick(Sender: TObject);
begin
  inherited;
  try
    if TFrmLocalizarCDS.Execute('Localizar Empresa',
    dmLocalizar.cdsEmpresa,'CIDADE;ENDERECO;CNPJ','Cidade;Endereo;CNPJ') then
    begin
      DMClient.cdsEntrada.Edit;
      DMClient.cdsEntradaCOD_EMPRESA.AsInteger :=
        DMLocalizar.cdsEmpresaCOD_EMPRESA.AsInteger;
      {Exibe no campo DESC_EMPRESA o CNPJ + o Endereo + a Cidade da Empresa.
      Para permitir essa atribuio, a propriedade ReadOnly do campo DESC_EMPRESA,
      tanto no cdsEntrada quanto no dtsEntrada deve estar False.}
      DMClient.cdsEntradaDESC_EMPRESA.Text :=
        DMLocalizar.cdsEmpresaCNPJ.Text + ' - ' +
        DMLocalizar.cdsEmpresaENDERECO.Text + ' - ' +
        DMLocalizar.cdsEmpresaCIDADE.Text;
    end;
  finally
    dmLocalizar.cdsEmpresa.Close;
  end;
end;

procedure TFrmEntrada.btnLocalizarProdutoClick(Sender: TObject);
var sql: string;
begin
  try
    {Antes de chamar o form de localizao, armazena na varivel local
    sql, a instruo sql contida no cdsProduto do dmLocalizar, pois
    a sql dele ser alterada para mostrar somente os produtos
    da empresa selecionada no campo Empresa deste formulrio (FrmEmpresa). } 
    sql:= dmLocalizar.cdsProduto.CommandText;

    {Altera a sql do cdsProduto no dmLocalizar para trazer os mesmos
    campos que j estava trazendo, s que incluindo-se um where
    para mostrar os produtos da empresa escolhida neste form. }
    dmLocalizar.cdsProduto.CommandText:=
      ' select P.COD_PRODUTO, P.COD_BARRAS, P.DESCRICAO, P.ESTOQUE_ATUAL, ' +
      ' P.PRECO_VENDA, P.COD_EMPRESA, E.CIDADE, E.ENDERECO ' +
      ' from PRODUTO P inner join EMPRESA E ' +
      ' on P.COD_EMPRESA = E.COD_EMPRESA ' +
      ' where P.COD_EMPRESA = ' + DMClient.cdsEntradaCOD_EMPRESA.Text +
      ' order by P.DESCRICAO ';
    if TFrmLocalizarCDS.Execute('Localizar Produto',
    dmLocalizar.cdsProduto, 'DESCRICAO;COD_BARRAS',
    'Descrio;Cdigo Barras') then
    begin
      DMClient.cdsItem_Entrada.Edit;
      DMClient.cdsItem_EntradaCOD_PRODUTO.AsInteger :=
        DMLocalizar.cdsProdutoCOD_PRODUTO.AsInteger;
      DMClient.cdsItem_EntradaCOD_BARRAS.Text :=
        DMLocalizar.cdsProdutoCOD_BARRAS.Text;
      DMClient.cdsItem_EntradaDESC_PRODUTO.Text :=
        DMLocalizar.cdsProdutoDESCRICAO.Text;
    end;
  finally
    DMLocalizar.cdsProduto.close;
    {Retorna a sql original do cdsProduto no dmLocalizar.}
    dmLocalizar.cdsProduto.CommandText:= sql;
  end;
end;

procedure TFrmEntrada.btnSalvarClick(Sender: TObject);
begin
  inherited;
  {Verifica se o COD_ENTRADA  igual a zero, indicando
  que o registro  novo. Depois verifica se a quantidade
  de alteraes no cdsEntrada  igual a zero, indicando que
  as alteraes pendentes foram aplicadas no banco de dados
  com sucesso. }
  if (DMClient.cdsEntradaCOD_ENTRADA.AsInteger = 0)
  and (DMClient.cdsEntrada.ChangeCount = 0) then
  begin
      {Carrega o(s) novo(s) valor(es) para o(s) parmetro(s)
      do cdsEntrada. }
      DMClient.cdsEntrada.FetchParams;
      {Atualiza os dados para mostrar os novos cdigos gerados.}
      DMClient.cdsEntrada.Refresh;
  end;
end;

end.
