unit ULocalizarCDS;

interface

uses
  StrUtils, Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Db, Grids, DBGrids, Buttons, DBClient, Mask;

type
  TFrmLocalizarCDS = class(TForm)
    Label1: TLabel;
    EdtDado: TMaskEdit;
    Label2: TLabel;
    cbxCampo: TComboBox;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    btnOk: TBitBtn;
    btnCancelar: TBitBtn;
    btnLocalizar: TBitBtn;
    Label3: TLabel;
    cbxCoincidir: TComboBox;
    lbNumRegs: TLabel;
    procedure btnLocalizarClick(Sender: TObject); //ok
    procedure EdtDadoChange(Sender: TObject); //ok
    procedure DBGrid1DblClick(Sender: TObject); //ok
    procedure btnOkClick(Sender: TObject); //ok
    procedure cbxCampoChange(Sender: TObject);
    procedure DBGrid1KeyPress(Sender: TObject; var Key: Char); //ok
  private
    { Private declarations }
    FDisplayLabels, FFieldNames: TStringList; //ok
    FCDS: TClientDataSet; //ok
    procedure ClientDataSetAfterClose(DataSet: TDataSet); //ok
    procedure Mostra_Num_Regs; //ok
  public
    { Public declarations }
    class function Execute(const Titulo: ShortString;
      CDS: TClientDataSet; FieldNames, DisplayLabels: String;
      LocateOnKeyPress: Boolean=false): Boolean; //ok
  end;

var
  FrmLocalizarCDS: TFrmLocalizarCDS;
  FSQL: String; 

implementation


{$R *.DFM}

procedure TFrmLocalizarCDS.btnLocalizarClick(Sender: TObject);
var
  operador: String[10];
  sql, orderby: String;
  i: integer;
  Campo_Data_Hora: Boolean;
begin
  {Verifica se o campo selecionado para a busca tem o nome "Data",
  pois se tiver, ser feita uma busca por data, e assim,  utilizado
  parmetro dentro da SQL para executar o filtro por data.}
  Campo_Data_Hora := AnsiSameText(cbxCampo.Text, 'Data');
  try
    //Muda o cursor para uma ampulheta.
    Screen.Cursor:= crHourGlass;
    {Armazena na varivel local SQL, o valor da varivel privada
    FSQL (que contm a SQL original do ClientDataSet). A varivel
    SQL ser alterada, inclundo-se um where de acordo
    com os dados informados pelo usurio neste form.}
    SQL:= FSQL;
    //Limpa a varivel orderby.
    orderby:= '';
    {Fecha o ClientDataSet para poder executar a busca
    no cdigo mais abaixo.}
    FCDS.close;
    
    {Verifica se na instruo SQL, que j existia no
    ClientDataSet no momento da chamada do form de localizao,
    existe uma clusula WHERE. Se existir, a varivel
    operador ser igual a AND, seno ser igual a WHERE.
    Esta varivel ser usado para incluir a condio
    de filtro na instruo SQL.}
    if pos('where', AnsiLowerCase(SQL)) > 0 then
       operador:= ' and '
    else operador:= ' where ';

    {Verifica se na SQL j existe uma clusula order by.
    A funo AnsiLowerCase converte a SQL para minsculas,
    inclusive os caracteres acentuados, para que a comparao
    seja feita somente com letras minsculas.}
    i:= pos('order by', AnsiLowerCase(SQL));
    if i > 0 then
    begin
       {Se j existir um order by na SQL, ento copia ele para
       a varivel orderby e deleta-o de dentro da instruo SQL,
       pois o order by deve ser a ltima clusula, antes do WHERE. }
       orderby:= copy(SQL, i, length(SQL));
       delete(SQL, i, length(SQL));
    end;

    FCDS.CommandText:= SQL;
    {Se o campo selecionado para a busca  um campo de Data/Hora,
    cria o filtro atravs de um parmetro na SQL.}
    if Campo_Data_Hora then
    begin
      {Monta a nova SQL no ClientDataSet
      adicionando uma condio. O nome do campo
      selecionado  retornado a partir da varivel
      FFieldNames.  utilizada o nmero do item selecionado
      no cbxCampo para pegar o nome do campo correspondente
      dentro de FFieldNames. }
      FCDS.CommandText:=
         FCDS.CommandText + operador +
         FFieldNames[cbxCampo.ItemIndex] + ' = :param ';
    end
    else
    begin
      {Se o contedo do EdtDado for diferente de %,
      adiciona o filtro. Se o contedo for igual a %,  porque
      o usurio deseja exibir todos os registros, assim,
      no  necessrio incluir filtro algum na SQL.}
      if EdtDado.text <> '%' then
         FCDS.CommandText:=
           FCDS.CommandText + operador +
           FFieldNames[cbxCampo.ItemIndex] +
           ' like %s ';
    end;
    {Inclui na SQL do ClientDataSet a clusula
    orderby para ordenar os dados.}
    FCDS.CommandText := FCDS.CommandText + orderby;

    //ShowMessage(FCDS.CommandText);
    if Campo_Data_Hora then
    begin
       {Se o campo selecionado  um campo de Data/Hora,
       o filtro ser executado a partir do valor de um
       parmetro na SQL. Assim, o contedo do EdtDado
       ser atribudo ao parmetro da SQL.}
       if EdtDado.text <> '%' then
          FCDS.Params[0].AsDateTime:= StrToDateTime(EdtDado.Text);
    end
    else
    begin
      {Tirei o parmetro e fiz diretamente o filtro na instruo sql
      pois, por exemplo, se o usurio manda buscar pelo UF da
      cidade e digitar TO, sendo que ele digitou o dado exato,
      com o tamanho mximo permitido pelo campo (pois a UF tem apenas 2 caracteres),
      a consulta sempre colocar um % em algum lugar ('TO%', por exemplo).
      Assim, como o dado buscado no parmetro  maior que o tamanho
      do campo (pois 'TO%' tem 3 caracteres e o campo UF apenas 2)
      isto tava causando erro com o Firebird, por este motivo,
      fiz a consulta diretamente no cdigo sql, sem parmetro, exceto
      quando for consulta por data.}
      if EdtDado.text <> '%' then
      begin
        {Dependente da opo escolhida pelo usurio no cbxCoincidir,
        coloca o %, utilizado no operador LIKE na SQL gerada, numa posio
        diferente.}
        {A funo Format  utilizada para substituir o %s, que foi includo na
        SQL, pelo valor do EdtDado. A funo QuotedStr coloca o contedo do EdtDado
        entre apstrofos, que  necessrio na utilizao do operador LIKE. }
        case cbxCoincidir.ItemIndex of
          //incio do campo
          0: FCDS.CommandText := Format(FCDS.CommandText,  [QuotedStr(EdtDado.text + '%')]);
          //qualquer parte
          1: FCDS.CommandText := Format(FCDS.CommandText,  [QuotedStr('%' + EdtDado.text + '%')]);
          //fim do campo
          2: FCDS.CommandText := Format(FCDS.CommandText,  [QuotedStr('%' + EdtDado.text)]);
        end;
      end;
    end;

    //Abre o ClientDataSet, executando a busca.
    FCDS.open;
    {S habilita o btnOK se o ClientDataSet no estiver vazio.}
    btnOK.enabled:= not FCDS.IsEmpty;
    //Mostra, lbNumRegs, o nmero de registros encontrados.
    Mostra_Num_Regs;

    if btnLocalizar.Visible then
    begin
      if btnOK.enabled then
         DBGrid1.SetFocus
      else EdtDado.SetFocus;
    end;
  finally
    //Volta o cursor para o formato padro.
    Screen.Cursor:= crDefault;
  end;
end;

procedure TFrmLocalizarCDS.EdtDadoChange(Sender: TObject);
begin
  //Verifica se o btnLocalizar est visvel
  if btnLocalizar.Visible then
  begin
    {Se o boto estiver visvel, caso o ClientDataSet
    esteja aberto, fecha-o.}
    if FCDS.Active then
       FCDS.close;
    {Desabilita o btnOK quando para que o usurio
    tenha que clicar no btnLocalizar para poder executar
    a busca}
    btnOk.Enabled := false;
    {O btnLocalizar s ficar habilitado se existir
    algum texto no EdtDado.}
    btnLocalizar.enabled:= EdtDado.text <> '';
  end
  {Caso o btnLocalizar no esteja visvel,  porque o parmetro
  LocateOnKeyPress na funo Execute, foi passado como True,
  assim, quando o usurio alterar o contedo do EdtDado,
   feita a busca automaticamente, chamando-se
  o mtodo Click do btnLocalizar.}
  else btnLocalizar.Click;
end;

procedure TFrmLocalizarCDS.DBGrid1DblClick(Sender: TObject);
begin
  btnOk.click;
end;

procedure TFrmLocalizarCDS.btnOkClick(Sender: TObject);
begin
  {Se o boto OK no est habilitado, ento
  impede que o form seja fechado. Isto  necessrio pois
  o mtodo Click do btnOK  chamado em outros locais do cdigo
  e, mesmo com o boto desabilitado, ele seria acionado. Como
  a sua propriedade Kind est igual a bkOK, ao ele ser acionado,
  ele fecha o form. O form s poder ser fechado pelo boto OK
  se o mesmo estiver habilitado. No evento DlbClick do DBGrid
   chamado o mtodo Click do btnOK. Se o DBGrid estiver vazio,
  o btnOK no ficar habilitado, porm, como  chamado
  o Click do boto, sem a verificao abaixo, o form
  seria fechado pelo boto OK, mesmo no tendo nenhum registro
  no DBGrid.}
  if not btnOK.Enabled then
     ModalResult:= mrNone;
end;

procedure TFrmLocalizarCDS.cbxCampoChange(Sender: TObject);
begin
  {Verifica se o texto do cbxCampo  igual a "Data",
  sem fazer distino entre mausculas e minsculas.
  Para usar a funo AnsiSameText deve-se incluir a unit
  StrUtils na clusula uses.}
  if AnsiSameText(cbxCampo.Text, 'Data') then
  begin
     {Cria uma mscara de data no EdtDado para permitir
     fazer buscas por data de uma maneira mais fcil}
     EdtDado.EditMask := '99/99/9999;1;_';
     EdtDado.Clear;
  end
  else EdtDado.EditMask := '';
  FCDS.close;
end;

class function TFrmLocalizarCDS.Execute(const Titulo: ShortString;
  CDS: TClientDataSet; FieldNames,
  DisplayLabels: String; LocateOnKeyPress: Boolean): Boolean;
begin
  result:= false;
  FrmLocalizarCDS:= TFrmLocalizarCDS.Create(Application);
  with FrmLocalizarCDS do
  try
    Caption:= Titulo;
    btnLocalizar.Visible := not LocateOnKeyPress;
    if LocateOnKeyPress then
       ActiveControl := EdtDado
    else ActiveControl := nil;
    FFieldNames := TStringList.Create;
    FDisplayLabels := TStringList.Create;

    DisplayLabels := AnsiReplaceText(DisplayLabels, ';', #13);
    DisplayLabels := AnsiReplaceText(DisplayLabels, ',', #13);
    FieldNames := AnsiReplaceText(FieldNames, ';', #13);
    FieldNames := AnsiReplaceText(FieldNames, ',', #13);
    cbxCampo.Items.text := DisplayLabels;
    cbxCampo.ItemIndex := 0;

    CDS.Close;
    CDS.AfterClose := ClientDataSetAfterClose;
    FSQL:= CDS.CommandText;
    FCDS:= CDS;
    DataSource1.DataSet := FCDS;
    FFieldNames.text:= FieldNames;
    FDisplayLabels.text:= DisplayLabels;
    if FFieldNames.Count <> FDisplayLabels.Count then
       raise Exception.Create(
         'A quantidade de valores no parmetro ' +
         'FieldNames deve ser igual a do DisplayLabels');
    cbxCampo.Enabled := (FFieldNames.Count > 1);
    if cbxCampo.Enabled then
       cbxCampo.Color:= clWindow
    else cbxCampo.Color:= clBtnFace;

    lbNumRegs.caption:= '';
    cbxCoincidir.ItemIndex:= 0;

    result:= (ShowModal = mrOK);
  finally
    FreeAndNil(FrmLocalizarCDS);
  end;
end;


procedure TFrmLocalizarCDS.ClientDataSetAfterClose(DataSet: TDataSet);
begin
  //Verifica se o form j foi fechado e destrudo.
  if FrmLocalizarCDS = nil then
  begin
     {Retorna a SQL do ClientDataSet para o valor
     original, antes da execuo do form de busca,
     pois a busca altera a SQL em tempo de execuo.
     Ao chamar a funo Execute, a SQL original
     do ClientDataSet  armazenada na varivel FSQL.
     Isto  necessrio pois, cada vez que o form de localizao
     for chamado para uma tabela, a SQL do ClientDataSet
     deve voltar ao valor inicial, definido em tempo
     de design no Delphi, permitindo que se faa
     uma nova busca, independente da busca anterior.}
     TClientDataSet(DataSet).CommandText := FSQL;
     //Limpa a varivel FSQL, uma varivel privada do form .
     FSQL:= '';
  end;
end;

procedure TFrmLocalizarCDS.Mostra_Num_Regs;
begin
  if (FCDS <> nil) and FCDS.Active then
     lbNumRegs.caption:= 'N de Registros encontrados: ' + IntToStr(FCDS.RecordCount);
end;

procedure TFrmLocalizarCDS.DBGrid1KeyPress(Sender: TObject; var Key: Char);
begin
  if key = #13 then
     btnOK.click;
end;

end.
