unit uMainForm;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBTables, Grids, DBGrids, mdGraphicText;

type
  TMainForm = class(TForm)
    db: TDatabase;
    Table1: TTable;
    DBGrid1: TDBGrid;
    DataSource1: TDataSource;
    Table1SpeciesNo: TFloatField;
    Table1Category: TStringField;
    Table1Common_Name: TStringField;
    Table1SpeciesName: TStringField;
    Table1Lengthcm: TFloatField;
    Table1Length_In: TFloatField;
    Table1Notes: TMemoField;
    Table1Graphic: TGraphicField;
    procedure FormCreate(Sender: TObject);
    procedure DBGrid1DrawColumnCell(Sender: TObject; const Rect: TRect;
      DataCol: Integer; Column: TColumn; State: TGridDrawState);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    fGraphicText: TGraphicText;
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.dfm}


const
  cGridSelectedColor = $00FFBFBF;

type
  TGridHack = class(TCustomGrid);

procedure TMainForm.FormCreate(Sender: TObject);
begin
  fGraphicText := TGraphicText.Create;
  TGridHack(DBGrid1).DefaultRowHeight := 50;
end;

procedure TMainForm.DBGrid1DrawColumnCell(Sender: TObject;
  const Rect: TRect; DataCol: Integer; Column: TColumn;
  State: TGridDrawState);
var
  notes: string;
begin
  // Se no existe dados, no faz nada
  if DBGrid1.DataSource.DataSet.IsEmpty then
    Exit;

  // Mantm a coluna com o mesmo tamanho do grid
  if DBGrid1.Columns[0].Width <> DBGrid1.ClientWidth then
  begin
    DBGrid1.Columns[0].Width := DBGrid1.ClientWidth;
    // Mantm o DefaultRowHeigth com uma altura para caber tudo
    TGridHack(DBGrid1).DefaultRowHeight := 50;
  end;

  // Configura o objeto que far todo o desenho
  fGraphicText.SetCanvas(DBGrid1.Canvas);
  fGraphicText.SetRect(Rect);

  // A linha selecionada deve aparecer com uma cor diferente
  if gdSelected in State then
  begin
    fGraphicText.Brush.Color := cGridSelectedColor;
    fGraphicText.FillRect(Rect);
  end;

  fGraphicText.Font.Style := fGraphicText.Font.Style + [fsBold];
  fGraphicText.Font.Color := clBlue;
  fGraphicText.Font.Size := 10;
  fGraphicText.Write(Table1.FieldByName('common_name').AsString);

  fGraphicText.Font.Style := fGraphicText.Font.Style - [fsBold];
  fGraphicText.Font.Size := 8;

  // Nova linha, no Canvas,  posicionar pixels...
  // mas a classe GraphicText j tem isso encapsulado no mtodo NewLine.
  fGraphicText.NewLine;

  fGraphicText.Font.Color := clBlack;
  notes := Copy(Table1.FieldByName('notes').AsString, 1, 100) + '...';
  fGraphicText.Write(notes);

  fGraphicText.NewLine;

  fGraphicText.Font.Color := clGreen;
  fGraphicText.Write('Category: ' + Table1.FieldByName('category').AsString + ' - ');
  fGraphicText.Write('Length: ' + Table1.FieldByName('Length (cm)').AsString);
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  fGraphicText.Free;
end;

end.
