unit RSSHandler;

interface
uses
      System.Web, System.IO, System.Xml, System.Text,
      System.Configuration, System.Data.SqlClient,
      System.Data, System.Web.Caching, Borland.Data.Provider;

type
  TRSSHandler = class(System.&Object, IHttpHandler)
  public
    function get_IsReusable: Boolean;
    procedure ProcessRequest(context: HttpContext);
  end;

implementation

function TRSSHandler.get_IsReusable: Boolean;
begin
  result := true;
end;

procedure TRSSHandler.ProcessRequest(context: HttpContext);
var
  strWriter: StringWriter;
  xmlWriter : XmlTextWriter;
  dtaRow: DataRow;
  SQLConn: BdpConnection;
  SqlData: BdpDataAdapter;
  Ds     : DataSet;
begin
  SqlConn := BdpConnection.Create(ConfigurationSettings.AppSettings.Item['ConnectionString']);
  SqlData := BdpDataAdapter.Create('SELECT * FROM TB_FEEDS', SqlConn);
  Ds := DataSet.Create;
  SqlData.Fill(Ds);

  Context.Response.ContentType := 'text/xml';
  Context.Response.ContentEncoding := Encoding.UTF8;

  if not Assigned(Context.Cache['RssFeed']) then
  begin
    strWriter := StringWriter.Create;
    xmlWriter := XmlTextWriter.Create(strWriter); //criaao do parse
    //todo o conteudo do xml gerado ser armazenado em strWrite.
    xmlWriter.WriteStartElement('rss');       //informaoes do cabealho do rss
    xmlWriter.WriteAttributeString('version', '2.0');
    xmlWriter.WriteStartElement('channel');
    //informacoes do rss
    xmlWriter.WriteElementString('title', 'Artigos Adilson Jr TDS Tecnologia');
    xmlWriter.WriteElementString('link', 'http://www.tdstecnologia.com.br');
    xmlWriter.WriteElementString('description', 'Artigos publicados por instrutores certificados Borland.');
    //loop do dataset escrevendo os itens do rss.

    for dtaRow in Ds.Tables[0].Rows do
    begin
      xmlWriter.WriteStartElement('item');
      xmlWriter.WriteElementString('title', dtaRow['TITULO'].ToString());
      xmlWriter.WriteElementString('link', dtaRow['LINK'].ToString);
      xmlWriter.WriteElementString('description', dtaRow['DESCRICAO'].ToString());
      xmlWriter.WriteElementString('author', dtaRow['AUTOR'].ToString());
      xmlWriter.WriteElementString('pubDate', dtaRow['DATA'].ToString);
      xmlWriter.WriteEndElement();//fecha o elemento <item> xmlWriter.WriteStartElement('item');
    end;
    xmlWriter.WriteEndElement();//fecha o elemento <rss>  xmlWriter.WriteStartElement('rss');
    xmlWriter.WriteEndElement();//fecha o elemento <channel>  xmlWriter.WriteStartElement('channel');

    Context.Cache.Insert('RssFeed', strWriter.ToString, nil,
        DateTime.Now.AddHours(3), Cache.NoSlidingExpiration); //TimeSpan  o intervalo
    xmlWriter.Close(); //fecha o writer
  end;
  Context.Response.Write(Context.Cache['RssFeed'].ToString);
end;

end.
