unit UEntrada;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UCadastro, DB, ExtCtrls, DBCtrls, StdCtrls, Buttons, Mask,
  Grids, DBGrids;

type
  TFrmEntrada = class(TFrmCadastro)
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    EdtData: TDBEdit;
    EdtEmpresa: TDBEdit;
    Label8: TLabel;
    btnLocalizarEmpresa: TSpeedButton;
    DBGrid1: TDBGrid;
    dsItem_Entrada: TDataSource;
    Label3: TLabel;
    Bevel1: TBevel;
    Label4: TLabel;
    EdtCodBarras: TDBEdit;
    Label5: TLabel;
    EdtProduto: TDBEdit;
    Label6: TLabel;
    DBEdit5: TDBEdit;
    Label7: TLabel;
    DBEdit6: TDBEdit;
    btnLocalizarProduto: TSpeedButton;
    procedure btnNovoClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnLocalizarEmpresaClick(Sender: TObject);
    procedure btnLocalizarProdutoClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EdtCodBarrasKeyPress(Sender: TObject; var Key: Char);
    procedure btnLocalizarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmEntrada: TFrmEntrada;

implementation

uses UDMClient, UDMLocalizar, ULocalizarCDS, UDMServer;

{$R *.dfm}

procedure TFrmEntrada.btnNovoClick(Sender: TObject);
begin
  inherited;
  DBEdit1.SetFocus;
end;

procedure TFrmEntrada.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  FrmEntrada:= nil;
end;

procedure TFrmEntrada.btnLocalizarEmpresaClick(Sender: TObject);
begin
  inherited;
  try
    if TFrmLocalizarCDS.Execute('Localizar Empresa',
    dmLocalizar.cdsEmpresa,'CIDADE;ENDERECO;CNPJ','Cidade;Endereo;CNPJ') then
    begin
      DMClient.cdsEntrada.Edit;
      DMClient.cdsEntradaCOD_EMPRESA.AsInteger :=
        DMLocalizar.cdsEmpresaCOD_EMPRESA.AsInteger;
      {Exibe no campo DESC_EMPRESA o CNPJ + o Endereo + a Cidade da Empresa.
      Para permitir essa atribuio, a propriedade ReadOnly do campo DESC_EMPRESA,
      tanto no cdsEntrada quanto no dtsEntrada deve estar False.}
      DMClient.cdsEntradaDESC_EMPRESA.Text :=
        DMLocalizar.cdsEmpresaCNPJ.Text + ' - ' +
        DMLocalizar.cdsEmpresaENDERECO.Text + ' - ' +
        DMLocalizar.cdsEmpresaCIDADE.Text;
    end;
  finally
    dmLocalizar.cdsEmpresa.Close;
  end;
end;

procedure TFrmEntrada.btnLocalizarProdutoClick(Sender: TObject);
var sql: string;
begin
  try
    {Antes de chamar o form de localizao, armazena na varivel local
    sql, a instruo sql contida no cdsProduto do dmLocalizar, pois
    a sql dele ser alterada para mostrar somente os produtos
    da empresa selecionada no campo Empresa deste formulrio (FrmEmpresa). } 
    sql:= dmLocalizar.cdsProduto.CommandText;

    {Altera a sql do cdsProduto no dmLocalizar para trazer os mesmos
    campos que j estava trazendo, s que incluindo-se um where
    para mostrar os produtos da empresa escolhida neste form. }
    dmLocalizar.cdsProduto.CommandText:=
      ' select P.COD_PRODUTO, P.COD_BARRAS, P.DESCRICAO, P.ESTOQUE_ATUAL, ' +
      ' P.PRECO_VENDA, P.COD_EMPRESA, E.CIDADE, E.ENDERECO ' +
      ' from PRODUTO P inner join EMPRESA E ' +
      ' on P.COD_EMPRESA = E.COD_EMPRESA ' +
      ' where P.COD_EMPRESA = ' + DMClient.cdsEntradaCOD_EMPRESA.Text +
      ' order by P.DESCRICAO ';
    if TFrmLocalizarCDS.Execute('Localizar Produto',
    dmLocalizar.cdsProduto, 'DESCRICAO;COD_BARRAS',
    'Descrio;Cdigo Barras') then
    begin
      DMClient.cdsItem_Entrada.Edit;
      DMClient.cdsItem_EntradaCOD_PRODUTO.AsInteger :=
        DMLocalizar.cdsProdutoCOD_PRODUTO.AsInteger;
      DMClient.cdsItem_EntradaCOD_BARRAS.Text :=
        DMLocalizar.cdsProdutoCOD_BARRAS.Text;
      DMClient.cdsItem_EntradaDESC_PRODUTO.Text :=
        DMLocalizar.cdsProdutoDESCRICAO.Text;
    end;
  finally
    DMLocalizar.cdsProduto.close;
    {Retorna a sql original do cdsProduto no dmLocalizar.}
    dmLocalizar.cdsProduto.CommandText:= sql;
  end;
end;

procedure TFrmEntrada.btnSalvarClick(Sender: TObject);
begin
  inherited;
  {Verifica se o COD_ENTRADA  igual a zero, indicando
  que o registro  novo. Depois verifica se a quantidade
  de alteraes no cdsEntrada  igual a zero, indicando que
  as alteraes pendentes foram aplicadas no banco de dados
  com sucesso. }
  if (DMClient.cdsEntradaCOD_ENTRADA.AsInteger = 0)
  and (DMClient.cdsEntrada.ChangeCount = 0) then
  begin
      {Carrega o(s) novo(s) valor(es) para o(s) parmetro(s)
      do cdsEntrada. }
      DMClient.cdsEntrada.FetchParams;
      {Atualiza os dados para mostrar os novos cdigos gerados.}
      DMClient.cdsEntrada.Refresh;
  end;
end;

procedure TFrmEntrada.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  inherited;
  //Verifica se o usurio pressionou INSERT
  if Key = vk_insert then
  begin
     //Inclui um novo item no final da tabela
     dmClient.cdsItem_Entrada.Append;
     EdtCodBarras.SetFocus;
  end
  //Verifica se o usurio pressionou ESC
  else if Key = vk_escape then
     DMClient.cdsItem_Entrada.Cancel
  //Verifica se o usurio pressionou CTRL+DELETE
  else if (Key = vk_delete) and (Shift = [ssCtrl]) then
  begin
     if Application.MessageBox('Tem certeza que deseja excluir o item?',
     'Confirmao', MB_ICONQUESTION + MB_OKCANCEL + MB_DEFBUTTON2) = mrOK then
     begin
        DMClient.cdsItem_Entrada.Delete;
        {Edita a tabela Entrada para habilitar o boto Salvar e
        permitir que o usurio salve as alteraes. No DBExpress, uma
        excluso em um registro da tabela detalhe s  confirmada
        quando  feito o ApplyUpdates na tabela mestre. Assim,
        habilitando o boto salvar, o boto cancelar  habilitado
        automaticamente, permitindo que o usurio confirme a excluso
        ou desfaa a mesma.}
        DMClient.cdsEntrada.Edit;
     end;
  end;
end;

procedure TFrmEntrada.EdtCodBarrasKeyPress(Sender: TObject; var Key: Char);
var
  CodProduto: Integer;
  Descricao: String;
  PrecoVenda: Currency;
begin
  inherited;
  {Quando  feita a leitura de um cdigo de barras,  como
  se o usurio tivesse digitado os nmeros referentes ao cdigo
  e pressionado Enter. Assim, verifica-se
  se foi pressionado um Enter no campo Cd. Barras e
  faz-se a busca pelo produto}
  if key = #13 then
  begin
    {Se a funo retornar true,  porque localizou o produto.
    Os parmetros CodProduto e Descricao  so
    parmetros de referncia, assim, as variveis passadas
    tero seus valores alterados para os dados do produto localizado.}
    if DMServer.BuscaProduto(EdtCodBarras.Text,
    DMClient.cdsEntradaCOD_EMPRESA.AsInteger, CodProduto, Descricao, PrecoVenda) then
    begin
      {O preo de venda  retornado pela funo mas no  utilizado aqui na entrada,
      somente no form de venda.}
      DMClient.cdsItem_Entrada.Edit;
      DMClient.cdsItem_EntradaCOD_PRODUTO.AsInteger := CodProduto;
      DMClient.cdsItem_EntradaDESC_PRODUTO.Text := Descricao;
      //Selecionar o prximo campo
      SelectNext(ActiveControl, True, True);
      //Anular o pressionamento do Enter para evitar o beep que ele gera
      Key:= #0;
    end
    else
    begin
      Application.MessageBox(
       'Produto no cadastrado na empresa selecionada.', 'Informao', MB_ICONEXCLAMATION);
      //Selecionar todo o contedo do campo.
      EdtCodBarras.SelectAll;
    end;
  end;
end;

procedure TFrmEntrada.btnLocalizarClick(Sender: TObject);
begin
  inherited;
  try
    if TFrmLocalizarCDS.Execute('Localizar Entrada',
    dmLocalizar.cdsEntrada, 'ENT.NR_DOCUMENTO;ENT.DATA;EMP.CNPJ',
    'Nm. Documento;Data;CNPJ Empresa') then
    begin
      DMClient.cdsEntrada.Close;
      DMClient.cdsEntrada.Params[0].Text :=
        DMLocalizar.cdsEntradaCOD_ENTRADA.Text;
      DMClient.cdsEntrada.Open;
    end;
  finally
    DMLocalizar.cdsEntrada.close;
  end;
end;

end.
