unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, OleCtrls, SHDocVw, IdMessage, IdBaseComponent,
  IdComponent, IdTCPConnection, IdTCPClient, IdExplicitTLSClientServerBase,
  IdMessageClient, IdSMTPBase, IdSMTP, HTTPApp, HTTPProd;

const
  IniFileText: string = 'smtp.ini';

type
  TForm25 = class(TForm)
    edtPara: TEdit;
    edtCc: TEdit;
    edtAssunto: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    btnEnviar: TButton;
    IdSMTP1: TIdSMTP;
    IdMessage1: TIdMessage;
    StatusBar1: TStatusBar;
    mmoMensagem: TRichEdit;
    procedure FormCreate(Sender: TObject);
    procedure IdSMTP1Status(ASender: TObject; const AStatus: TIdStatus;
      const AStatusText: string);
    procedure btnEnviarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form25: TForm25;

implementation
     uses IniFiles;
{$R *.dfm}

procedure TForm25.btnEnviarClick(Sender: TObject);
begin
  try
    with IdMessage1, Recipients.Add do
    begin
      Address := edtPara.Text;
      Name    := edtPara.Text;
      Subject := edtAssunto.Text;
      Body.Add(mmoMensagem.Text);
      CCList.Add.Address := edtCc.Text;
    end;
    IdSMTP1.Connect;
    IdSMTP1.Send(IdMessage1);
  finally
    IdSMTP1.Disconnect;
  end;
end;

procedure TForm25.FormCreate(Sender: TObject);
var
  IniFile: TIniFile;
begin
  try
    IniFile := TIniFile.Create
        (ExtractFilePath(Application.ExeName) + IniFileText);
    with IdSMTP1, IdMessage1 do
    begin
      Host         := IniFile.ReadString('SMTP', 'Host', '');
      Username     := IniFile.ReadString('SMTP', 'Username', '');
      Password     := IniFile.ReadString('SMTP', 'Password', '');
      From.Name    := IniFile.ReadString('FROM', 'Name', '');
      From.Address := IniFile.ReadString('FROM', 'Address', '');
      AuthType := atDefault;
      StatusBar1.SimplePanel := True;
      StatusBar1.SimpleText :=
        Format('Host: %s, Username: %s, Password: %s', [Host, Username, Password])
    end;
  finally
    FreeAndNil(IniFile);
  end;
end;

procedure TForm25.IdSMTP1Status(ASender: TObject; const AStatus: TIdStatus;
  const AStatusText: string);
begin
  StatusBar1.SimpleText := AStatusText;
end;

end.
