unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, IdMessage, IdBaseComponent, IdComponent, IdTCPConnection,
  IdTCPClient, IdExplicitTLSClientServerBase, IdMessageClient, IdSMTPBase,
  IdSMTP, AppEvnts, StdCtrls;

const
  IniFileText: string = 'smtp.ini';

type
  TForm25 = class(TForm)
    ApplicationEvents1: TApplicationEvents;
    IdSMTP1: TIdSMTP;
    IdMessage1: TIdMessage;
    btnErro: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ApplicationEvents1Exception(Sender: TObject; E: Exception);
    procedure btnErroClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form25: TForm25;

implementation
  uses IniFiles, idAttachmentFile;

{$R *.dfm}

procedure TForm25.ApplicationEvents1Exception(Sender: TObject; E: Exception);
var
  Attach: TidAttachmentFile;
  BmpFile: string;
begin
  try
    IdMessage1.Body.Add(E.Message);
    BmpFile := TForm(Sender).Name + '.bmp';
    TForm(Sender).GetFormImage.SaveToFile(BmpFile);
    Attach := TIdAttachmentFile.Create
       (IdMessage1.MessageParts,ExtractFilePath(Application.ExeName)
            + BmpFile);
    IdSMTP1.Connect;
    IdSMTP1.Send(IdMessage1);
  finally
    IdSMTP1.Disconnect;
    DeleteFile(BmpFile);
  end;
  ShowMessage('Um erro ''catastrfico'' aconteceu.  Contate o administrador!');
end;

procedure TForm25.btnErroClick(Sender: TObject);
var
  a, b, c: integer;
begin
  //raise Exception.Create('Falha Catastrfica!') //poderia ser assim tb ;)
  a := 10;
  b := 0;
  c := a div b;
  ShowMessage(Format('O resultado : %d',[c]));
end;

procedure TForm25.FormCreate(Sender: TObject);
var
  IniFile: TIniFile;
begin
  try
    IniFile := TIniFile.Create
        (ExtractFilePath(Application.ExeName) + IniFileText);
    with IdSMTP1, IdMessage1 do
    begin
      Host         := IniFile.ReadString('SMTP', 'Host', '');
      Username     := IniFile.ReadString('SMTP', 'Username', '');
      Password     := IniFile.ReadString('SMTP', 'Password', '');
      From.Name    := IniFile.ReadString('FROM', 'Name', '');
      From.Address := IniFile.ReadString('FROM', 'Address', '');
      AuthType     := atDefault;
      with Recipients.Add do
      begin
        Address := IniFile.ReadString('EXCEPTION', 'To', '');
        Name    := IniFile.ReadString('EXCEPTION', 'Name', '');;
        Subject := IniFile.ReadString('EXCEPTION', 'Subject', '');
        CCList.Add.Address := IniFile.ReadString('EXCEPTION', 'Cc', '');
      end;
    end;
  finally
    FreeAndNil(IniFile);
  end;
end;

end.
