unit untAppUsaCDSPlus;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DBXpress, FMTBcd, DB, Provider, SqlExpr, DBClient,
  ClientDataSetPLUS, ExtCtrls, DBCtrls, Grids, DBGrids, StdCtrls, Mask,
  WideStrings, ComCtrls;

type
  TfrmAppUsaCDSPlus = class(TForm)
    cdspCustomer: TClientDataSetPLUS;
    conDBX: TSQLConnection;
    qryCustomer: TSQLQuery;
    dspCustomer: TDataSetProvider;
    dbnCustomer: TDBNavigator;
    dtsEmployee: TDataSource;
    pConfiguracao: TPanel;
    qryCustomerCUST_NO: TIntegerField;
    qryCustomerCUSTOMER: TStringField;
    qryCustomerCONTACT_FIRST: TStringField;
    qryCustomerCONTACT_LAST: TStringField;
    qryCustomerPHONE_NO: TStringField;
    qryCustomerADDRESS_LINE1: TStringField;
    qryCustomerADDRESS_LINE2: TStringField;
    qryCustomerCITY: TStringField;
    qryCustomerSTATE_PROVINCE: TStringField;
    qryCustomerCOUNTRY: TStringField;
    qryCustomerPOSTAL_CODE: TStringField;
    qryCustomerON_HOLD: TStringField;
    cdspCustomerCUST_NO: TIntegerField;
    cdspCustomerCUSTOMER: TStringField;
    cdspCustomerCONTACT_FIRST: TStringField;
    cdspCustomerCONTACT_LAST: TStringField;
    cdspCustomerPHONE_NO: TStringField;
    cdspCustomerADDRESS_LINE1: TStringField;
    cdspCustomerADDRESS_LINE2: TStringField;
    cdspCustomerCITY: TStringField;
    cdspCustomerSTATE_PROVINCE: TStringField;
    cdspCustomerCOUNTRY: TStringField;
    cdspCustomerPOSTAL_CODE: TStringField;
    cdspCustomerON_HOLD: TStringField;
    chk_bloquear_insercao: TCheckBox;
    chk_bloquear_alteracao: TCheckBox;
    chk_bloquear_exclusao: TCheckBox;
    chk_auditar: TCheckBox;
    pcPrincipal: TPageControl;
    ts_dados: TTabSheet;
    ts_auditoria: TTabSheet;
    DBGrid1: TDBGrid;
    m_auditoria: TMemo;
    procedure FormShow(Sender: TObject);
    procedure ChkCDSConfig( Sender : TObject );
    procedure ts_auditoriaShow(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmAppUsaCDSPlus: TfrmAppUsaCDSPlus;

implementation

{$R *.dfm}

procedure TfrmAppUsaCDSPlus.ChkCDSConfig( Sender : TObject );
begin
  //* Nenhum Bloqueio  configurado
  cdspCustomer.Bloquear := [];


  //* Verificando os bloqueios selecionados
  If chk_bloquear_insercao.Checked Then cdspCustomer.Bloquear := cdspCustomer.Bloquear + [bqInsercao];
  If chk_bloquear_alteracao.Checked Then cdspCustomer.Bloquear := cdspCustomer.Bloquear + [bqAlteracao];
  If chk_bloquear_exclusao.Checked Then cdspCustomer.Bloquear := cdspCustomer.Bloquear + [bqDelecao];

  //* Configurando auditoria (logs de alterao)
  cdspCustomer.Auditar := chk_auditar.Checked;
end;

procedure TfrmAppUsaCDSPlus.FormShow(Sender: TObject);
begin
  //* Ativando a conexo se inativa
  If Not conDBX.Connected Then conDBX.Open;

  //* Abrindo o ClientDataSetPLUS
  cdspCustomer.Open;

  //* Configurando o ClientDataSetPLUS
  ChkCDSConfig( Nil );
end;

procedure TfrmAppUsaCDSPlus.ts_auditoriaShow(Sender: TObject);
begin
  //* Recuperando os logs de alterao
  m_auditoria.Lines.Text := cdspCustomer.LogClientDataSet.Text;
end;

end.
