unit ClientDataSetPLUS;

interface

uses
  SysUtils, Classes, DB, DBClient, Variants;

//* Tipos de bloqueios
type TBloqueio = ( bqInsercao, bqDelecao, bqAlteracao );

//* Quais os bloqueios que esto sendo usados
type TBloqueios = Set of TBloqueio;

type
  TClientDataSetPLUS = class(TClientDataSet)
  private
    { Private declarations }

    //*  ApplyUpdates Automtico
    FAutoApplyUpdates: Boolean;

    //*  Se a auditoria est ativa
    FAuditar : Boolean;

    //*  Bloqueios em uso
    FBloquear : TBloqueios;

    stl_Log : TStringList;
    s_arquivo : String;

    //* Recupera as alteraes realizadas na tabela
    procedure GetLog;

    //* Grava as alteraes realizadas na tabela
    procedure SetLog( bl_excluindo : Boolean = False );


    function GetLogClientDataSet: TStringList;

  protected
    { Protected declarations }
    procedure DoBeforeDelete; Override;
    procedure DoBeforeInsert; Override;
    procedure DoBeforeEdit; Override;
    procedure DoBeforePost; Override;
    procedure DoAfterPost; Override;
    procedure DoAfterDelete; Override;

  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;

    property LogClientDataSet : TStringList read GetLogClientDataSet;

  published
    { Published declarations }
    property Auditar : Boolean read FAuditar write FAuditar;
    property Bloquear : TBloqueios read FBloquear write FBloquear;
    property AutoApplyUpdates : Boolean read FAutoApplyUpdates write FAutoApplyUpdates;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('Samples', [TClientDataSetPLUS]);
end;

{ TClientDataSetPLUS }

constructor TClientDataSetPLUS.Create(AOwner: TComponent);
begin
  inherited;
  //* Instanciando o objeto de lista de string "stl_log"
  stl_Log := TStringList.Create;

end;

procedure TClientDataSetPLUS.GetLog;
begin
  //* Montando o nome do arquivo
  s_arquivo := 'Log' + Self.Name + '.txt';

  //* Verificando se o arquivo existe
  If FileExists( s_arquivo ) Then
  Begin
    //* Carregando o arquivo no objeto de lista de string
    stl_Log.LoadFromFile( s_arquivo );
  End;
end;

procedure TClientDataSetPLUS.SetLog(bl_excluindo: Boolean);
  Var
    i : Integer;
begin

  //* Verificando se a auditoria est ativada
  If FAuditar Then
  Begin
    //* Recuperando o contudo do arquivo
    GetLog;

    //* Gravando o log
    stl_Log.Add( '________________________________________________________' );
    stl_Log.Add( '* ' + FormatDateTime( 'dd/mm/yyyy hh:nn:ss', Now ) );

    //* Verificando o estado do ClientDataSetPLUS
    If Self.State = dsInsert Then
    Begin
      //* Gravando LOG de insero
      stl_Log.Add( '  ' + 'REGISTRO INSERIDO' );

      For i := 0 To Self.Fields.Count-1 Do
      Begin
        stl_Log.Add( '  + ' + Fields[ i ].FieldName + ' = ' + Fields[ i ].AsString );
      End;
    End
    Else If bl_excluindo Then
    Begin
      //* Gravando LOG de excluso
      stl_Log.Add( '  ' + 'REGISTRO DELETADO' );
      For i := 0 To Self.Fields.Count-1 Do
      Begin
        stl_Log.Add( '  - ' + Fields[ i ].FieldName + ' = ' + Fields[ i ].AsString );
      End;
    End
    Else
    Begin
      //* Gravando LOG de alterao
      For i := 0 To Self.Fields.Count-1 Do
      Begin
        If (Self.Fields[ i ].FieldKind = fkData) Then
        Begin
          If (Self.Fields[ i ].NewValue <> Self.Fields[ i ].OldValue) Then
          Begin
            stl_Log.Add( '  ' + Self.Fields[ i ].FieldName + ' = ' + Self.Fields[ i ].AsString );
          End;
        End;
      End;

    End;

    //* Salvando o arquivo
    stl_Log.SaveToFile( s_arquivo );
  End;
end;


procedure TClientDataSetPLUS.DoAfterDelete;
begin
  inherited;
  If FAutoApplyUpdates Then ApplyUpdates(0);

end;

procedure TClientDataSetPLUS.DoAfterPost;
begin
  inherited;
  If FAutoApplyUpdates Then ApplyUpdates(0);

end;

procedure TClientDataSetPLUS.DoBeforeDelete;
begin
  //* Verificando o bloqueio de deleo
  If bqDelecao In FBloquear Then raise Exception.Create( 'No  permitido excluso.' );

  SetLog( True );
  inherited;

end;

procedure TClientDataSetPLUS.DoBeforeEdit;
begin
  //* Verificando o bloqueio de Altero
  If bqAlteracao In FBloquear Then raise Exception.Create( 'No  permitido alterao.' );

  inherited;

end;

procedure TClientDataSetPLUS.DoBeforeInsert;
begin
  //* Verificando o bloqueio de Insero
  If bqInsercao In FBloquear Then raise Exception.Create( 'No  permitido insero.' );

  inherited;

end;

procedure TClientDataSetPLUS.DoBeforePost;
begin
  SetLog;
  inherited;

end;

function TClientDataSetPLUS.GetLogClientDataSet: TStringList;
begin
  GetLog;
  Result := stl_Log;

end;

end.
