unit ufrmConsumidor;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, InvokeRegistry, Rio, SOAPHTTPClient;

type
  TfrmConsumidor = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    bbtFechar: TBitBtn;
    bbtfncDoubleValue: TBitBtn;
    bbtfncIntegerValue: TBitBtn;
    bbtfncStringValue: TBitBtn;
    Bevel1: TBevel;
    lbl_fncDoubleValue: TLabel;
    edtValor: TEdit;
    Label2: TLabel;
    lbl_fncIntegerValue: TLabel;
    lbl_fncStringValue: TLabel;
    HTTPRIO: THTTPRIO;
    procedure bbtFecharClick(Sender: TObject);
    procedure bbtfncDoubleValueClick(Sender: TObject);
    procedure bbtfncIntegerValueClick(Sender: TObject);
    procedure bbtfncStringValueClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmConsumidor: TfrmConsumidor;

implementation

uses uIwsPrimeiroWS;

{$R *.dfm}

procedure TfrmConsumidor.bbtFecharClick(Sender: TObject);
begin
   Application.Terminate;
end;

procedure TfrmConsumidor.bbtfncDoubleValueClick(Sender: TObject);
var
  ws: IwsPrimeiroWS;
begin
  try
    StrToFloat(edtValor.Text);
  except
    lbl_fncDoubleValue.Caption := 'Valor invlido!';
    Exit;
  end;

  try
    ws := (HTTPRIO as IwsPrimeiroWS);
    lbl_fncDoubleValue.Caption := FloatToStr(ws.fncDoubleValue(StrToFloat(edtValor.Text)));
  finally
     ws := nil;
  end;
end;

procedure TfrmConsumidor.bbtfncIntegerValueClick(Sender: TObject);
var
  ws: IwsPrimeiroWS;
begin
  try
    StrToInt(edtValor.Text);
  except
    lbl_fncIntegerValue.Caption := 'Valor invlido!';
    Exit;
  end;

  try
    ws := (HTTPRIO as IwsPrimeiroWS);
    lbl_fncIntegerValue.Caption := IntToStr(ws.fncIntegerValue(StrToInt(edtValor.Text)));
  finally
     ws := nil;
  end;
end;

procedure TfrmConsumidor.bbtfncStringValueClick(Sender: TObject);
var
  ws: IwsPrimeiroWS;
begin
  try
    ws := (HTTPRIO as IwsPrimeiroWS);
    lbl_fncStringValue.Caption := ws.fncStringValue(edtValor.Text);
  finally
     ws := nil;
  end;
end;

end.
