unit Borland.TDS.StreamBytes_Original;

interface

uses
  System.Web, System.Data, System.IO, Borland.Data.Provider, System.Text;

type
  TStreamType = (stImage, stText);

  TStreamBytes = class
  private
//    FAppPath    : string;
    FStreamType : TStreamType;
    FFieldId    : string;
    FFieldIdx   : integer;
    FReader     : BdpDataReader;
    FContext    : HttpContext;
    function getStartIndex(blobData : array of byte): Integer;
    function StartAt(bytes : array of byte; iStart : Integer; bytesize : Integer) : TBytes;
  protected
    property Reader     : BdpDataReader read FReader write FReader;
  public
//    property AppPath    : string        read FAppPath      write FAppPath;
    property FieldId    : string        read FFieldId      write FFieldId;
    property FieldIdx   : integer       read FFieldIdx     write FFieldIdx;
    property Context    : HttpContext   read FContext write FContext;

    constructor Create(StreamType : TStreamType); override;
    function GetBytes : string;
  end;

implementation

{ TStreamBytes }

constructor TStreamBytes.Create(StreamType : TStreamType);
begin
  inherited Create;
  FStreamType := StreamType;
end;

function TStreamBytes.getStartIndex(blobData : array of byte) : Integer;
const
  maxBytes = 12;
var
  s, s1, s2 : string;
begin
  Result := 0;

	s := Encoding.ASCII.GetString( blobData, 0, maxBytes);
  s1 := s.Substring(8, 1);
  s2 := s.Substring(9, 1);

	if( s1 = 'B' ) and ( s2 = 'M' ) then
    Result := 8;
end;

function TStreamBytes.StartAt(bytes : array of byte; iStart : Integer; bytesize : Integer) : TBytes;
var
  retBytes : array of byte;
  i : integer;
begin
  SetLength(retBytes, Length(Bytes) - iStart);

  for i := Low(retBytes) to High(retBytes) do
    retBytes[i] := bytes[i+iStart];

  if ( Length(retBytes) < (Length(bytes) - iStart) ) then
    Result := bytes
  else Result := retBytes;
end;

function TStreamBytes.GetBytes : string;
var
//  FS : FileStream; // Writes the BLOB to a file (*.bmp).
//  BW : BinaryWriter; // Streams the BLOB to the FileStream object.
  bufferSize : Integer;
  outbyte : array of Byte;
  outChar : array of Char;
  startIndex : Longint;
  BDP_CMD : BdpCommand;
  BDP_CON : BdpConnection;
begin
  // Reset the starting byte for the new BLOB.
  BDP_CMD := BdpCommand(Context.Application['Command']);
  BDP_CON := BDP_CMD.Connection;

  BDP_CON.Open;
  BDP_CMD.Parameters[0].Value := FieldId;
  Reader := BDP_CMD.ExecuteReader;
  Reader.Read;

  startIndex := 0;

  case FStreamType of
    stImage:
    begin
      bufferSize := Reader.GetBytes(FieldIdx, startIndex, nil, 0, 0);
      SetLength(outbyte, bufferSize);
      Reader.GetBytes(FieldIdx, startIndex, outbyte, 0, bufferSize);

      startIndex := getStartIndex(outbyte);

      if ( startIndex > 0 ) then
        outbyte := StartAt(outbyte, startIndex, bufferSize);

      Context.Response.BinaryWrite(outbyte);
      Reader.Close;
      BDP_CON.Close;
(*
SE FOR SALVA EM DISCO

      // Size of the BLOB buffer.;
      bufferSize := Reader.GetBytes(FieldIdx, 0, nil, 0, 0);
      //Get the publisher id, which must occur before getting the logo.
      Result := 'Temp\logo' + Reader[FieldId].ToString + '.bmp';
      // The BLOB byte[] buffer to be filled by GetBytes.
      SetLength(outbyte, bufferSize);
      //Create a file to hold the output.
      FS := FileStream.Create(AppPath + '\' + Result, FileMode.OpenOrCreate, FileAccess.Write);
      BW := BinaryWriter.Create(FS);

      // Read the bytes into outbyte[] and retain the number of bytes returned.
      Reader.GetBytes(FieldIdx, startIndex, outbyte, 0, bufferSize);
      // Write the remaining buffer.
      BW.Write(outbyte);

      // Write the remaining buffer.
      BW.Flush;
      // Close the output file.
      bw.Close;
      fs.Close;
*)
    end;

    stText :
    begin
      // Size of the BLOB buffer.;
      bufferSize := Reader.GetChars(FieldIdx, 0, nil, 0, 0);
      // The CHAR byte[] buffer to be filled by GetBytes.
      SetLength(outChar, bufferSize);
      // Read the bytes into outchar[] and retain the number of bytes returned.
      Reader.GetChars(FieldIdx, 0, outChar, 0, bufferSize);
      Result := outChar;

      Reader.Close;
      BDP_CON.Close;
    end;
  end;
end;

end.
