
unit Default;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls, 
  Borland.Data.Provider, System.Data.Common, System.Globalization, 
  Borland.Data.Web, Borland.Data.Common;

type
  TDefault = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
    procedure DBWEBGRD_EMPLOYEES_ItemDataBound(sender: System.Object; e: System.Web.UI.WebControls.DataGridItemEventArgs);
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    BDPCON_PUBS: Borland.Data.Provider.BdpConnection;
    bdpSelectCommand1: Borland.Data.Provider.BdpCommand;
    BDPDAP_PUBINFO: Borland.Data.Provider.BdpDataAdapter;
    DTS_PUBS: System.Data.DataSet;
    DataTable1: System.Data.DataTable;
    DataColumn1: System.Data.DataColumn;
    DataColumn2: System.Data.DataColumn;
    DataColumn3: System.Data.DataColumn;
    DTGRD_EMPLOYEES: System.Web.UI.WebControls.DataGrid;
    BDPCMD_BYTES: Borland.Data.Provider.BdpCommand;
    DataColumn4: System.Data.DataColumn;
    procedure OnInit(e: EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation

uses Borland.TDS.StreamBytes;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TDefault.InitializeComponent;
type
  TArrayOfSystem_Data_Common_DataTableMapping = array of System.Data.Common.DataTableMapping;
  TArrayOfSystem_Data_Common_DataColumnMapping = array of System.Data.Common.DataColumnMapping;
  TArrayOfSystem_Data_DataTable = array of System.Data.DataTable;
  TArrayOfSystem_Data_DataColumn = array of System.Data.DataColumn;
  TArrayOfSystem_Data_Constraint = array of System.Data.Constraint;
  TArrayOfString = array of string;
  TArrayOfByte = array of Byte;
  TArrayOfWideChar = array of WideChar;
begin
  Self.BDPCON_PUBS := Borland.Data.Provider.BdpConnection.Create;
  Self.bdpSelectCommand1 := Borland.Data.Provider.BdpCommand.Create;
  Self.BDPDAP_PUBINFO := Borland.Data.Provider.BdpDataAdapter.Create;
  Self.DTS_PUBS := System.Data.DataSet.Create;
  Self.DataTable1 := System.Data.DataTable.Create;
  Self.DataColumn1 := System.Data.DataColumn.Create;
  Self.DataColumn2 := System.Data.DataColumn.Create;
  Self.DataColumn3 := System.Data.DataColumn.Create;
  Self.DataColumn4 := System.Data.DataColumn.Create;
  Self.BDPCMD_BYTES := Borland.Data.Provider.BdpCommand.Create;
  (System.ComponentModel.ISupportInitialize(Self.BDPDAP_PUBINFO)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DTS_PUBS)).BeginInit;
  (System.ComponentModel.ISupportInitialize(Self.DataTable1)).BeginInit;
  Include(Self.DTGRD_EMPLOYEES.ItemDataBound, Self.DBWEBGRD_EMPLOYEES_ItemDataBound);
  // 
  // BDPCON_PUBS
  // 
  Self.BDPCON_PUBS.ConnectionOptions := 'transaction isolation=ReadCommitted' +
  ';blobsize=1024';
  Self.BDPCON_PUBS.ConnectionString := 'assembly=Borland.Data.Mssql, Version' +
  '=2.5.0.0, Culture=neutral, PublicKeyToken=91d62ebb5b0d1b1b;vendorclient=s' +
  'qloledb.dll;pooling=True;grow on demand=True;database=PUBS;username=sa;ma' +
  'x pool size=100;password=newcom;provider=MSSQL;hostname=localhost';
  // 
  // bdpSelectCommand1
  // 
  Self.bdpSelectCommand1.CommandOptions := nil;
  Self.bdpSelectCommand1.CommandText := 'SELECT P1.pub_id, P1.pub_name, P2.l' +
  'ogo, P2.pr_info FROM dbo.publishers P1, dbo.pub_info P2'#13#10'WHERE P1.p' +
  'ub_id=P2.pub_id';
  Self.bdpSelectCommand1.CommandType := System.Data.CommandType.Text;
  Self.bdpSelectCommand1.Connection := Self.BDPCON_PUBS;
  Self.bdpSelectCommand1.ParameterCount := (SmallInt(0));
  Self.bdpSelectCommand1.SchemaName := nil;
  Self.bdpSelectCommand1.Transaction := nil;
  Self.bdpSelectCommand1.UpdatedRowSource := System.Data.UpdateRowSource.None;
  // 
  // BDPDAP_PUBINFO
  // 
  Self.BDPDAP_PUBINFO.Active := True;
  Self.BDPDAP_PUBINFO.DataSet := Self.DTS_PUBS;
  Self.BDPDAP_PUBINFO.DataTable := Self.DataTable1;
  Self.BDPDAP_PUBINFO.SelectCommand := Self.bdpSelectCommand1;
  Self.BDPDAP_PUBINFO.StartRecord := 0;
  Self.BDPDAP_PUBINFO.TableMappings.AddRange(TArrayOfSystem_Data_Common_DataTableMapping.Create(System.Data.Common.DataTableMapping.Create('T' +
          'able', 'publishers', TArrayOfSystem_Data_Common_DataColumnMapping.Create(System.Data.Common.DataColumnMapping.Create('p' +
                'ub_id', 'pub_id'), System.Data.Common.DataColumnMapping.Create('p' +
                'ub_name', 'pub_name')))));
  // 
  // DTS_PUBS
  // 
  Self.DTS_PUBS.DataSetName := 'DTS_NORTHWIND';
  Self.DTS_PUBS.Locale := System.Globalization.CultureInfo.Create('pt-BR');
  Self.DTS_PUBS.Tables.AddRange(TArrayOfSystem_Data_DataTable.Create(Self.DataTable1));
  // 
  // DataTable1
  // 
  Self.DataTable1.Columns.AddRange(TArrayOfSystem_Data_DataColumn.Create(Self.DataColumn1, 
          Self.DataColumn2, Self.DataColumn3, Self.DataColumn4));
  Self.DataTable1.Constraints.AddRange(TArrayOfSystem_Data_Constraint.Create(System.Data.UniqueConstraint.Create('C' +
          'onstraint1', TArrayOfString.Create('pub_id'), True)));
  Self.DataTable1.PrimaryKey := TArrayOfSystem_Data_DataColumn.Create(Self.DataColumn1);
  Self.DataTable1.TableName := 'publishers';
  // 
  // DataColumn1
  // 
  Self.DataColumn1.AllowDBNull := False;
  Self.DataColumn1.ColumnName := 'pub_id';
  Self.DataColumn1.MaxLength := 4;
  // 
  // DataColumn2
  // 
  Self.DataColumn2.ColumnName := 'pub_name';
  Self.DataColumn2.MaxLength := 40;
  // 
  // DataColumn3
  // 
  Self.DataColumn3.ColumnName := 'logo';
  Self.DataColumn3.DataType := TypeOf(TArrayOfByte);
  // 
  // DataColumn4
  // 
  Self.DataColumn4.ColumnName := 'pr_info';
  Self.DataColumn4.DataType := TypeOf(TArrayOfWideChar);
  // 
  // BDPCMD_BYTES
  // 
  Self.BDPCMD_BYTES.CommandOptions := nil;
  Self.BDPCMD_BYTES.CommandText := 'SELECT P1.pub_id, P1.pub_name, P2.logo, ' +
  'P2.pr_info FROM dbo.publishers P1, dbo.pub_info P2'#13#10'WHERE P1.pub_id' +
  '=P2.pub_id and P1.pub_id=?';
  Self.BDPCMD_BYTES.CommandType := System.Data.CommandType.Text;
  Self.BDPCMD_BYTES.Connection := Self.BDPCON_PUBS;
  Self.BDPCMD_BYTES.ParameterCount := (SmallInt(1));
  Self.BDPCMD_BYTES.Parameters.Add(Borland.Data.Common.BdpParameter.Create('p' +
      'ub_id', Borland.Data.Common.BdpType.Int32, Borland.Data.Common.BdpType.Unknown, 
        0, System.Data.ParameterDirection.Input, False, (Byte(0)), (Byte(0)), 
        0, '', System.Data.DataRowVersion.Current, nil));
  Self.BDPCMD_BYTES.SchemaName := nil;
  Self.BDPCMD_BYTES.Transaction := nil;
  Self.BDPCMD_BYTES.UpdatedRowSource := System.Data.UpdateRowSource.None;
  Include(Self.Load, Self.Page_Load);
  (System.ComponentModel.ISupportInitialize(Self.BDPDAP_PUBINFO)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DTS_PUBS)).EndInit;
  (System.ComponentModel.ISupportInitialize(Self.DataTable1)).EndInit;
end;
{$ENDREGION}

procedure TDefault.Page_Load(sender: System.Object; e: System.EventArgs);
begin
  // TODO: Put user code to initialize the page here
  if not Page.IsPostBack then
    DataBind;
end;

procedure TDefault.OnInit(e: EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

procedure TDefault.DBWEBGRD_EMPLOYEES_ItemDataBound(sender: System.Object;
                            e: System.Web.UI.WebControls.DataGridItemEventArgs);
var
  img_photo : Image;
  txtbx_notes : TextBox;
  TxtByte : TStreamBytes;
begin
  if ( ( e.Item.ItemType = ListItemType.Item ) or
       ( e.Item.ItemType = ListItemType.AlternatingItem ) or
       ( e.Item.ItemType = ListItemType.SelectedItem ) ) then
  begin
    txtbx_notes := TextBox(e.Item.FindControl('txtbx_notes'));
    img_photo := Image(e.Item.FindControl('img_photo'));

    Application['Command'] := BDPCMD_BYTES;
    img_photo.Attributes['src'] :=
               System.String.Format('WFGetImages.aspx?FieldId={0}&FieldIdx={1}',
                                    [e.Item.Cells[0].Text, 2]);


    TxtByte := TStreamBytes.Create(stText);
    TxtByte.FieldIdx := 3;
    TxtByte.FieldId  := e.Item.Cells[0].Text;
    txtbx_notes.Text := TxtByte.GetBytes;
    TxtByte.Free;
  end;
end;

end.

