unit WinForm;

interface

uses
  Db4objects.Db4o,
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, UPessoa;

type


  TWinForm = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
    txNome: System.Windows.Forms.TextBox;
    txLogradouro: System.Windows.Forms.TextBox;
    txNumero: System.Windows.Forms.TextBox;
    txBairro: System.Windows.Forms.TextBox;
    txCidade: System.Windows.Forms.TextBox;
    btArmazenar: System.Windows.Forms.Button;
    Label1: System.Windows.Forms.Label;
    Label2: System.Windows.Forms.Label;
    Label3: System.Windows.Forms.Label;
    Label4: System.Windows.Forms.Label;
    Label5: System.Windows.Forms.Label;
    btextudo: System.Windows.Forms.Button;
    DataGrid1: System.Windows.Forms.DataGrid;
    DataGridTableStyle1: System.Windows.Forms.DataGridTableStyle;
    clNome: System.Windows.Forms.DataGridTextBoxColumn;
    txPesquisa: System.Windows.Forms.TextBox;
    cbSelecao: System.Windows.Forms.ComboBox;
    btPesquisar: System.Windows.Forms.Button;
    btAtualizar: System.Windows.Forms.Button;
    btExcluir: System.Windows.Forms.Button;
    Panel1: System.Windows.Forms.Panel;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
    procedure TWinForm_Load(sender: System.Object; e: System.EventArgs);
    procedure Button1_Click(sender: System.Object; e: System.EventArgs);
    procedure TWinForm_Closing(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
    procedure Button2_Click(sender: System.Object; e: System.EventArgs);
    procedure Button3_Click(sender: System.Object; e: System.EventArgs);
    procedure DataGrid1_CurrentCellChanged(sender: System.Object; e: System.EventArgs);
    procedure btAtualizar_Click(sender: System.Object; e: System.EventArgs);
    procedure btExcluir_Click(sender: System.Object; e: System.EventArgs);
    procedure DataGrid1_DataSourceChanged(sender: System.Object; e: System.EventArgs);

  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    procedure Dispose(Disposing: Boolean); override;
  private
    { Private Declarations }
    procedure getPessoa(persona :Pessoa);
    procedure setPessoa(persona :Pessoa);
    procedure UnsetPessoa(persona :Pessoa);
    procedure atualiza;
  public
    db : IObjectContainer;
    result : IobjectSet;
    person : Pessoa;

    constructor Create;overload;

  end;

  [assembly: RuntimeRequiredAttribute(TypeOf(TWinForm))]

implementation

uses
  System.Text;

{$AUTOBOX ON}

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinForm.InitializeComponent;
type
  TArrayOfSystem_Windows_Forms_DataGridTableStyle = array of System.Windows.Forms.DataGridTableStyle;
  TArrayOfSystem_Windows_Forms_DataGridColumnStyle = array of System.Windows.Forms.DataGridColumnStyle;
  TArrayOfSystem_Object = array of System.Object;
begin
  Self.txNome := System.Windows.Forms.TextBox.Create;
  Self.txLogradouro := System.Windows.Forms.TextBox.Create;
  Self.txNumero := System.Windows.Forms.TextBox.Create;
  Self.txBairro := System.Windows.Forms.TextBox.Create;
  Self.txCidade := System.Windows.Forms.TextBox.Create;
  Self.btArmazenar := System.Windows.Forms.Button.Create;
  Self.Label1 := System.Windows.Forms.Label.Create;
  Self.Label2 := System.Windows.Forms.Label.Create;
  Self.Label3 := System.Windows.Forms.Label.Create;
  Self.Label4 := System.Windows.Forms.Label.Create;
  Self.Label5 := System.Windows.Forms.Label.Create;
  Self.btextudo := System.Windows.Forms.Button.Create;
  Self.DataGrid1 := System.Windows.Forms.DataGrid.Create;
  Self.DataGridTableStyle1 := System.Windows.Forms.DataGridTableStyle.Create;
  Self.clNome := System.Windows.Forms.DataGridTextBoxColumn.Create;
  Self.txPesquisa := System.Windows.Forms.TextBox.Create;
  Self.cbSelecao := System.Windows.Forms.ComboBox.Create;
  Self.btPesquisar := System.Windows.Forms.Button.Create;
  Self.btAtualizar := System.Windows.Forms.Button.Create;
  Self.btExcluir := System.Windows.Forms.Button.Create;
  Self.Panel1 := System.Windows.Forms.Panel.Create;
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).BeginInit;
  Self.Panel1.SuspendLayout;
  Self.SuspendLayout;
  // 
  // txNome
  // 
  Self.txNome.Location := System.Drawing.Point.Create(8, 29);
  Self.txNome.Name := 'txNome';
  Self.txNome.Size := System.Drawing.Size.Create(472, 20);
  Self.txNome.TabIndex := 0;
  Self.txNome.Text := '';
  // 
  // txLogradouro
  // 
  Self.txLogradouro.Location := System.Drawing.Point.Create(8, 72);
  Self.txLogradouro.Name := 'txLogradouro';
  Self.txLogradouro.Size := System.Drawing.Size.Create(216, 20);
  Self.txLogradouro.TabIndex := 1;
  Self.txLogradouro.Text := '';
  // 
  // txNumero
  // 
  Self.txNumero.Location := System.Drawing.Point.Create(232, 72);
  Self.txNumero.Name := 'txNumero';
  Self.txNumero.Size := System.Drawing.Size.Create(40, 20);
  Self.txNumero.TabIndex := 2;
  Self.txNumero.Text := '';
  // 
  // txBairro
  // 
  Self.txBairro.Location := System.Drawing.Point.Create(280, 72);
  Self.txBairro.Name := 'txBairro';
  Self.txBairro.Size := System.Drawing.Size.Create(200, 20);
  Self.txBairro.TabIndex := 3;
  Self.txBairro.Text := '';
  // 
  // txCidade
  // 
  Self.txCidade.Location := System.Drawing.Point.Create(8, 120);
  Self.txCidade.Name := 'txCidade';
  Self.txCidade.Size := System.Drawing.Size.Create(216, 20);
  Self.txCidade.TabIndex := 4;
  Self.txCidade.Text := '';
  // 
  // btArmazenar
  // 
  Self.btArmazenar.AccessibleDescription := 'btArmazenar';
  Self.btArmazenar.Location := System.Drawing.Point.Create(240, 120);
  Self.btArmazenar.Name := 'btArmazenar';
  Self.btArmazenar.Size := System.Drawing.Size.Create(72, 23);
  Self.btArmazenar.TabIndex := 5;
  Self.btArmazenar.Text := 'Armazenar';
  Include(Self.btArmazenar.Click, Self.Button1_Click);
  // 
  // Label1
  // 
  Self.Label1.Location := System.Drawing.Point.Create(9, 7);
  Self.Label1.Name := 'Label1';
  Self.Label1.Size := System.Drawing.Size.Create(100, 16);
  Self.Label1.TabIndex := 6;
  Self.Label1.Text := 'Nome';
  // 
  // Label2
  // 
  Self.Label2.Location := System.Drawing.Point.Create(8, 52);
  Self.Label2.Name := 'Label2';
  Self.Label2.Size := System.Drawing.Size.Create(100, 16);
  Self.Label2.TabIndex := 7;
  Self.Label2.Text := 'Logradouro';
  // 
  // Label3
  // 
  Self.Label3.Location := System.Drawing.Point.Create(232, 56);
  Self.Label3.Name := 'Label3';
  Self.Label3.Size := System.Drawing.Size.Create(100, 16);
  Self.Label3.TabIndex := 8;
  Self.Label3.Text := 'Nmero';
  // 
  // Label4
  // 
  Self.Label4.Location := System.Drawing.Point.Create(280, 56);
  Self.Label4.Name := 'Label4';
  Self.Label4.Size := System.Drawing.Size.Create(100, 16);
  Self.Label4.TabIndex := 9;
  Self.Label4.Text := 'Bairro';
  // 
  // Label5
  // 
  Self.Label5.Location := System.Drawing.Point.Create(8, 96);
  Self.Label5.Name := 'Label5';
  Self.Label5.Size := System.Drawing.Size.Create(100, 16);
  Self.Label5.TabIndex := 10;
  Self.Label5.Text := 'Cidade';
  // 
  // btextudo
  // 
  Self.btextudo.Location := System.Drawing.Point.Create(344, 264);
  Self.btextudo.Name := 'btextudo';
  Self.btextudo.Size := System.Drawing.Size.Create(112, 23);
  Self.btextudo.TabIndex := 12;
  Self.btextudo.Text := 'Exibir Todos';
  Include(Self.btextudo.Click, Self.Button2_Click);
  // 
  // DataGrid1
  // 
  Self.DataGrid1.DataMember := '';
  Self.DataGrid1.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.DataGrid1.Location := System.Drawing.Point.Create(16, 56);
  Self.DataGrid1.Name := 'DataGrid1';
  Self.DataGrid1.Size := System.Drawing.Size.Create(440, 200);
  Self.DataGrid1.TabIndex := 14;
  Self.DataGrid1.TableStyles.AddRange(TArrayOfSystem_Windows_Forms_DataGridTableStyle.Create(Self.DataGridTableStyle1));
  Include(Self.DataGrid1.DataSourceChanged, Self.DataGrid1_DataSourceChanged);
  Include(Self.DataGrid1.CurrentCellChanged, Self.DataGrid1_CurrentCellChanged);
  // 
  // DataGridTableStyle1
  // 
  Self.DataGridTableStyle1.DataGrid := Self.DataGrid1;
  Self.DataGridTableStyle1.GridColumnStyles.AddRange(TArrayOfSystem_Windows_Forms_DataGridColumnStyle.Create(Self.clNome));
  Self.DataGridTableStyle1.HeaderForeColor := System.Drawing.SystemColors.ControlText;
  Self.DataGridTableStyle1.MappingName := '';
  // 
  // clNome
  // 
  Self.clNome.Format := '';
  Self.clNome.FormatInfo := nil;
  Self.clNome.MappingName := 'nome';
  Self.clNome.Width := 75;
  // 
  // txPesquisa
  // 
  Self.txPesquisa.Location := System.Drawing.Point.Create(16, 24);
  Self.txPesquisa.Name := 'txPesquisa';
  Self.txPesquisa.Size := System.Drawing.Size.Create(208, 20);
  Self.txPesquisa.TabIndex := 15;
  Self.txPesquisa.Text := '';
  // 
  // cbSelecao
  // 
  Self.cbSelecao.Items.AddRange(TArrayOfSystem_Object.Create('Nome', 'Lograd' +
        'ouro', 'Bairro', 'Cidade'));
  Self.cbSelecao.Location := System.Drawing.Point.Create(232, 24);
  Self.cbSelecao.Name := 'cbSelecao';
  Self.cbSelecao.Size := System.Drawing.Size.Create(121, 21);
  Self.cbSelecao.TabIndex := 16;
  Self.cbSelecao.Text := 'ComboBox1';
  // 
  // btPesquisar
  // 
  Self.btPesquisar.Location := System.Drawing.Point.Create(360, 24);
  Self.btPesquisar.Name := 'btPesquisar';
  Self.btPesquisar.TabIndex := 17;
  Self.btPesquisar.Text := 'Pesquisar';
  Include(Self.btPesquisar.Click, Self.Button3_Click);
  // 
  // btAtualizar
  // 
  Self.btAtualizar.Location := System.Drawing.Point.Create(320, 120);
  Self.btAtualizar.Name := 'btAtualizar';
  Self.btAtualizar.Size := System.Drawing.Size.Create(72, 23);
  Self.btAtualizar.TabIndex := 18;
  Self.btAtualizar.Text := 'Atualizar';
  Include(Self.btAtualizar.Click, Self.btAtualizar_Click);
  // 
  // btExcluir
  // 
  Self.btExcluir.Location := System.Drawing.Point.Create(408, 120);
  Self.btExcluir.Name := 'btExcluir';
  Self.btExcluir.Size := System.Drawing.Size.Create(72, 23);
  Self.btExcluir.TabIndex := 19;
  Self.btExcluir.Text := 'Excluir';
  Include(Self.btExcluir.Click, Self.btExcluir_Click);
  // 
  // Panel1
  // 
  Self.Panel1.BackColor := System.Drawing.Color.White;
  Self.Panel1.Controls.Add(Self.DataGrid1);
  Self.Panel1.Controls.Add(Self.txPesquisa);
  Self.Panel1.Controls.Add(Self.cbSelecao);
  Self.Panel1.Controls.Add(Self.btPesquisar);
  Self.Panel1.Controls.Add(Self.btextudo);
  Self.Panel1.Location := System.Drawing.Point.Create(8, 152);
  Self.Panel1.Name := 'Panel1';
  Self.Panel1.Size := System.Drawing.Size.Create(480, 296);
  Self.Panel1.TabIndex := 20;
  // 
  // TWinForm
  // 
  Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
  Self.ClientSize := System.Drawing.Size.Create(496, 458);
  Self.Controls.Add(Self.Panel1);
  Self.Controls.Add(Self.btExcluir);
  Self.Controls.Add(Self.btAtualizar);
  Self.Controls.Add(Self.txCidade);
  Self.Controls.Add(Self.txBairro);
  Self.Controls.Add(Self.txNumero);
  Self.Controls.Add(Self.txLogradouro);
  Self.Controls.Add(Self.txNome);
  Self.Controls.Add(Self.Label5);
  Self.Controls.Add(Self.Label4);
  Self.Controls.Add(Self.Label3);
  Self.Controls.Add(Self.Label2);
  Self.Controls.Add(Self.Label1);
  Self.Controls.Add(Self.btArmazenar);
  Self.Name := 'TWinForm';
  Self.Text := 'Delphi e DB4O';
  Include(Self.Closing, Self.TWinForm_Closing);
  Include(Self.Load, Self.TWinForm_Load);
  (System.ComponentModel.ISupportInitialize(Self.DataGrid1)).EndInit;
  Self.Panel1.ResumeLayout(False);
  Self.ResumeLayout(False);
end;

{$ENDREGION}


procedure TWinForm.setPessoa(persona: Pessoa);
begin
 persona.nome:=           txNome.Text;
 persona.logradouro:=     txLogradouro.Text;
 persona.bairro:=         txBairro.Text;
 persona.cidade:=         txCidade.Text;
 persona.numero:=         Int32.Parse(txNumero.Text);
 db.&Set(persona);
end;

procedure TWinForm.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinForm.Create;
begin
  inherited Create;

  InitializeComponent;
  Self.CenterToScreen;

end;


procedure TWinForm.DataGrid1_DataSourceChanged(sender: System.Object; e: System.EventArgs);
begin
   //pnlChamados.Visible:=(DataGrid1.DataMember = 'chamados');
end;

procedure TWinForm.btExcluir_Click(sender: System.Object; e: System.EventArgs);
begin
  if MessageBox.Show('Tem certeza que deseja excluir esta pessoa?',
  'Cadastro de Pessoas',MessageBoxButtons.OKCancel,MessageBoxIcon.Question)
  = System.Windows.Forms.DialogResult.Ok then
  begin
    UnsetPessoa(person);
    atualiza;
  end;

end;

procedure TWinForm.atualiza;
begin
  result :=db.Get(typeof(Pessoa));
  if Assigned(result) then
  begin
    DataGrid1.SetDataBinding(Pessoas(result),nil);
    person := Pessoa(result[0]);
    getPessoa(person);
  end;
end;

procedure TWinForm.btAtualizar_Click(sender: System.Object; e: System.EventArgs);
begin
  if MessageBox.Show('Tem certeza que deseja atualizar os dados desta pessoa?',
  'Cadastro de Pessoas',MessageBoxButtons.OKCancel,MessageBoxIcon.Question)
  = System.Windows.Forms.DialogResult.Ok then
  begin
    setPessoa(person);
  end;

end;

procedure TWinForm.DataGrid1_CurrentCellChanged(sender: System.Object; e: System.EventArgs);
var cell : DataGridCell;
begin
    cell:=DataGrid1.CurrentCell;
    if DataGrid1.Datamember='' then
    begin
      person := Pessoa(result.Item[cell.RowNumber]);
      getPessoa(person);
    end;
end;

procedure TWinForm.getPessoa(persona: Pessoa);
begin
  if Assigned(persona) then
  begin
    txNome.Text       :=persona.nome;
    txLogradouro.Text :=persona.logradouro;
    txBairro.Text     :=persona.bairro;
    txCidade.Text     :=persona.cidade;
    txNumero.Text     :=persona.numero.ToString;
  end;
end;

procedure TWinForm.Button3_Click(sender: System.Object; e: System.EventArgs);
var ps :Pessoa;
begin
  case cbSelecao.SelectedIndex of
    0:ps:= Pessoa.Create(txPesquisa.Text,nil,nil,nil,0);
    1:ps:= Pessoa.Create(nil,txPesquisa.Text,nil,nil,0);
    2:ps:= Pessoa.Create(nil,nil,txPesquisa.Text,nil,0);
    3:ps:= Pessoa.Create(nil,nil,nil,txPesquisa.Text,0);
    else ps:= Pessoa.Create(nil,nil,nil,nil,0);
  end;
  result :=db.Get(ps);
  DataGrid1.DataSource:=result;
end;

procedure TWinForm.Button2_Click(sender: System.Object; e: System.EventArgs);
begin
   atualiza;


end;

procedure TWinForm.TWinForm_Closing(sender: System.Object; e: System.ComponentModel.CancelEventArgs);
begin
  db.Close;
end;

procedure TWinForm.Button1_Click(sender: System.Object; e: System.EventArgs);
var ps :Pessoa;
begin
  ps := Pessoa.Create(txNome.Text,
                      txLogradouro.Text,
                      txBairro.Text,
                      txCidade.Text,
                      Int32.Parse(txNumero.Text));
  db.&Set(ps);
  atualiza;
end;

procedure TWinForm.TWinForm_Load(sender: System.Object; e: System.EventArgs);
begin
   db := Db4oFactory.OpenFile('dados.dbo');
   Self.CenterToScreen;
   Self.cbSelecao.SelectedIndex:=0;
   atualiza;
end;

procedure TWinForm.UnsetPessoa(persona: Pessoa);
begin
  db.Delete(persona);
end;

end.
