unit UAlterarSenha;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, DB;

type
  TFrmAlterarSenha = class(TForm)
    Label2: TLabel;
    EdtNovaSenha: TEdit;
    Label1: TLabel;
    EdtConfirmacao: TEdit;
    btnOK: TBitBtn;
    btnCancelar: TBitBtn;
    Label3: TLabel;
    EdtLogin: TEdit;
    Label4: TLabel;
    EdtSenha: TEdit;
    procedure btnOKClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure EdtLoginChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    class function Execute(Login, Senha: ShortString): boolean;
  end;

var
  FrmAlterarSenha: TFrmAlterarSenha;

implementation

uses ULogin, UDMServer, Usuario;

{$R *.dfm}

procedure TFrmAlterarSenha.btnOKClick(Sender: TObject);
begin
  if (trim(EdtLogin.Text) = '') then
  begin
     EdtLogin.SetFocus;
     raise exception.create('Informe o Login.');
  end;

  if (trim(EdtSenha.Text) = '') then
  begin
     EdtSenha.SetFocus;
     raise exception.create('Informe a Senha.');
  end;

  {Busca o usurio pelo login e senha informado, retornando
  os dados do usurio logado.}
  if not DMServer.BuscaUsuario(EdtLogin.Text, EdtSenha.Text, User) then
     raise exception.create('Login ou Senha invlida.');
      
  if EdtSenha.Text = EdtNovaSenha.Text then
  begin
     EdtNovaSenha.SetFocus;
     raise exception.create('A "Nova Senha" deve ser diferente da "Senha Atual".');
  end;
  if (EdtNovaSenha.text <> EdtConfirmacao.text) then
  begin
    EdtConfirmacao.SetFocus;
    raise exception.create('A "Confirmao da Nova Senha" ' +
     'no confere com a "Nova Senha".');
  end;

  if DMServer.AlterarSenha(EdtLogin.Text, EdtNovaSenha.Text) then
  begin
    FrmLogin.EdtLogin.clear;
    FrmLogin.EdtSenha.clear;
    FrmLogin.EdtLogin.SetFocus;
    Application.MessageBox(pchar('A senha foi alterada com sucesso. ' +
     'Para entrar no sistema informe seu Login e sua Nova Senha.'),
     'Informao',mb_iconInformation);

    {Se chegar at aqui, fecha o form
    alterando a propriedade ModalResult para mrOK,
    indicando que o form foi fechado clicando no boto OK.
    Aqui foi feito de forma diferente que no FrmLogin,
    onde o boto OK j tinha sua propriedade ModalResult
    alterada para mrOK. Aqui no, o boto
    OK tem a propriedade ModalResult igual a mrNone,
    assim, clicando nele no fecha automaticamente
    o form, somente se todas as verificaes
    forem feitas, e o cdigo chegar at aqui,
    ento altera o ModalResult do Form para mrOK,
    fechando este, indicando que foi por meio do boto OK.
    Com isto, no precisa-se em todas as verificaes
    fazer ModalResult:= mrNone para impedir que o form
    seja fechado caso a condio no seja satisfeita.
    Coloca-se apenas um ModalResult:= mrOK no final,
    diminuindo a quantidade de linhas de cdigo.}
    ModalResult:= mrOK;
  end
  else
    Application.MessageBox(pchar('A senha no foi alterada. ' +
     'Tente novamente ou contato o suporte.'),
     'Informao',mb_iconInformation);
end;

procedure TFrmAlterarSenha.FormShow(Sender: TObject);
begin
  if EdtLogin.Text = '' then
     EdtLogin.SetFocus
  else if EdtSenha.Text = '' then
     EdtSenha.SetFocus
  else EdtNovaSenha.SetFocus;
end;

procedure TFrmAlterarSenha.EdtLoginChange(Sender: TObject);
begin
  btnOK.Enabled:=
     (EdtLogin.Text <> '') and (EdtSenha.Text <> '') and
     (EdtNovasenha.Text <> '') and (EdtConfirmacao.Text <> '');
end;

class function TFrmAlterarSenha.Execute(Login, Senha: ShortString): boolean;
begin
  FrmAlterarSenha:= TFrmAlterarSenha.Create(Application);
  try
     FrmAlterarSenha.EdtLogin.Text:= Login;
     FrmAlterarSenha.EdtSenha.Text:= Senha;
     result:= (FrmAlterarSenha.ShowModal=mrOK);
  finally
     FrmAlterarSenha.Free;
  end;
end;

end.
