unit UEmpresa;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UCadastro, DB, ExtCtrls, DBCtrls, StdCtrls, Buttons, Mask;

type
  TFrmEmpresa = class(TFrmCadastro)
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBEdit3: TDBEdit;
    Label4: TLabel;
    DBEdit4: TDBEdit;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnNovoClick(Sender: TObject);
    procedure btnLocalizarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmEmpresa: TFrmEmpresa;

implementation

uses UDMClient, UDMLocalizar, ULocalizarCDS;

{$R *.dfm}

procedure TFrmEmpresa.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  FrmEmpresa:= nil;
end;

procedure TFrmEmpresa.btnSalvarClick(Sender: TObject);
begin
  if DataSource1.State = dsInsert then
     DMClient.cdsEmpresa.Params[0].Text:= DMClient.cdsEmpresaCNPJ.Text;
  inherited;
end;

procedure TFrmEmpresa.btnNovoClick(Sender: TObject);
begin
  inherited;
  DBEdit2.SetFocus;
end;

procedure TFrmEmpresa.btnLocalizarClick(Sender: TObject);
begin
  inherited;
  try
    if TFrmLocalizarCDS.Execute('Localizar Empresa',
    dmLocalizar.cdsEmpresa,'CIDADE;ENDERECO;CNPJ','Cidade;Endereo;CNPJ') then
    begin
      dmClient.cdsEmpresa.close;
      dmClient.cdsEmpresa.Params[0].Text := DMLocalizar.cdsEmpresaCNPJ.Text;
      DMClient.cdsEmpresa.Open;
    end;
  finally
    dmLocalizar.cdsEmpresa.Close;
  end;
end;

end.
