unit UProduto;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UCadastro, DB, ExtCtrls, DBCtrls, StdCtrls, Buttons, Mask;

type
  TFrmProduto = class(TFrmCadastro)
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBEdit3: TDBEdit;
    Label4: TLabel;
    DBEdit4: TDBEdit;
    Label5: TLabel;
    DBEdit5: TDBEdit;
    Label6: TLabel;
    DBEdit6: TDBEdit;
    GroupBox1: TGroupBox;
    Label8: TLabel;
    DBEdit8: TDBEdit;
    Label9: TLabel;
    DBEdit9: TDBEdit;
    Label10: TLabel;
    DBEdit10: TDBEdit;
    btnLocalizarEmpresa: TBitBtn;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnNovoClick(Sender: TObject);
    procedure btnLocalizarEmpresaClick(Sender: TObject);
    procedure btnLocalizarClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmProduto: TFrmProduto;

implementation

uses UDMClient, ULocalizarCDS, UDMLocalizar;

{$R *.dfm}

procedure TFrmProduto.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  FrmProduto:= nil;
end;

procedure TFrmProduto.btnNovoClick(Sender: TObject);
begin
  inherited;
  DBEdit1.SetFocus;
end;

procedure TFrmProduto.btnLocalizarEmpresaClick(Sender: TObject);
begin
  inherited;
  try
    {Executa o form de localizao.
    Define que o ttulo do form ser 'Localizar Empresa' e
    ser utilizado o cdsEmpresa do dmLocalizar para fazer
    a busca. Os campos disponveis para busca sero
    CIDADE, ENDERECO e CNPJ. No lugar do nome destes campos,
    ser exibido dentro do ComboBox cbxCampo, no form
    de localizao, os itens: Cidade, Endereo e CNPJ.
    Este itens correspondem aos campos definidos no parmetro anterior.
    Se a busca for executada com sucesso, ou seja,
    se o usurio encontrou o que queria, selecionou o registro
    e clicou no boto OK, pega os dados do registro
    selecionado no cdsEmpresa do dmLocalizar e atribui
    aos campos do cdsProduto do dmClient.
    Lembre-se que os campos CNPJ, ENDERECO e CIDADE,
    no cdsProduto no dmClient, no existem
    na tabela de produto, foram trazidos fazendo-se
    um join com a tabela empresa. So utilizados
    apenas para exibir alguns dados da empresa dentro
    do cadastro do produto. }
    if TFrmLocalizarCDS.Execute('Localizar Empresa',
    dmLocalizar.cdsEmpresa,'CIDADE;ENDERECO;CNPJ','Cidade;Endereo;CNPJ') then
    begin
      DMClient.cdsProduto.Edit;
      DMClient.cdsProdutoCOD_EMPRESA.AsInteger :=
        DMLocalizar.cdsEmpresaCOD_EMPRESA.AsInteger;
      DMClient.cdsProdutoCNPJ.Text :=
        DMLocalizar.cdsEmpresaCNPJ.Text;
      DMClient.cdsProdutoENDERECO.Text :=
        DMLocalizar.cdsEmpresaENDERECO.Text;
      DMClient.cdsProdutoCIDADE.Text :=
        DMLocalizar.cdsEmpresaCIDADE.Text;
    end;
  finally
    {Garante que o ClientDataSet ser fechado ao final. Na chamada
    da funo Execute do TFrmLocalizarCDS,  associado ao evento
    AfterClose do ClientDataSet passado como parmetro, uma rotina
    que atribui  propriedade CommandText, o valor original da mesma,
    antes da busca ser executada. Isto garante
    que novas buscas neste ClientDataSet no daro erro e sempre
    sero feitas da mesma forma, a partir da mesma SQL.} 
    dmLocalizar.cdsEmpresa.Close;
  end;
end;

procedure TFrmProduto.btnLocalizarClick(Sender: TObject);
begin
  inherited;
  try
    if TFrmLocalizarCDS.Execute('Localizar Produto',
    dmLocalizar.cdsProduto, 'DESCRICAO;COD_BARRAS',
    'Descrio;Cdigo Barras') then
    begin
      DMClient.cdsProduto.Close;
      DMClient.cdsProduto.Params[0].Text :=
        DMLocalizar.cdsProdutoCOD_BARRAS.Text;
      DMClient.cdsProduto.Params[1].Text :=
        DMLocalizar.cdsProdutoCOD_EMPRESA.Text;
      DMClient.cdsProduto.Open;
    end;
  finally
    DMLocalizar.cdsProduto.close;
  end;
end;

procedure TFrmProduto.btnSalvarClick(Sender: TObject);
begin
  if DataSource1.State = dsInsert then
  begin
     DMClient.cdsProduto.Params[0].Text:= DMClient.cdsProdutoCOD_BARRAS.Text;
     DMClient.cdsProduto.Params[1].Text:= DMClient.cdsProdutoCOD_EMPRESA.Text;
  end;
  inherited;
end;

end.
