unit UVenda;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, StdCtrls, Mask, DBCtrls, ExtCtrls, Buttons, Grids, DBGrids;

type
  TFrmVenda = class(TForm)
    Label1: TLabel;
    DBEdit1: TDBEdit;
    dsVenda: TDataSource;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBEdit3: TDBEdit;
    Label7: TLabel;
    EdtCliente: TDBEdit;
    DBRadioGroup1: TDBRadioGroup;
    btnLocalizarCliente: TSpeedButton;
    DBText1: TDBText;
    Label5: TLabel;
    Bevel1: TBevel;
    dsItem_Venda: TDataSource;
    Label6: TLabel;
    EdtCodBarras: TDBEdit;
    DBEdit6: TDBEdit;
    Label9: TLabel;
    EdtQuantidade: TDBEdit;
    Label10: TLabel;
    DBEdit9: TDBEdit;
    Bevel2: TBevel;
    btnLocalizarProduto: TSpeedButton;
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Label4: TLabel;
    Label8: TLabel;
    DBEdit4: TDBEdit;
    DBEdit5: TDBEdit;
    Label11: TLabel;
    procedure btnLocalizarProdutoClick(Sender: TObject);
    procedure btnLocalizarClienteClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure EdtCodBarrasKeyPress(Sender: TObject; var Key: Char);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure EdtQuantidadeKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    UltimoCodVenda: String;
  public
    { Public declarations }
  end;

var
  FrmVenda: TFrmVenda;

implementation

uses UDMClient, ULocalizarCDS, UDMLocalizar, UDMServer;

{$R *.dfm}

procedure TFrmVenda.btnLocalizarProdutoClick(Sender: TObject);
var sql: string;
begin
  if DMClient.cdsVendaCOD_EMPRESA.Text = '' then
     DMClient.cdsVenda.Insert;
  try
    sql:= dmLocalizar.cdsProduto.CommandText;
    dmLocalizar.cdsProduto.CommandText:=
      ' select P.COD_PRODUTO, P.COD_BARRAS, P.DESCRICAO, P.ESTOQUE_ATUAL, ' +
      ' P.PRECO_VENDA, P.COD_EMPRESA, E.CIDADE, E.ENDERECO ' +
      ' from PRODUTO P inner join EMPRESA E ' +
      ' on P.COD_EMPRESA = E.COD_EMPRESA ' +
      ' where P.COD_EMPRESA = ' + DMClient.cdsVendaCOD_EMPRESA.Text +
      ' order by P.DESCRICAO ';
    {Note que o ltimo parmetro (LocateOnKeyPress) foi passado como
    True para que o usurio, na busca do produto, no precise clicar
    no boto Localizar, ao digitar a busca j  realizada,
    agilizando a operao no caixa.}
    if TFrmLocalizarCDS.Execute('Localizar Produto',
    dmLocalizar.cdsProduto, 'DESCRICAO;COD_BARRAS',
    'Descrio;Cdigo Barras', True) then
    begin
      DMClient.cdsItem_Venda.Edit;
      DMClient.cdsItem_VendaCOD_PRODUTO.AsInteger :=
        DMLocalizar.cdsProdutoCOD_PRODUTO.AsInteger;
      DMClient.cdsItem_VendaCOD_BARRAS.Text :=
        DMLocalizar.cdsProdutoCOD_BARRAS.Text;
      DMClient.cdsItem_VendaDESCRICAO_PRODUTO.Text :=
        DMLocalizar.cdsProdutoDESCRICAO.Text;
      DMClient.cdsItem_VendaVALOR.AsCurrency :=
        DMLocalizar.cdsProdutoPRECO_VENDA.AsCurrency;
    end;
  finally
    DMLocalizar.cdsProduto.close;
    dmLocalizar.cdsProduto.CommandText:= sql;
  end;
end;

procedure TFrmVenda.btnLocalizarClienteClick(Sender: TObject);
begin
  try
    if TFrmLocalizarCDS.Execute('Localizar Cliente',
    dmLocalizar.cdsCliente, 'NOME;CPF',
    'Nome;CPF') then
    begin
      DMClient.cdsVenda.Edit;
      DMClient.cdsVendaCOD_CLIENTE.AsInteger :=
        DMLocalizar.cdsClienteCOD_CLIENTE.AsInteger;
      DMClient.cdsVendaCLIENTE.Text :=
        DMLocalizar.cdsClienteNOME.Text;
    end;
  finally
    DMLocalizar.cdsCliente.Close;
  end;
end;

procedure TFrmVenda.FormCreate(Sender: TObject);
begin
  DMClient.cdsVenda.Open;
end;

procedure TFrmVenda.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  DMClient.cdsVenda.Close;
end;

procedure TFrmVenda.EdtCodBarrasKeyPress(Sender: TObject; var Key: Char);
var
  CodProduto: Integer;
  Descricao: String;
  PrecoVenda: Currency;
begin
  {Quando  feita a leitura de um cdigo de barras,  como
  se o usurio tivesse digitado os nmeros referentes ao cdigo
  e pressionado Enter. Assim, verifica-se
  se foi pressionado um Enter no campo Cd. Barras e
  faz-se a busca pelo produto}
  if key = #13 then
  begin
    {Se a funo retornar true,  porque localizou o produto.
    Os parmetros CodProduto e Descricao  so
    parmetros de referncia, assim, as variveis passadas
    tero seus valores alterados para os dados do produto localizado.}
    if DMServer.BuscaProduto(EdtCodBarras.Text,
    dmClient.cdsVendaCOD_EMPRESA.AsInteger,
    CodProduto, Descricao, PrecoVenda) then
    begin
      DMClient.cdsItem_Venda.Edit;
      DMClient.cdsItem_VendaCOD_PRODUTO.AsInteger := CodProduto;
      DMClient.cdsItem_VendaDESCRICAO_PRODUTO.Text := Descricao;
      DMClient.cdsItem_VendaVALOR.AsCurrency := PrecoVenda;
      //Selecionar o prximo campo
      SelectNext(ActiveControl, True, True);
      //Anular o pressionamento do Enter para evitar o beep que ele gera
      Key:= #0;
    end
    else
    begin
      Application.MessageBox(
       'Produto no cadastrado.', 'Informao', MB_ICONEXCLAMATION);
      //Selecionar todo o contedo do campo.
      EdtCodBarras.SelectAll;
    end;
  end;
end;

procedure TFrmVenda.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  //Se no foi pressionada nenhuma tecla auxiliar como CTRL ou ALT.
  if Shift = [] then
  begin
    case key of
      vk_escape: dmClient.cdsItem_Venda.Cancel;
      vk_f2:
      begin
        if dmClient.cdsItem_VendaCOD_BARRAS.Text = '' then
           dmClient.cdsItem_Venda.Cancel;
        if dmClient.cdsVenda.State in [dsInsert, dsEdit] then
           dmClient.cdsVenda.Post;
        if DMClient.cdsItem_Venda.RecordCount = 0 then
           raise Exception.Create('Inclua algum item na venda.');
        //Se a atualizao foi realizada com sucesso.
        if DMClient.cdsVenda.ApplyUpdates(0) = 0 then
        begin
          {Se no existem mais alteraes a serem salvas no banco
          e se o COD_VENDA  zero, indicando que que o registro foi salvo
          porm, no foi atualizado ainda para trazer os valores
          gerados como a Data da Venda e os valores da chave primria.}
          if (DMClient.cdsVenda.ChangeCount = 0) and
          (DMClient.cdsVendaCOD_VENDA.AsInteger = 0) then
          begin
             {Carrega o(s) novo(s) valor(es) para o(s) parmetro(s)
             do cdsVenda. }
             DMClient.cdsVenda.FetchParams;
             {Atualiza os dados para mostrar os novos cdigos gerados.}
             DMClient.cdsVenda.Refresh;
             UltimoCodVenda := DMClient.cdsVendaCOD_VENDA.Text;
          end;

          //Inicia uma nova venda
          if dmClient.cdsVenda.State <> dsInsert then
             DMClient.cdsVenda.Insert;
        end;
      end;
      vk_f3:
      begin
        if InputQuery('Localizar Venda',
        'Digite o Cdido da Venda', UltimoCodVenda) then
        begin
          DMClient.cdsVenda.Close;
          DMClient.cdsVenda.Params[0].Text:= UltimoCodVenda;
          DMClient.cdsVenda.Open;
        end;
      end;
      vk_f4:
      begin
         EdtCodBarras.SetFocus;
         btnLocalizarProduto.Click;
      end;
      vk_f5:
      begin
        DMClient.cdsVenda.Edit;
        DMClient.cdsVendaFORMA_PAGAMENTO.Text := 'D';
        DBRadioGroup1.SetFocus;
        {Fazer a primeira opo do DBRadioGroup1 ser selecionada
        pois no existe um DBRadioGroup1.Controls[x].SetFocus}
        ActiveControl:= TWinControl(DBRadioGroup1.Controls[0]);
      end;
      vk_f6:
      begin
        DMClient.cdsVenda.Edit;
        DMClient.cdsVendaFORMA_PAGAMENTO.Text := 'CH';
        DBRadioGroup1.SetFocus;
        {Fazer a segunda opo do DBRadioGroup1 ser selecionada
        pois no existe um DBRadioGroup1.Controls[x].SetFocus}
        ActiveControl:= TWinControl(DBRadioGroup1.Controls[1]);
      end;
      vk_f7:
      begin
        EdtCliente.SetFocus;
        btnLocalizarCliente.Click;
      end;
    end;
  end;
end;

procedure TFrmVenda.EdtQuantidadeKeyPress(Sender: TObject; var Key: Char);
begin
  if key = #13 then
  begin
    DMClient.cdsItem_Venda.Append;
    EdtCodBarras.SetFocus;
    //Para anular o Enter e impedir o beep que  gerado por esta tecla no campo.
    Abort;
  end;
end;

end.
