/*Generator utilizado para gerar o cdigo do usurio */
CREATE GENERATOR GEN_SEGUR_USUARIO_ID;

CREATE TABLE SEGUR_USUARIO (
    COD_USUARIO INTEGER NOT NULL,
    LOGIN VARCHAR(10) NOT NULL,
    SENHA VARCHAR(10) NOT NULL,
    COD_FUNCIONARIO  INTEGER NOT NULL,
    TIPO_USUARIO CHAR(1) NOT NULL,
    CONSTRAINT PK_SEGUR_USUARIO PRIMARY KEY (COD_USUARIO)
);

/*Chave estrangeira para ligar a tabela segur_usuario  funcionario. */
ALTER TABLE SEGUR_USUARIO ADD CONSTRAINT FK_SEGUR_USUARIO_FUNCIONARIO
FOREIGN KEY (COD_FUNCIONARIO) REFERENCES FUNCIONARIO(COD_FUNCIONARIO);

/*ndice nico para impedir que tenham logins duplicados. */
CREATE UNIQUE INDEX IX_LOGIN ON SEGUR_USUARIO (LOGIN);

/*Trigger para incrementar generator do cdigo do usurio */
CREATE TRIGGER SEGUR_USUARIO_BI FOR SEGUR_USUARIO
ACTIVE BEFORE INSERT POSITION 0
AS
BEGIN
  IF ((NEW.COD_USUARIO IS NULL) OR (NEW.COD_USUARIO <= 0)) THEN
    NEW.COD_USUARIO = GEN_ID(GEN_SEGUR_USUARIO_ID,1);
END
