unit UCliente;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UCadastro, DB, ExtCtrls, DBCtrls, StdCtrls, Buttons, Mask;

type
  TFrmCliente = class(TFrmCadastro)
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label2: TLabel;
    DBEdit2: TDBEdit;
    Label3: TLabel;
    DBEdit3: TDBEdit;
    procedure btnNovoClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnLocalizarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmCliente: TFrmCliente;

implementation

uses UDMClient, UDMLocalizar, ULocalizarCDS, UDMServer;

{$R *.dfm}

procedure TFrmCliente.btnNovoClick(Sender: TObject);
begin
  inherited;
  DBEdit2.SetFocus;
end;

procedure TFrmCliente.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  {desassocia a varivel FrmCliente do endereo de
  memria que estava alocado para o form}
  FrmCliente:= nil;
end;

procedure TFrmCliente.btnSalvarClick(Sender: TObject);
begin
  //verifica se o registro  novo
  if DataSource1.State = dsInsert then
     {pega o valor do CPF do cliente e atribui ao parmetro
     para que o registro continue aparecendo aps
     includo no banco de dados, pois o filtro
     no SQLDataSet  feito pelo CPF. Se o valor
     do parmetro for diferente do valor do CPF do
     cliente inserido, o registro no  exibido.}
     DMClient.cdsCliente.Params[0].Text:= DMClient.cdsClienteCPF.Text;
  inherited;
end;

procedure TFrmCliente.btnLocalizarClick(Sender: TObject);
begin
  inherited;
  try
    if TFrmLocalizarCDS.Execute('Localizar Cliente',
    dmLocalizar.cdsCliente, 'NOME;CPF',
    'Nome;CPF') then
    begin
      DMClient.cdsCliente.Close;
      DMClient.cdsCliente.Params[0].Text :=
        DMLocalizar.cdsClienteCPF.Text;
      DMClient.cdsCliente.Open;
    end;
  finally
    DMLocalizar.cdsCliente.Close;
  end;
end;

end.
