unit UDMClient;

interface

uses
  SysUtils, Classes, DB, DBClient;

type
  TDMClient = class(TDataModule)
    cdsCliente: TClientDataSet;
    cdsFuncionario: TClientDataSet;
    cdsProduto: TClientDataSet;
    cdsItem_Venda: TClientDataSet;
    cdsItem_Entrada: TClientDataSet;
    cdsEmpresa: TClientDataSet;
    cdsVenda: TClientDataSet;
    cdsEntrada: TClientDataSet;
    cdsClienteCOD_CLIENTE: TIntegerField;
    cdsClienteNOME: TStringField;
    cdsClienteCPF: TStringField;
    cdsEmpresaCOD_EMPRESA: TIntegerField;
    cdsEmpresaCNPJ: TStringField;
    cdsEmpresaENDERECO: TStringField;
    cdsEmpresaCIDADE: TStringField;
    cdsProdutoCOD_PRODUTO: TIntegerField;
    cdsProdutoCOD_BARRAS: TStringField;
    cdsProdutoDESCRICAO: TStringField;
    cdsProdutoESTOQUE_ATUAL: TBCDField;
    cdsProdutoULTIMO_PRECO_COMPRA: TBCDField;
    cdsProdutoPRECO_VENDA: TBCDField;
    cdsProdutoMEDIA_PRECO_COMPRA: TBCDField;
    cdsProdutoCOD_EMPRESA: TIntegerField;
    cdsFuncionarioCOD_FUNCIONARIO: TIntegerField;
    cdsFuncionarioNOME: TStringField;
    cdsFuncionarioMATRICULA: TStringField;
    cdsFuncionarioCOD_EMPRESA: TIntegerField;
    cdsVendaCOD_VENDA: TIntegerField;
    cdsVendaDATA: TDateField;
    cdsVendaNUMERO_CAIXA: TSmallintField;
    cdsVendaCOD_FUNCIONARIO: TIntegerField;
    cdsVendaFORMA_PAGAMENTO: TStringField;
    cdsVendaCOD_EMPRESA: TIntegerField;
    cdsVendaCOD_CLIENTE: TIntegerField;
    cdsEntradaCOD_ENTRADA: TIntegerField;
    cdsEntradaNR_DOCUMENTO: TIntegerField;
    cdsEntradaDATA: TDateField;
    cdsProdutoCNPJ: TStringField;
    cdsProdutoENDERECO: TStringField;
    cdsProdutoCIDADE: TStringField;
    cdsFuncionarioCNPJ: TStringField;
    cdsFuncionarioENDERECO: TStringField;
    cdsFuncionarioCIDADE: TStringField;
    cdsEntradadtsItem_Entrada: TDataSetField;
    cdsItem_EntradaCOD_ENTRADA: TIntegerField;
    cdsItem_EntradaCOD_PRODUTO: TIntegerField;
    cdsItem_EntradaQUANTIDADE: TBCDField;
    cdsItem_EntradaVALOR: TBCDField;
    cdsItem_EntradaCOD_BARRAS: TStringField;
    cdsItem_EntradaDESC_PRODUTO: TStringField;
    cdsEntradaCOD_EMPRESA: TIntegerField;
    cdsEntradaDESC_EMPRESA: TStringField;
    cdsVendaFUNCIONARIO: TStringField;
    cdsVendaCLIENTE: TStringField;
    cdsVendadtsItem_Venda: TDataSetField;
    cdsItem_VendaCOD_VENDA: TIntegerField;
    cdsItem_VendaNR_ITEM: TIntegerField;
    cdsItem_VendaVALOR: TBCDField;
    cdsItem_VendaQUANTIDADE: TBCDField;
    cdsItem_VendaDESCRICAO_PRODUTO: TStringField;
    cdsItem_VendaCOD_BARRAS: TStringField;
    cdsItem_VendaCOD_PRODUTO: TIntegerField;
    cdsItem_VendaCalcSubTotal: TFloatField;
    cdsItem_VendaCalcTotalVenda: TAggregateField;
    cdsUsuario: TClientDataSet;
    cdsUsuarioLOGIN: TStringField;
    cdsUsuarioSENHA: TStringField;
    cdsUsuarioCOD_FUNCIONARIO: TIntegerField;
    cdsUsuarioTIPO_USUARIO: TStringField;
    cdsUsuarioFUNCIONARIO: TStringField;
    cdsUsuarioCOD_USUARIO: TIntegerField;
    procedure cdsFuncionarioAfterApplyUpdates(Sender: TObject;
      var OwnerData: OleVariant);
    procedure cdsItem_VendaCalcFields(DataSet: TDataSet);
    procedure cdsItem_VendaBeforeInsert(DataSet: TDataSet);
    procedure cdsItem_VendaAfterInsert(DataSet: TDataSet);
    procedure cdsVendaAfterInsert(DataSet: TDataSet);
    procedure cdsProdutoAfterInsert(DataSet: TDataSet);
    procedure cdsEntradaAfterInsert(DataSet: TDataSet);
    procedure cdsFuncionarioAfterInsert(DataSet: TDataSet);
  private
    { Private declarations }
    NrItemVenda: Integer;
  public
    { Public declarations }
  end;

var
  DMClient: TDMClient;

implementation

uses UDMServer, UDMLocalizar, ULocalizarCDS, ULogin, Usuario, UEmpresa,
  Empresa;

{$R *.dfm}

procedure TDMClient.cdsFuncionarioAfterApplyUpdates(Sender: TObject;
  var OwnerData: OleVariant);
begin
  {Aps uma atualizao ser realizada com sucesso no banco,
  chama o mtodo FetchParams do ClientDataSet para
  pegar o(s) valor(es) do(s) parmetro(s) do SQLDataSet
  no DMServer e atribuir ao(s) parmetro(s) do ClientDataSet,
  impedindo que o registro, aps ser includo no banco,
  desaparea do form.}
  TClientDataSet(Sender).FetchParams;
end;

procedure TDMClient.cdsItem_VendaCalcFields(DataSet: TDataSet);
begin
 cdsItem_VendaCalcSubTotal.AsCurrency :=
    cdsItem_VendaVALOR.AsCurrency*cdsItem_VendaQUANTIDADE.AsCurrency;
end;

procedure TDMClient.cdsItem_VendaBeforeInsert(DataSet: TDataSet);
begin
  //Vai para o ltimo item da venda
  cdsItem_Venda.Last;
  //Pega o valor do nmero do ltimo item e incrementa 1
  NrItemVenda:= cdsItem_VendaNR_ITEM.AsInteger + 1;
end;

procedure TDMClient.cdsItem_VendaAfterInsert(DataSet: TDataSet);
begin
  {Aps a incluso de um novo item, seu nmero ser o
  valor da varivel NrItemVenda. A varivel recebe um valor
  no evento BeforeInsert do cdsItem_Venda}
  cdsItem_VendaNR_ITEM.AsInteger:= NrItemVenda;
end;

procedure TDMClient.cdsVendaAfterInsert(DataSet: TDataSet);
begin
 cdsVendaCOD_FUNCIONARIO.AsInteger := User.Cod_Funcionario;
 cdsVendaFUNCIONARIO.Text := User.Nome_Funcionario;
end;

procedure TDMClient.cdsProdutoAfterInsert(DataSet: TDataSet);
var empresa: TEmpresa;
begin
  if DMServer.BuscaEmpresa(User.Cod_Empresa, empresa) then
  begin
    cdsProdutoCOD_EMPRESA.AsInteger := User.Cod_Empresa;
    cdsProdutoCNPJ.Text := empresa.cnpj;
    cdsProdutoENDERECO.Text := empresa.Endereco;
    cdsProdutoCIDADE.Text := empresa.Cidade;
  end;
end;

procedure TDMClient.cdsEntradaAfterInsert(DataSet: TDataSet);
var empresa: TEmpresa;
begin
  if DMServer.BuscaEmpresa(User.Cod_Empresa, empresa) then
  begin
    cdsEntradaCOD_EMPRESA.AsInteger := User.Cod_Empresa;
    cdsEntradaDESC_EMPRESA.Text :=
      empresa.Cnpj + ' - ' +
      empresa.Endereco + ' - ' +
      empresa.Cidade;
  end;
end;

procedure TDMClient.cdsFuncionarioAfterInsert(DataSet: TDataSet);
var empresa: TEmpresa;
begin
  if DMServer.BuscaEmpresa(User.Cod_Empresa, empresa) then
  begin
    cdsFuncionarioCOD_EMPRESA.AsInteger := User.Cod_Empresa;
    cdsFuncionarioCNPJ.Text := empresa.cnpj;
    cdsFuncionarioENDERECO.Text := empresa.Endereco;
    cdsFuncionarioCIDADE.Text := empresa.Cidade;
  end;
end;

end.
