unit UDMServer;

interface

uses
  Empresa, Usuario, dialogs, SysUtils, Classes, DBXpress, DB,
  SqlExpr, FMTBcd, Provider, DBClient,
  TConnect;

type
  TDMServer = class(TDataModule)
    SQLConnection1: TSQLConnection;
    dtsCliente: TSQLDataSet;
    dtsClienteCOD_CLIENTE: TIntegerField;
    dtsClienteNOME: TStringField;
    dtsClienteCPF: TStringField;
    dspCliente: TDataSetProvider;
    dtsEmpresa: TSQLDataSet;
    dspEmpresa: TDataSetProvider;
    dtsEntrada: TSQLDataSet;
    dspEntrada: TDataSetProvider;
    dtsFuncionario: TSQLDataSet;
    dspFuncionario: TDataSetProvider;
    dtsProduto: TSQLDataSet;
    dspProduto: TDataSetProvider;
    dtsVenda: TSQLDataSet;
    dspVenda: TDataSetProvider;
    dtsItem_Venda: TSQLDataSet;
    dtsItem_Entrada: TSQLDataSet;
    dtsEmpresaCOD_EMPRESA: TIntegerField;
    dtsEmpresaCNPJ: TStringField;
    dtsEmpresaENDERECO: TStringField;
    dtsEmpresaCIDADE: TStringField;
    dtsProdutoCOD_PRODUTO: TIntegerField;
    dtsProdutoCOD_BARRAS: TStringField;
    dtsProdutoDESCRICAO: TStringField;
    dtsProdutoESTOQUE_ATUAL: TBCDField;
    dtsProdutoULTIMO_PRECO_COMPRA: TBCDField;
    dtsProdutoPRECO_VENDA: TBCDField;
    dtsProdutoMEDIA_PRECO_COMPRA: TBCDField;
    dtsProdutoCOD_EMPRESA: TIntegerField;
    dtsFuncionarioCOD_FUNCIONARIO: TIntegerField;
    dtsFuncionarioNOME: TStringField;
    dtsFuncionarioMATRICULA: TStringField;
    dtsFuncionarioCOD_EMPRESA: TIntegerField;
    dtsVendaCOD_VENDA: TIntegerField;
    dtsVendaDATA: TDateField;
    dtsVendaNUMERO_CAIXA: TSmallintField;
    dtsVendaCOD_FUNCIONARIO: TIntegerField;
    dtsVendaFORMA_PAGAMENTO: TStringField;
    dtsVendaCOD_EMPRESA: TIntegerField;
    dtsVendaCOD_CLIENTE: TIntegerField;
    dtsItem_VendaCOD_VENDA: TIntegerField;
    dtsItem_VendaNR_ITEM: TIntegerField;
    dtsItem_VendaVALOR: TBCDField;
    dtsItem_VendaQUANTIDADE: TBCDField;
    dtsEntradaCOD_ENTRADA: TIntegerField;
    dtsEntradaNR_DOCUMENTO: TIntegerField;
    dtsEntradaDATA: TDateField;
    dtsEntradaCOD_EMPRESA: TIntegerField;
    dtsItem_EntradaCOD_ENTRADA: TIntegerField;
    dtsItem_EntradaCOD_PRODUTO: TIntegerField;
    dtsItem_EntradaQUANTIDADE: TBCDField;
    dtsItem_EntradaVALOR: TBCDField;
    LocalConnection1: TLocalConnection;
    dtsProdutoCNPJ: TStringField;
    dtsProdutoENDERECO: TStringField;
    dtsProdutoCIDADE: TStringField;
    dtsLocalizar: TSQLDataSet;
    dspLocalizar: TDataSetProvider;
    dtsFuncionarioCNPJ: TStringField;
    dtsFuncionarioENDERECO: TStringField;
    dtsFuncionarioCIDADE: TStringField;
    dsEntrada: TDataSource;
    dtsEntradaDESC_EMPRESA: TStringField;
    dtsItem_EntradaCOD_BARRAS: TStringField;
    dtsItem_EntradaDESC_PRODUTO: TStringField;
    dtsGeral: TSQLDataSet;
    dtsVendaFUNCIONARIO: TStringField;
    dtsVendaCLIENTE: TStringField;
    dsVenda: TDataSource;
    dtsItem_VendaDESCRICAO_PRODUTO: TStringField;
    dtsItem_VendaCOD_BARRAS: TStringField;
    dtsItem_VendaCOD_PRODUTO: TIntegerField;
    dtsUsuario: TSQLDataSet;
    dspUsuario: TDataSetProvider;
    dtsUsuarioCOD_USUARIO: TIntegerField;
    dtsUsuarioLOGIN: TStringField;
    dtsUsuarioSENHA: TStringField;
    dtsUsuarioCOD_FUNCIONARIO: TIntegerField;
    dtsUsuarioTIPO_USUARIO: TStringField;
    dtsUsuarioFUNCIONARIO: TStringField;
    dtsRelatorio: TSQLDataSet;
    dspRelatorio: TDataSetProvider;
    procedure dspFuncionarioBeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
    procedure dspEntradaBeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
    procedure dspVendaBeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
    procedure dspUsuarioBeforeUpdateRecord(Sender: TObject;
      SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
      UpdateKind: TUpdateKind; var Applied: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
    function Valor_Chave_Primaria(TableName: ShortString; Incremento: Byte=1): Integer;
    function Set_Primary_Keys(MasterTableName: String;
      SourceDS, RequiredDS: TDataSet;
      DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind): Integer;
    function BuscaProduto(CodBarras: ShortString;
      CodEmpresa: Integer; var CodProduto: Integer;
      var Descricao: String; var PrecoVenda: Currency): Boolean;

    function BuscaUsuario(Login, Senha: String;
      var User: TUsuario): Boolean;
    function AlterarSenha(Login, Senha: String): Boolean;
    function ExistemUsuariosCadastrados: Boolean;
    function BuscaEmpresa(Cod_Empresa: Integer; var empresa: TEmpresa): boolean;
    Function DateServ: TDateTime;
  end;

var
  DMServer: TDMServer;

implementation

uses ULogin;

{$R *.dfm}

{ TDMServer }



procedure TDMServer.dspFuncionarioBeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
  UpdateKind: TUpdateKind; var Applied: Boolean);
var cod: integer;
begin
  {Verifica se a operao que est prestes a ser
  executada no banco  um Insert}
  if UpdateKind = ukInsert then
  begin
     {O DeltaDS  um parmetro da classe TCustomClientDataSet
     que armazena todos os dados que esto sendo enviados ao banco.
     Ele no  o prprio cdsFuncionario do DMClient e sim apenas
     um objeto da classe TCustomClientDataSet.}

     {Edita o DeltaDS para permitir alterao nos dados que ele armazena em memria,
     que sero enviados ao banco.}
     DeltaDS.Edit;
     {Chama a funo Valor_Chave_Primaria informando que deseja-se
     pegar o valor do generator associado  tabela FUNCIONARIO.
     Como o segundo parmetro foi imitido, seu valor padro  1, como
     explicado no comentrio da funo Valor_Chave_Primaria.
     O retorno da funo  armazenado na varivel local cod.}
     cod := Valor_Chave_Primaria('FUNCIONARIO');
     {Atribui o valor da varivel cod ao campo COD_FUNCIONARIO do
     DeltaDS. Antes da atribuio o campo COD_FUNCIONARIO seria
     enviado ao banco com o valor zero, agora ele ter o valor
     gerado pelo generator, na funo Valor_Chave_Primaria.}
     DeltaDS.FieldByName('COD_FUNCIONARIO').AsInteger:= cod;
     //Salva a alterao na memria do DeltaDS
     DeltaDS.Post;

     {O SourceDS  o componente responsvel pela execuo da instruo
     SQL para atualizao dos dados no banco. Neste caso,
     o SourceDS  o dtsFuncionario, que  um componente TSQLDataSet.
     No If abaixo  apenas verificaso se o SourceDS 
     realmente um TSQLDataSet. Se for, acessa a propriedade
     Params dele, alterando o valor do primeiro parmetro
     para o valor da varivel cod, que contm o valor retornado
     pelo generator. Com este If abaixo  que impedimos
     que o registro, aps ser includo no banco, desaparea
     do formulrio de cadastro, pois agora a aplicao  que
     atribui um valor ao campo chave e assim ela conhece
     esse valor e pode atribu-lo ao parmetro do SQLDataSet, impedindo
     que o registro desaparea. Porm, precisamos incluir mais
     uma linha de cdigo no DMClient para isto funcionar.
     Esta linha ser mostrada em seguida.}
     if SourceDS is TSQLDataSet then
        TSQLDataSet(SourceDS).Params[0].AsInteger := cod;
  end;
end;

{O parmetro TableName indica o nome da tabela da qual deseja-se
pegar o valor do generator que est associado a ela, sendo
que os generators criados no banco devem seguir o padro
GEN_NomeTable_ID. Caso os generators do seu banco
no estejam neste padro, altere o cdigo desta funo
para o formato do nome do seu generator. O nome do generator
poderia ser passado via parmetro, ao invs de o nome
da tabela, porm, fica mais fcil simplesmente passar
o nome da tabela e a funo montrar o nome do generator
a partir da. Assim, o desenvolvedor no precisa
ficar pensando em como  o formato do nome
dos generators.

O parmetro Incremento  um parmetro Default. Se ele
for omitido na chamada da funo, seu valor ser 1.
Este valor indica que, antes de retornar o valor do generator,
este  incrementado com o valor do parmetro Incremento, e  retornado
o valor do generator depois de incrementado. Se Incremento for passado
como zero, a funo apenas devolve o valor atual do generator, sem
incremet-lo.}
function TDMServer.Valor_Chave_Primaria(TableName: ShortString; Incremento: Byte=1): Integer;
var dts: TSQLDataSet;
begin
  {$IFDEF Firebird}
  //Cria um objeto local da classe TSQLDataSet 
  dts:= TSQLDataSet.Create(nil);
  try
    //Associa o dts  conexo SQLConnection1 
    dts.SQLConnection := SQLConnection1;
    {gera um select para pegar o valor do generator
    associado  tabela informado em TableName.
    A tabela rdb$database  uma tabela de sistema, ou seja,
    uma tabela interna do Firebird. Ela est sendo utilizada aqui
    para executar selects que no trazem dados de nenhuma
    tabela criada pelo desenvolvedor, e sim para executar
    a funo gen_id do Firebird. Como no Firebird, e em muitos outros bancos,
    todo select deve possuir um "from NOME_TABELA"
    (diferente do Microsoft SQL Server), ento  usada
    esta tabela interna do Firebird que sempre retorna apenas um registro
    e permite a execu de funo como gen_id, current_date, current_time, etc.}
    dts.CommandText :=
      'select gen_id(GEN_' +
      TableName + '_ID, '+IntToStr(Incremento)+') from rdb$database';
    dts.Open;
    //Pega o valor do generator 
    result:= dts.Fields[0].AsInteger;
    dts.Close;
  finally
    dts.Free;
  end;
  {$ELSE IFDEF MySQL or IFDEF SQLite}
    {Apague a linha do raise, abaixo, e implementa o cdigo para o banco MySQL/SQLite. }
    raise exception.create('Funo Valor_Chave_Primaria no implementada para MySQL/SQLite');
  {$ENDIF}
end;

procedure TDMServer.dspEntradaBeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
  UpdateKind: TUpdateKind; var Applied: Boolean);
begin
  {Este evento ocorre antes de um registro, seja da tabela mestre ou
  das tabelas detalhes ligadas  mestre, ser enviado para atualizao no banco.
  O primeiro parmetro indica o nome da tabela mestre. O segundo indica
  o DataSet (que neste caso ser um SQLDataSet) que originou a atualizao,
  podendo ser o SQLDataSet mestre ou um detalhe, o terceiro indica qual DataSet
  deve estar sendo atualizado para que a funo seja executada (neste caso,
  a funo s executar se o DataSet sendo atualizado for o dtsEntrada), o
  quarto indica um objeto da classe TCustomDataSet que contm
  os dados a serem atualizados no banco (sejam estes dados da mestre
  ou da detalhe, mas a funo s executa algo quando a tabela sendo
  atualizada for a mestre) e o quinto indica qual o tipo de atualizao
  est sendo executada (insero, alterao ou excluso, sendo que a funo
  s executa algo se a operao for uma insero).

  Quando um registro da tabela detalhe (item_entrada) for atualizado
  no banco, este evento ser disparado tambm, chamando a funno Set_Primary_Keys,
  porm, ela no far nada, somente quando for a tabela mestre  que
  ela faz algo.

  Note que os parmetros SourceDS, DeltaDS e UpdateKind so
  parmetros do prprio evento e que so apenas repassados
  para a funo criada. O primeiro parmetro  utilizado
  para pegar o nome do generator associado  tabela mestre
  e para montar o nome do campo chave-primria da tabela mestre.
  O campo chave-estrangeira na tabela detalhe tem este mesmo nome.}
  Set_Primary_Keys('ENTRADA', SourceDS, dtsEntrada, DeltaDS, UpdateKind);
end;

function TDMServer.Set_Primary_Keys(MasterTableName: String;
  SourceDS, RequiredDS: TDataSet;
  DeltaDS: TCustomClientDataSet; UpdateKind: TUpdateKind): Integer;
var
  cod, i: integer;
  dt: TDataSet;
  chave: ShortString;

begin
  result:= 0;

  {Verifica se a operao  uma insero e se est sendo
  realizada na tabela mestre pois, num relacionamento mestre-detalhe
  em DBExpress, o DataSetProvider ligado  tabela mestre,
  atualiza tanto esta quanto a tabela detalhe. Assim,
  precisa-se verificar qual a tabela que est
  sendo atualizada no momento.}
  if (UpdateKind = ukInsert)
  and (SourceDS = RequiredDS) then
  begin
    {O nome do campo Chave Primria da tabela mestre, pelo
    padro adotado no banco criado,  COD_NomeTabela.}
    chave:= 'COD_' + MasterTableName;

    {Chama a funo Valor_Chave_Primaria para pegar o
    valor do generator associado  tabela mestre.}
    cod:= Valor_Chave_Primaria(MasterTableName);

    {Percorre os campos do DeltaDS, que  um ClientDataSet
    contendo os dados do registro a ser atualizado no banco.}
    for i := 0 to DeltaDS.FieldCount - 1 do
    begin
      {Verifica se o Campo do DeltaDS, na posio I,  um TDataSetField.
      Se for, este DataSetField representa uma tabela inteira, assim,
      a propriedade NestedDataSet do campo (observe que foi feito
      um TypeCast no DeltaDS.Fields[i] para a classe TDataSetField,
      para podermos acessar a propriedade NestedDataSet) representa
      a tabela que o DataSetField representa.}
      if DeltaDS.Fields[i] is TDataSetField then
      begin
         {Aqui a tabela que representa o DataSetField  armazenada
         na varivel local dt, que  do tipo TDataSet. Isto para facilitar
         a programao, pois fica mais fcil usar somente dt do que
         usar  TDataSetField(DeltaDS.Fields[i]).NestedDataSet a todo momento.}
         dt:= TDataSetField(DeltaDS.Fields[i]).NestedDataSet;

         {Cada DataSetField existente na tabela mestre representa uma tabela
         detalhe, assim, com a linha abaixo a tabela detalhe  posicionada
         na primeira linha, pois precisamos percorrer todos os seus registros
         alterando o cdigo que  a chave-estrangeira da tabela.}
         dt.First;

         while not(dt.Eof) do
         begin
           {Altera o campo chave-estrangeira da tabela detalhe em todos os registros
           dela.
           Primeiro deve-se alterar o valor da chave-estrangeira na tabela detalhe)
           para depois alterar o cdigo da tabela mestre pois,
           como inicialmente o cdigo da mestre  zero, o cdigo
           nas detalhes tambm ser zero. Se for feita
           a alterao do cdigo primeiro na mestre,
           todos os registros das detalhes desaparecero, pois
           o cdigo da mestre ser um valor diferente de zero
           e das detalhes continuar zero. Assim, deve-se
           alterar primeiro o cdigo das detalhes para
           depois alterar o cdigo da mestre.
           O DeltaDS  um ClientDataSet contendo os dados que sero enviados ao banco.
           Assim, os dados devem ser alterados nele para
           depois o DataSetProvider enviar para o banco.
           Na aplicao, aps a insero, deve-se aplicar
           um refresh no ClientDataSet para que ele
           visualize os novos valores dos cdigos. Isto j est
           sendo feito no FrmCadastro.}
           dt.Edit;
           {Cod  o valor recebido do generator, por meio da funo Valor_Chave_Primaria.}
           dt.FieldByName(chave).AsInteger := cod;
           dt.Post;
           dt.Next;
         end;
      end;
    end;

    //Altera o cdigo da tabela mestre para o cdigo obtido do generator.
    DeltaDS.Edit;
    DeltaDS.FieldByName(chave).AsInteger := cod;
    DeltaDS.Post;
    {A funo devolve o valor do cdigo gerado.}
    result:= cod;

    {J foi explicado no evento BeforeUpdateRecord do dspFuncionario.}
    if SourceDS is TSQLDataSet then
       TSQLDataSet(SourceDS).Params[0].AsInteger := cod;
  end;
end;

function TDMServer.BuscaProduto(CodBarras: ShortString;
  CodEmpresa: Integer; var CodProduto: Integer;
  var Descricao: String; var PrecoVenda: Currency): Boolean;
begin
  dtsGeral.Close;
  dtsGeral.CommandText :=
    ' select COD_PRODUTO, DESCRICAO, PRECO_VENDA ' +
    ' from PRODUTO where COD_BARRAS = ' + QuotedStr(CodBarras) +
    ' and COD_EMPRESA = ' + IntToStr(CodEmpresa);
  dtsGeral.Open;
  CodProduto:= dtsGeral.FieldByName('COD_PRODUTO').AsInteger;
  Descricao:= dtsGeral.FieldByName('DESCRICAO').Text;
  PrecoVenda:= dtsGeral.FieldByName('PRECO_VENDA').AsCurrency;
  {Se o CodProduto for maior que zero, ento, o produto
  foi localizado.}
  result:= (CodProduto > 0);
  dtsGeral.Close;
end;

procedure TDMServer.dspVendaBeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
  UpdateKind: TUpdateKind; var Applied: Boolean);
begin
 Set_Primary_Keys('VENDA', SourceDS, dtsVenda, DeltaDS, UpdateKind);
end;

procedure TDMServer.dspUsuarioBeforeUpdateRecord(Sender: TObject;
  SourceDS: TDataSet; DeltaDS: TCustomClientDataSet;
  UpdateKind: TUpdateKind; var Applied: Boolean);
var cod: integer;
begin
  {Cdigo comentado no evento BeforeUpdateRecord do dspFuncionario}
  if UpdateKind = ukInsert then
  begin
     DeltaDS.Edit;
     cod := Valor_Chave_Primaria('SEGUR_USUARIO');
     DeltaDS.FieldByName('COD_USUARIO').AsInteger:= cod;
     DeltaDS.Post;
     if SourceDS is TSQLDataSet then
        TSQLDataSet(SourceDS).Params[0].AsInteger := cod;
  end;
end;

{Buscar um usurio pelo Login e Senha }
function TDMServer.BuscaUsuario(Login, Senha: String;
  var User: TUsuario): Boolean;
begin
  Result:= false;
  User.Cod_Usuario:= 0;
  User.Cod_Funcionario:= 0;
  User.Nome_Funcionario := '';
  User.Cod_Empresa:= 0;
  User.Login:= '';
  
  try
    dtsGeral.Close;
    dtsGeral.CommandText :=
      ' select u.COD_USUARIO, u.COD_FUNCIONARIO, f.NOME, ' +
     '  f.COD_EMPRESA ' + 
      ' from SEGUR_USUARIO U ' +
      ' inner join FUNCIONARIO F ' +
      ' on F.COD_FUNCIONARIO = U.COD_FUNCIONARIO ' +
      ' where u.login = ' + QuotedStr(Login) +
      ' and u.senha = ' + QuotedStr(Senha);
    dtsGeral.Open;
    if dtsGeral.FieldByName('COD_USUARIO').AsInteger > 0 then
    begin
      Result:= true;
      User.Login:= Login; 
      User.Cod_Usuario:= dtsGeral.FieldByName('COD_USUARIO').AsInteger;
      User.Cod_Funcionario:= dtsGeral.FieldByName('COD_FUNCIONARIO').AsInteger;
      User.Nome_Funcionario := dtsGeral.FieldByName('NOME').Text;
      User.Cod_Empresa:= dtsGeral.FieldByName('COD_EMPRESA').AsInteger;
    end;
  finally
    dtsGeral.Close;
  end;
end;

{Alterar a senha do usurio com o login informado no parmetro Login}
function TDMServer.AlterarSenha(Login, Senha: String): Boolean;
var sql: string;
begin
  sql:= 'update SEGUR_USUARIO set senha = ' +
    QuotedStr(senha) + ' where login = ' + QuotedStr(login);
  //Execute retorna a quantidade de registros alterados.
  //Se for maior que zero,  porque a alterao foi feita
  result:=
    (SQLConnection1.Execute(sql, nil) > 0);
end;

{Verifica se existe algum usurio cadastrado no banco de dados,
retornado true caso exista.}
function TDMServer.ExistemUsuariosCadastrados: Boolean;
begin
  dtsGeral.Close;
  try
    dtsGeral.CommandText := 'select count(*)  from SEGUR_USUARIO';
    dtsGeral.Open;
    result:= dtsGeral.Fields[0].AsInteger > 0;
  finally
    dtsGeral.Close;
  end;
end;

function TDMServer.BuscaEmpresa(Cod_Empresa: Integer; var empresa: TEmpresa): Boolean;
begin
  result:= false;
  empresa.Cod_Empresa := 0;
  empresa.Cnpj := '';
  empresa.Endereco := '';
  empresa.Cidade := '';
  dtsGeral.Close;
  try
    dtsGeral.CommandText :=
      ' select cod_empresa, cnpj, endereco, cidade ' +
      ' from empresa where cod_empresa = ' + IntToStr(cod_empresa);
    dtsGeral.Open;
    if dtsGeral.FieldByName('cod_empresa').Text <> '' then
    begin
      empresa.Cod_Empresa := Cod_Empresa;
      empresa.Cnpj := dtsGeral.FieldByName('cnpj').Text;
      empresa.Endereco := dtsGeral.FieldByName('endereco').Text;
      empresa.Cidade := dtsGeral.FieldByName('cidade').Text;
      result:= true;
    end;
  finally
    dtsGeral.Close;
  end;
end;

Function TDMServer.DateServ: TDateTime;
begin
  try
    dtsGeral.Close;
    dtsGeral.CommandText:=
       'select DATA_HORA from VW_DATA_HORA';
    dtsGeral.Open;
    result:= dtsGeral.Fields[0].AsDateTime;
  finally
    dtsGeral.close;
  end;
end;


end.
