unit ULogin;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ToolWin, ComCtrls, ExtCtrls;

type
  TFrmLogin = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    EdtSenha: TEdit;
    btnEntrar: TBitBtn;
    btnFechar: TBitBtn;
    EdtLogin: TEdit;
    Image1: TImage;
    btnAlterarSenha: TBitBtn;
    procedure btnEntrarClick(Sender: TObject);
    procedure btnAlterarSenhaClick(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    ok: boolean;
  public
    { Public declarations }
    class function Execute: Boolean;
  end;


var
  FrmLogin: TFrmLogin;


implementation

uses UAlterarSenha, UDMServer, Usuario;

{$R *.DFM}

procedure TFrmLogin.btnEntrarClick(Sender: TObject);
begin
  if (trim(EdtLogin.Text) = '') then
  begin
     ModalResult:= mrNone;
     EdtLogin.SetFocus;
     raise exception.create('Informe o Login.');
  end;

  if (trim(EdtSenha.Text) = '') then
  begin
     ModalResult:= mrNone;
     EdtSenha.SetFocus;
     raise exception.create('Informe a Senha.');
  end;

  {A funo BuscaUsuario busca os dados de um usurio
  a partir do Login e Senha informados. As variveis
  CodUsuario, CodFuncionario e NomeFuncionario so
  passadas por referncia  funo, assim, seu
  valor  alterado na funo.}
  if DMServer.BuscaUsuario(EdtLogin.Text, EdtSenha.Text, User) then
  begin
     //Informa que o form pode ser fechado sem perguntar antes.
     ok:= true;
  end
  else
  begin
    {Impede que o form seja fechado pois, como
    o valor da propriedade ModalResult do btnEntrar  igual
    a mrOK (valor 1), ento, ao clicar no boto,
    como o form foi aberto com ShowModal, ele
     fechado automaticamente.}
    ModalResult := mrNone;
    raise exception.create('Login ou Senha invlida.');
  end;
end;

procedure TFrmLogin.btnAlterarSenhaClick(Sender: TObject);
begin
  TFrmAlterarSenha.Execute(EdtLogin.Text, EdtSenha.Text);
end;

class function  TFrmLogin.Execute: Boolean;
begin
  result:= true;
  //S mostra o FrmLogin se existir algum usurio cadastrado
  if DMServer.ExistemUsuariosCadastrados then
  begin
    {O form deve ser criado da forma abaixo,
    ao invs de usando Application.CreateForm
    pois, ele ser o primeiro a ser mostrado
    e no  o form principal. O primeiro
    form criado usando Application.CreateForm
    se torna o form principal.}
    FrmLogin:= TFrmLogin.Create(Application);
    try
      {A funo devolve true se o usurio fechou o form
      clicando no boto OK. Isto indica que o login e a senha
      informados eram corretos, pois, se no forem,
      clicando no OK, o FrmLogin no  fechado.}
      result:= (FrmLogin.ShowModal = mrOK);
    finally
      FrmLogin.Free;
    end;
  end;
end;

procedure TFrmLogin.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  {Se o form est sendo fechado por outro meio
  que no o boto OK, ento pergunta antes de fechar.}
  if (not ok) and (Application.MessageBox('Tem certeza que deseja fechar o sistema?',
  'Confirmao',mb_iconQuestion + mb_OKCancel) <> mrOK) then
     CanClose:= false; //Impede o form de ser fechado.
end;

procedure TFrmLogin.FormCreate(Sender: TObject);
begin
  ok:= false;
end;

end.

