unit UPrinc;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ToolWin, AppEvnts, ImgList, ActnList, ExtCtrls, Menus,
  XPMan, StdActns, StdCtrls, RLPDFFilter, RLHTMLFilter,
  RLFilters, RLDraftFilter, RLRichFilter;

type
  TFrmPrincipal = class(TForm)
    MainMenu1: TMainMenu;
    Timer1: TTimer;
    ActionList1: TActionList;
    ImageList1: TImageList;
    ApplicationEvents1: TApplicationEvents;
    CoolBar1: TCoolBar;
    ToolBar1: TToolBar;
    StatusBar1: TStatusBar;
    actCliente: TAction;
    Cadastro1: TMenuItem;
    Clientes1: TMenuItem;
    ToolButton1: TToolButton;
    XPManifest1: TXPManifest;
    actEmpresa: TAction;
    Empresas1: TMenuItem;
    ToolButton2: TToolButton;
    actProduto: TAction;
    Produtos1: TMenuItem;
    ToolButton3: TToolButton;
    actFuncionario: TAction;
    Funcionrio1: TMenuItem;
    ToolButton4: TToolButton;
    Janela1: TMenuItem;
    WindowClose1: TWindowClose;
    Fechar1: TMenuItem;
    Label1: TLabel;
    actEntrada: TAction;
    Entradas1: TMenuItem;
    ToolButton5: TToolButton;
    actFechar: TAction;
    N1: TMenuItem;
    Fechar2: TMenuItem;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    actVenda: TAction;
    N2: TMenuItem;
    Vendas1: TMenuItem;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    actUsuario: TAction;
    N3: TMenuItem;
    Usurios1: TMenuItem;
    ActRelProdutos: TAction;
    Relatrios1: TMenuItem;
    Produtos2: TMenuItem;
    RLRichFilter1: TRLRichFilter;
    RLDraftFilter1: TRLDraftFilter;
    RLHTMLFilter1: TRLHTMLFilter;
    RLPDFFilter1: TRLPDFFilter;
    ActSalvarRelProdutos: TAction;
    SalvarRelatriodeProdutos1: TMenuItem;
    ActRelVendasFuncFormaPag: TAction;
    VendasporFuncionrioFormadePagamento1: TMenuItem;
    procedure actClienteExecute(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure ApplicationEvents1Hint(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure actEmpresaExecute(Sender: TObject);
    procedure actProdutoExecute(Sender: TObject);
    procedure actFuncionarioExecute(Sender: TObject);
    procedure actEntradaExecute(Sender: TObject);
    procedure actFecharExecute(Sender: TObject);
    procedure actVendaExecute(Sender: TObject);
    procedure actUsuarioExecute(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure ActRelProdutosExecute(Sender: TObject);
    procedure ActSalvarRelProdutosExecute(Sender: TObject);
    procedure ActRelVendasFuncFormaPagExecute(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmPrincipal: TFrmPrincipal;

implementation

uses UCliente, Math, UEmpresa, UProduto, UFuncionario, UEntrada, UVenda,
  UUsuario, Usuario, URelProdutos, DateUtils, URelVendasPorFuncionario;

{$R *.dfm}

procedure TFrmPrincipal.actClienteExecute(Sender: TObject);
begin
  //verifica se o form no foi criado
  if FrmCliente = nil then
     Application.CreateForm(TFrmCliente, FrmCliente);  //cria o form
  FrmCliente.Show;  //mostra o form
end;

procedure TFrmPrincipal.Timer1Timer(Sender: TObject);
begin
  //mostra a data como, por exemplo, domingo, 24 de setembro de 2006, 23:52:05.
  {StatusBar1.Panels[0].Text :=
    FormatDateTime('dddd, dd "de" mmmm "de" yyyy, hh:nn:ss.', now);}

  //ou simplesmente o cdigo abaixo, que faz o mesmo que o anterior
  StatusBar1.Panels[0].Text := FormatDateTime('dddddd, hh:nn:ss.', now);
end;

procedure TFrmPrincipal.ApplicationEvents1Hint(Sender: TObject);
begin
  StatusBar1.Panels[1].Text := Application.Hint;
end;

procedure TFrmPrincipal.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  {verifica se a quantidade de form MDIChild abertos  maior que zero.
  Se for, solicita confirmao para fechar a aplicao}
  if (MDIChildCount > 0) and
  (Application.MessageBox(pchar('Tem certeza que deseja fechar a aplicao?'#13 +
     'Para fechar somente a janela atual, utilize as teclas CTRL + F4.'),
     'Confirmao', MB_ICONQUESTION + MB_OKCANCEL) = mrCancel) then
       //impede o fechamento do programa
       CanClose:= false;
end;

procedure TFrmPrincipal.actEmpresaExecute(Sender: TObject);
begin
  if FrmEmpresa = nil then
     Application.CreateForm(TFrmEmpresa, FrmEmpresa);
  FrmEmpresa.Show;
end;

procedure TFrmPrincipal.actProdutoExecute(Sender: TObject);
begin
  if FrmProduto = nil then
     Application.CreateForm(TFrmProduto, FrmProduto);
  FrmProduto.Show;
end;

procedure TFrmPrincipal.actFuncionarioExecute(Sender: TObject);
begin
  if FrmFuncionario = nil then
     Application.CreateForm(TFrmFuncionario, FrmFuncionario);
  FrmFuncionario.Show;
end;

procedure TFrmPrincipal.actEntradaExecute(Sender: TObject);
begin
  if FrmEntrada = nil then
     Application.CreateForm(TFrmEntrada, FrmEntrada);
  FrmEntrada.Show;
end;

procedure TFrmPrincipal.actFecharExecute(Sender: TObject);
begin
  close;
end;

procedure TFrmPrincipal.actVendaExecute(Sender: TObject);
begin
  Application.CreateForm(TFrmVenda, FrmVenda);
  try
    FrmVenda.ShowModal;
  finally
    FrmVenda.Free;
  end;
end;

procedure TFrmPrincipal.actUsuarioExecute(Sender: TObject);
begin
   if FrmUsuario = nil then
     Application.CreateForm(TFrmUsuario, FrmUsuario);
  FrmUsuario.Show;
end;

procedure TFrmPrincipal.FormShow(Sender: TObject);
begin
  if User.Nome_Funcionario <> '' then
    StatusBar1.Panels[2].Text := 'Usurio: ' + User.Nome_Funcionario
  else StatusBar1.Panels[2].Text := '';
end;

procedure TFrmPrincipal.ActRelProdutosExecute(Sender: TObject);
begin
  TFrmRelProdutos.Execute;
end;

procedure TFrmPrincipal.ActSalvarRelProdutosExecute(Sender: TObject);
begin
  TFrmRelProdutos.Execute(true);
end;

procedure TFrmPrincipal.ActRelVendasFuncFormaPagExecute(Sender: TObject);
var
  data: TDate;
  mesAno: String;
  mes, ano: Integer;
begin
 if InputQuery('Vendas por Funcionrio/Forma Pagamento',
 'Digite o Ms/Ano para impresso do relatrio', mesAno) then
 begin
   {Monta uma data com o valor de mesAno e tenta converter para TDate
   para verificar se o usurio digitou um ms/ano vlido.}
   try
     data:= StrToDate('01/' + mesAno);
   except
     Application.MessageBox('Ms/Ano invlido', 'Erro', mb_iconError);
     exit; 
   end;
   {Se no deu erro, este cdigo ser executado para pegar o mes e ano separados.}
   //Adicione a unit DateUtils
   mes:= MonthOf(data);
   ano:= YearOf(data);
   TFrmRelVendasPorFuncionario.Execute(mes, ano, false);
 end;
end;

end.
