unit URelEntrada;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RLReport, DB, DBClient, RLBarcode;

type
  TFrmRelEntrada = class(TForm)
    RLReport1: TRLReport;
    cdsEntrada: TClientDataSet;
    dsEntrada: TDataSource;
    RLBand1: TRLBand;
    RLSystemInfo2: TRLSystemInfo;
    RLBand5: TRLBand;
    RLLabel5: TRLLabel;
    RLLabel6: TRLLabel;
    SaveDialog1: TSaveDialog;
    RLBand3: TRLBand;
    RLDBText1: TRLDBText;
    RLDBText2: TRLDBText;
    RLSubDetail1: TRLSubDetail;
    dsItem_Entrada: TDataSource;
    cdsItem_Entrada: TClientDataSet;
    cdsEntradaCOD_ENTRADA: TIntegerField;
    cdsEntradaNR_DOCUMENTO: TIntegerField;
    cdsEntradaDATA: TDateField;
    RLBand4: TRLBand;
    RLBand7: TRLBand;
    RLDBText3: TRLDBText;
    RLDBText4: TRLDBText;
    RLLabel1: TRLLabel;
    RLLabel4: TRLLabel;
    RLLabel7: TRLLabel;
    RLLabel8: TRLLabel;
    cdsItem_EntradaCOD_PRODUTO: TIntegerField;
    cdsItem_EntradaCOD_ENTRADA: TIntegerField;
    cdsItem_EntradaPRODUTO: TStringField;
    cdsItem_EntradaQUANTIDADE: TBCDField;
    cdsItem_EntradaVALOR: TBCDField;
    cdsItem_EntradaSUB_TOTAL: TBCDField;
    RLDBText5: TRLDBText;
    RLDBText6: TRLDBText;
    RLLabel2: TRLLabel;
    RLLabel3: TRLLabel;
    RLBand2: TRLBand;
    RLDBResult2: TRLDBResult;
    RLSystemInfo3: TRLSystemInfo;
    RLDBResult1: TRLDBResult;
    RLDBResult3: TRLDBResult;
    procedure RLLabel5BeforePrint(Sender: TObject; var Text: String;
      var PrintIt: Boolean);
    procedure RLLabel6BeforePrint(Sender: TObject; var Text: String;
      var PrintIt: Boolean);
  private
    { Private declarations }
    totalPgs: Integer;
  public
    { Public declarations }
    class function Execute(CodEntrada: Integer; Save: Boolean = false): Boolean;
  end;

var
  FrmRelEntrada: TFrmRelEntrada;

implementation

uses UDMServer;

{$R *.dfm}

class function TFrmRelEntrada.Execute(CodEntrada: Integer; Save: Boolean = false): Boolean;
begin
   result:= false;
  {Esta linha deve ser recortada do arquivo do projeto
  (pressione CTRL+F12 para abrir o projeto)}
  Application.CreateForm(TFrmRelEntrada, FrmRelEntrada);
  with FrmRelEntrada do
  try
    cdsEntrada.Params.ParamByName('COD_ENTRADA').AsInteger := CodEntrada;
    cdsEntrada.Open;
    cdsItem_Entrada.Open;
    if cdsEntrada.RecordCount > 0 then
    begin
      SaveDialog1.FileName := RLReport1.Title;
      {Se  para salvar mas o usurio clicou
      em Cancelar na janela se seleo do nome do arquivo
      para o relatrio, ento sai da funo sem gerar
      o relatrio.}
      if Save and (not SaveDialog1.Execute) then
         exit;

      {Prepara o relatrio antes de imprimir para descobrir
      quantas pginas ele dar.}
      RLReport1.Prepare;
      {Declare a varivel como Integer na seo private do form}
      totalPgs := RLReport1.LastPageNumber;
      if Save then
         RLReport1.SaveToFile(SaveDialog1.FileName)
      else RLReport1.PreviewModal;
      {Voc pode usar RLReport1.Preview();}
      result:= true;
    end
    else Application.MessageBox(
      'No existe nenhum registro a ser impresso',
      'Informao',
      MB_ICONINFORMATION);
  finally
    Free;
  end;
end;

procedure TFrmRelEntrada.RLLabel5BeforePrint(Sender: TObject;
  var Text: String; var PrintIt: Boolean);
begin
  {Text  um parmetro do procedure que representa
  o Caption do label. A funo format
   utilizada para montar uma string sem
  se preocupar com converses de tipo (o %d indica
  que aquela posio ser substituda por um nmero inteiro,
  os valores so o segundo parmetro da funo Format,
  que esto entre colchetes, representando um vetor de valores).
  O valor da varivel totalPgs ser obtido posteriormente.}
  Text:= Format('Pgina %d de %d', [RLReport1.PageNumber, totalPgs]);
end;

procedure TFrmRelEntrada.RLLabel6BeforePrint(Sender: TObject;
  var Text: String; var PrintIt: Boolean);
begin
  Text:= 'Data de Impresso: ' + FormatDateTime('dd/mm/yyyy', DMServer.DateServ);
end;

end.
