unit URelProdutos;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RLReport, DB, DBClient, RLBarcode;

type
  TFrmRelProdutos = class(TForm)
    RLReport1: TRLReport;
    cdsRelatorio: TClientDataSet;
    cdsRelatorioCOD_PRODUTO: TIntegerField;
    cdsRelatorioCOD_BARRAS: TStringField;
    cdsRelatorioDESCRICAO: TStringField;
    cdsRelatorioESTOQUE_ATUAL: TBCDField;
    cdsRelatorioPRECO_VENDA: TBCDField;
    RLBand1: TRLBand;
    RLLabel1: TRLLabel;
    RLLabel2: TRLLabel;
    RLLabel3: TRLLabel;
    RLLabel4: TRLLabel;
    RLBand2: TRLBand;
    dsRelatorio: TDataSource;
    RLDBBarcode1: TRLDBBarcode;
    RLDBText1: TRLDBText;
    RLDBText2: TRLDBText;
    RLDBText3: TRLDBText;
    RLBand3: TRLBand;
    RLSystemInfo1: TRLSystemInfo;
    RLBand4: TRLBand;
    RLSystemInfo2: TRLSystemInfo;
    RLBand5: TRLBand;
    RLLabel5: TRLLabel;
    RLLabel6: TRLLabel;
    SaveDialog1: TSaveDialog;
    RLDBResult1: TRLDBResult;
    procedure RLLabel5BeforePrint(Sender: TObject; var Text: String;
      var PrintIt: Boolean);
    procedure RLLabel6BeforePrint(Sender: TObject; var Text: String;
      var PrintIt: Boolean);
  private
    { Private declarations }
    totalPgs: Integer;
  public
    { Public declarations }
    class function Execute(Save: Boolean = false): Boolean;
  end;

var
  FrmRelProdutos: TFrmRelProdutos;

implementation

uses UDMServer, Usuario;

{$R *.dfm}

class function TFrmRelProdutos.Execute(Save: Boolean): Boolean;
begin
   result:= false;
  {Esta linha deve ser recortada do arquivo do projeto
  (pressione CTRL+F12 para abrir o projeto)}
  Application.CreateForm(TFrmRelProdutos, FrmRelProdutos);
  try
    FrmRelProdutos.cdsRelatorio.Params[0].AsInteger := User.Cod_Empresa;
    FrmRelProdutos.cdsRelatorio.Open;
    if FrmRelProdutos.cdsRelatorio.RecordCount > 0 then
    begin
      FrmRelProdutos.SaveDialog1.FileName := FrmRelProdutos.RLReport1.Title;
      {Se  para salvar mas o usurio clicou
      em Cancelar na janela se seleo do nome do arquivo
      para o relatrio, ento sai da funo sem gerar
      o relatrio.}
      if Save and (not FrmRelProdutos.SaveDialog1.Execute) then
         exit;
         
      {Prepara o relatrio antes de imprimir para descobrir
      quantas pginas ele dar.}
      FrmRelProdutos.RLReport1.Prepare;
      {Pegar o total de pginas e armazenar na varivel privada totalPgs}
      FrmRelProdutos.totalPgs := FrmRelProdutos.RLReport1.LastPageNumber;
      if Save then
         FrmRelProdutos.RLReport1.SaveToFile(FrmRelProdutos.SaveDialog1.FileName)
      else FrmRelProdutos.RLReport1.PreviewModal;
      {Voc pode usar FrmRelProdutos.RLReport1.Preview();}
      result:= true;
    end
    else Application.MessageBox(
      'No existe nenhum registro a ser impresso',
      'Informao',
      MB_ICONINFORMATION);
  finally
    FrmRelProdutos.Free;
  end;
end;

procedure TFrmRelProdutos.RLLabel5BeforePrint(Sender: TObject;
  var Text: String; var PrintIt: Boolean);
begin
  {Text  um parmetro do procedure que representa
  o Caption do label. A funo format
   utilizada para montar uma string sem
  se preocupar com converses de tipo (o %d indica
  que aquela posio ser substituda por um nmero inteiro,
  os valores so o segundo parmetro da funo Format,
  que esto entre colchetes, representando um vetor de valores).
  O valor da varivel totalPgs ser obtido posteriormente.}
  Text:= Format('Pgina %d de %d', [RLReport1.PageNumber, totalPgs]);
end;

procedure TFrmRelProdutos.RLLabel6BeforePrint(Sender: TObject;
  var Text: String; var PrintIt: Boolean);
begin
  Text:= 'Data de Impresso: ' + FormatDateTime('dd/mm/yyyy', DMServer.DateServ);
end;

end.
