unit URelVendasPorFuncionario;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RLReport, DB, DBClient, RLBarcode;

type
  TFrmRelVendasPorFuncionario = class(TForm)
    RLReport1: TRLReport;
    cdsRelatorio: TClientDataSet;
    dsRelatorio: TDataSource;
    RLBand1: TRLBand;
    RLSystemInfo2: TRLSystemInfo;
    RLBand5: TRLBand;
    RLLabel5: TRLLabel;
    RLLabel6: TRLLabel;
    SaveDialog1: TSaveDialog;
    RLGroup1: TRLGroup;
    RLBand2: TRLBand;
    RLDBText1: TRLDBText;
    RLLabel2: TRLLabel;
    RLLabel3: TRLLabel;
    RLLabel4: TRLLabel;
    RLBand3: TRLBand;
    RLDBText2: TRLDBText;
    RLDBText3: TRLDBText;
    RLDBText4: TRLDBText;
    RLDBText5: TRLDBText;
    RLBand4: TRLBand;
    RLSystemInfo1: TRLSystemInfo;
    RLDBResult1: TRLDBResult;
    cdsRelatorioFUNCIONARIO: TStringField;
    cdsRelatorioDATA: TDateField;
    cdsRelatorioNOME_FORMA_PAGAMENTO: TStringField;
    cdsRelatorioVALOR_TOTAL: TBCDField;
    RLBand6: TRLBand;
    RLLabel1: TRLLabel;
    RLDBResult2: TRLDBResult;
    RLSystemInfo3: TRLSystemInfo;
    procedure RLLabel5BeforePrint(Sender: TObject; var Text: String;
      var PrintIt: Boolean);
    procedure RLLabel6BeforePrint(Sender: TObject; var Text: String;
      var PrintIt: Boolean);
  private
    { Private declarations }
    totalPgs: Integer;
  public
    { Public declarations }
    class function Execute(Mes, Ano: Integer; Save: Boolean = false): Boolean;
  end;

var
  FrmRelVendasPorFuncionario: TFrmRelVendasPorFuncionario;

implementation

uses UDMServer, Usuario;

{$R *.dfm}

class function TFrmRelVendasPorFuncionario.Execute(Mes, Ano: Integer; Save: Boolean = false): Boolean;
begin
   //Adicione a unite Usuario
   
   result:= false;
  {Esta linha deve ser recortada do arquivo do projeto
  (pressione CTRL+F12 para abrir o projeto)}
  Application.CreateForm(TFrmRelVendasPorFuncionario, FrmRelVendasPorFuncionario);
  with FrmRelVendasPorFuncionario do
  try
    cdsRelatorio.Params.ParamByName('COD_EMPRESA').AsInteger := User.Cod_Empresa;
    cdsRelatorio.Params.ParamByName('MES').AsInteger := Mes;
    cdsRelatorio.Params.ParamByName('ANO').AsInteger := Ano;
    cdsRelatorio.Open;
    if cdsRelatorio.RecordCount > 0 then
    begin
      SaveDialog1.FileName := RLReport1.Title;
      {Se  para salvar mas o usurio clicou
      em Cancelar na janela se seleo do nome do arquivo
      para o relatrio, ento sai da funo sem gerar
      o relatrio.}
      if Save and (not SaveDialog1.Execute) then
         exit;

      {Prepara o relatrio antes de imprimir para descobrir
      quantas pginas ele dar.}
      RLReport1.Prepare;
      {Pegar o total de pginas e armazenar na varivel privada totalPgs}
      totalPgs := RLReport1.LastPageNumber;
      if Save then
         RLReport1.SaveToFile(SaveDialog1.FileName)
      else RLReport1.PreviewModal;
      {Voc pode usar RLReport1.Preview();}
      result:= true;
    end
    else Application.MessageBox(
      'No existe nenhum registro a ser impresso',
      'Informao',
      MB_ICONINFORMATION);
  finally
    Free;
  end;
end;

procedure TFrmRelVendasPorFuncionario.RLLabel5BeforePrint(Sender: TObject;
  var Text: String; var PrintIt: Boolean);
begin
  {Text  um parmetro do procedure que representa
  o Caption do label. A funo format
   utilizada para montar uma string sem
  se preocupar com converses de tipo (o %d indica
  que aquela posio ser substituda por um nmero inteiro,
  os valores so o segundo parmetro da funo Format,
  que esto entre colchetes, representando um vetor de valores).
  O valor da varivel totalPgs ser obtido posteriormente.}
  Text:= Format('Pgina %d de %d', [RLReport1.PageNumber, totalPgs]);
end;

procedure TFrmRelVendasPorFuncionario.RLLabel6BeforePrint(Sender: TObject;
  var Text: String; var PrintIt: Boolean);
begin
  Text:= 'Data de Impresso: ' + FormatDateTime('dd/mm/yyyy', DMServer.DateServ);
end;

end.
