unit UUsuario;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, UCadastro, StdCtrls, Mask, DBCtrls, DB, ExtCtrls,
  Buttons;

type
  TFrmUsuario = class(TFrmCadastro)
    Label1: TLabel;
    DBEdit1: TDBEdit;
    Label3: TLabel;
    EdtFuncionario: TDBEdit;
    Label4: TLabel;
    EdtLogin: TDBEdit;
    Label5: TLabel;
    EdtSenha: TDBEdit;
    lbEdtConfirmacao: TLabeledEdit;
    btnLocalizarFunc: TSpeedButton;
    DBRadioGroup1: TDBRadioGroup;
    procedure EdtSenhaChange(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnLocalizarFuncClick(Sender: TObject);
    procedure btnNovoClick(Sender: TObject);
    procedure btnSalvarClick(Sender: TObject);
    procedure btnLocalizarClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FrmUsuario: TFrmUsuario;

implementation

uses UDMClient, ULocalizarCDS, UDMLocalizar;

{$R *.dfm}

procedure TFrmUsuario.EdtSenhaChange(Sender: TObject);
begin
  inherited;
  lbEdtConfirmacao.Visible := (DataSource1.State <> dsBrowse);
  lbEdtConfirmacao.clear;
end;

procedure TFrmUsuario.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  inherited;
  FrmUsuario := nil;
end;

procedure TFrmUsuario.btnLocalizarFuncClick(Sender: TObject);
begin
  inherited;
  try
    if TFrmLocalizarCDS.Execute('Localizar Funcionrio',
    dmLocalizar.cdsFuncionario, 'NOME;MATRICULA',
    'Nome;Matrcula') then
    begin
      DMClient.cdsUsuario.Edit;
      DMClient.cdsUsuarioCOD_Funcionario.AsInteger :=
        DMLocalizar.cdsFuncionarioCOD_Funcionario.AsInteger;
      DMClient.cdsUsuarioFuncionario.Text :=
        DMLocalizar.cdsFuncionarioNOME.Text;
    end;
  finally
    DMLocalizar.cdsFuncionario.Close;
  end;
end;

procedure TFrmUsuario.btnNovoClick(Sender: TObject);
begin
  inherited;
  //Selecionar o DBRadioGroup
  DBRadioGroup1.SetFocus;
  //Selecionar o primeiro item do DBRadioGroup
  ActiveControl := TWinControl(DBRadioGroup1.Controls[0]);
end;

procedure TFrmUsuario.btnSalvarClick(Sender: TObject);
begin
  if lbEdtConfirmacao.Visible then
  begin
    if Trim(lbEdtConfirmacao.Text) = '' then
    begin
       lbEdtConfirmacao.SetFocus;
       raise exception.create('Digite a confirmao da senha');
    end;

    if lbEdtConfirmacao.Text <> EdtSenha.Text then
    begin
       lbEdtConfirmacao.SetFocus;
       raise exception.create('A confirmao da senha no confere.');
    end;
  end;

  if EdtSenha.GetTextLen < 5 then
  begin
     EdtSenha.SetFocus;
     raise exception.create('A senha deve ter no mnimo 5 dgitos.');
  end;

  inherited;
  lbEdtConfirmacao.Visible := false;
end;

procedure TFrmUsuario.btnLocalizarClick(Sender: TObject);
begin
  inherited;
  try
    if TFrmLocalizarCDS.Execute('Localizar Usurio',
    dmLocalizar.cdsUsuario, 'LOGIN;MATRICULA;NOME',
    'Login;Matrcula;Nome') then
    begin
      DMClient.cdsUsuario.Close;
      DMClient.cdsUsuario.Params[0].Text :=
        DMLocalizar.cdsUsuarioCOD_Usuario.Text;
      DMClient.cdsUsuario.Open;
    end;
  finally
    DMLocalizar.cdsUsuario.close;
  end;
end;

end.
