unit uClasses;

interface

type
  {$TYPEINFO ON}
  TEndereco = class
  private
    FLogradouro: string;
    FBairro: string;
    FNumero: integer;
    FComplemento: string;
    procedure set_Bairro(const Value: string);
    procedure set_Complemento(const Value: string);
    procedure set_Logradouro(const Value: string);
    procedure set_Numero(const Value: integer);
  published
    property Logradouro: string read FLogradouro write set_Logradouro;
    property Numero: integer read FNumero write set_Numero;
    property Complemento: string read FComplemento write set_Complemento;
    property Bairro: string read FBairro write set_Bairro;
  end;

 {$METHODINFO ON}
  TCliente = class
  private
    FSobreNome: string;
    FNome: string;
    FEndereco: TEndereco;
    procedure set_Nome(const Value: string);
    procedure set_SobreNome(const Value: string);
    procedure set_Endereco(const Value: TEndereco);
  public
    constructor Create;virtual;
  published
    function NomeCompleto: string;
    property Nome: string read FNome write set_Nome;
    property SobreNome: string read FSobreNome write set_SobreNome;
    property Endereco: TEndereco read FEndereco write set_Endereco;
  end;
  {$TYPEINFO OFF}
  
implementation

uses
  SysUtils;

constructor TCliente.Create;
begin
  inherited;
  FEndereco := TEndereco.Create;
  FEndereco.Logradouro := 'Av. Rio Branco';
  FEndereco.Numero     := 26;
  FEndereco.Complemento:= 'sl 801';
  FEndereco.Bairro     := 'Centro';
  FNome     := 'Adilson';
  FSobreNome:= 'Jr';
end;

function TCliente.NomeCompleto: string;
begin
  result := FNome + ' ' + FSobreNome;
end;

procedure TCliente.set_Endereco(const Value: TEndereco);
begin
  FEndereco := Value;
end;

procedure TCliente.set_Nome(const Value: string);
begin
  FNome := Value;
end;

procedure TCliente.set_SobreNome(const Value: string);
begin
  FSobreNome := Value;
end;

procedure TEndereco.set_Bairro(const Value: string);
begin
  FBairro := Value;
end;

procedure TEndereco.set_Complemento(const Value: string);
begin
  FComplemento := Value;
end;

procedure TEndereco.set_Logradouro(const Value: string);
begin
  FLogradouro := Value;
end;

procedure TEndereco.set_Numero(const Value: integer);
begin
  FNumero := Value;
end;

end.
