unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, jpeg, ExtCtrls, ComCtrls, uClasses;

type
  TForm31 = class(TForm)
    TreeView1: TTreeView;
    Image1: TImage;
    btnCriar: TButton;
    procedure btnCriarClick(Sender: TObject);
    procedure TreeView1DblClick(Sender: TObject);
  private
    procedure GenerateNodes(Obj: TObject; Node: TTreeNode);
  end;

var
  Form31: TForm31;

implementation
    uses TypInfo, ObjAuto;

{$R *.dfm}

procedure TForm31.btnCriarClick(Sender: TObject);
begin
  GenerateNodes(TCliente.Create, nil);
end;

procedure TForm31.GenerateNodes(Obj: TObject; Node: TTreeNode);
var
  i: byte;
  InternalNode1, InternalNode2, InternalNode3: TTreeNode;
  //-----------------------------------------
  PropList: PPropList;
  PropListCount: byte;
  //-----------------------------------------
  MethodInfo: Pointer;
  MethodListCount: byte;
  Method: PMethodInfoHeader;
begin
  if Assigned(Node) then
    InternalNode1 := Node
  else
    InternalNode1 := TreeView1.Items.Add(nil, Obj.ClassName);

  //Propriedades
  InternalNode2 := TreeView1.Items.AddChild(InternalNode1, 'Propriedades');
  PropListCount := GetPropList(Obj, PropList);
  for i := 0 to Pred(PropListCount) do
  begin
    InternalNode3 := TreeView1.Items.AddChild(InternalNode2, PropList[i].Name);
      if PropType(Obj, PropList[i].Name) = tkClass then
        GenerateNodes(GetObjectProp(Obj, PropList[i].Name), InternalNode3);
  end;

  //Mtodos
  InternalNode2 := TreeView1.Items.AddChild(InternalNode1, 'Mtodos');
  MethodInfo := PPointer(Integer(PPointer(Obj)^) + vmtMethodTable)^;
  if MethodInfo <> nil then
  begin
    MethodListCount := PWord(MethodInfo)^;
    Inc(Integer(MethodInfo), 2);
    method := MethodInfo;
    for i := 0 to Pred(MethodListCount) do
    begin
      TreeView1.Items.AddChild(InternalNode2, Method.Name);
      Inc(integer(Method), PMethodInfoHeader(Method)^.Len);
    end;
  end;
end;


procedure TForm31.TreeView1DblClick(Sender: TObject);
var
  strNomeCompleto: string;
  Method: PMethodInfoHeader;
  Obj: TObject;
begin
  Obj := TCliente.Create;
  Method := GetMethodInfo(TCliente.Create, TreeView1.Selected.Text);
  strNomeCompleto := ObjectInvoke(Obj, Method, [], []);
  ShowMessage(strNomeCompleto);
end;

end.
