unit uClasses;

interface

type
  TEndereco = class
  private
    FLogradouro: System.&string;
    FBairro: System.&string;
    FNumero: integer;
    FComplemento: System.&string;
    procedure set_Bairro(const Value: System.&string);
    procedure set_Complemento(const Value: System.&string);
    procedure set_Logradouro(const Value: System.&string);
    procedure set_Numero(const Value: integer);
  published
    property Logradouro: System.&string read FLogradouro write set_Logradouro;
    property Numero: integer read FNumero write set_Numero;
    property Complemento: System.&string read FComplemento write set_Complemento;
    property Bairro: System.&string read FBairro write set_Bairro;
  end;

  TCliente = class
  private
    FSobreNome: System.&string;
    FNome: System.&string;
    FEndereco: TEndereco;
    procedure set_Nome(const Value: System.&string);
    procedure set_SobreNome(const Value: System.&string);
  public
    function NomeCompleto: System.&string;
    procedure set_Endereco(const Value: TEndereco);
    constructor Create;virtual;
  published
    property Nome: System.&string read FNome write set_Nome;
    property SobreNome: System.&string read FSobreNome write set_SobreNome;
    property Endereco: TEndereco read FEndereco write set_Endereco;
  end;

implementation

{ TCliente }

constructor TCliente.Create;
begin
  inherited;
  FEndereco := TEndereco.Create;

  FEndereco.Logradouro := 'Av. Rio Branco';
  FEndereco.Numero     := 26;
  FEndereco.Complemento:= 'sl 801';
  FEndereco.Bairro     := 'Centro';

  FNome     := 'Adilson';
  FSobreNome:= 'Jr';
end;

function TCliente.NomeCompleto: System.&string;
begin
  result := FNome + ' ' + FSobreNome;
end;

procedure TCliente.set_Endereco(const Value: TEndereco);
begin
  FEndereco := Value;
end;

procedure TCliente.set_Nome(const Value: System.&string);
begin
  FNome := Value;
end;

procedure TCliente.set_SobreNome(const Value: System.&string);
begin
  FSobreNome := Value;
end;

{ TEndereco }

procedure TEndereco.set_Bairro(const Value: System.&string);
begin
  FBairro := Value;
end;

procedure TEndereco.set_Complemento(const Value: System.&string);
begin
  FComplemento := Value;
end;

procedure TEndereco.set_Logradouro(const Value: System.&string);
begin
  FLogradouro := Value;
end;

procedure TEndereco.set_Numero(const Value: integer);
begin
  FNumero := Value;
end;

end.
